/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.sql;

import dev.entao.web.base.RefKt;
import dev.entao.web.base.StringExtKt;
import dev.entao.web.sql.ColumnInfo;
import dev.entao.web.sql.ConnectionBaseKt;
import dev.entao.web.sql.IndexInfo;
import dev.entao.web.sql.OrmMap;
import dev.entao.web.sql.OrmModel;
import dev.entao.web.sql.ResultSetXKt;
import dev.entao.web.sql.SQLBuilder;
import dev.entao.web.sql.SQLBuilderKt;
import dev.entao.web.sql.Where;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a7\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u00030\u0004j\u0002`\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\t\u001a/\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\f\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000b\u001a\u0012\u0010\u0012\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000b\u001a\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0017\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u001a"}, d2={"countAll", "", "Ljava/sql/Connection;", "cls", "Lkotlin/reflect/KClass;", "Ldev/entao/web/sql/TabClass;", "ws", "", "Ldev/entao/web/sql/Where;", "(Ljava/sql/Connection;Lkotlin/reflect/KClass;[Ldev/entao/web/sql/Where;)I", "tableName", "", "(Ljava/sql/Connection;Ljava/lang/String;[Ldev/entao/web/sql/Where;)I", "dumpIndex", "", "funExist", "", "funName", "procExist", "procName", "tableDesc", "", "Ldev/entao/web/sql/ColumnInfo;", "tableExists", "tableIndexList", "Ldev/entao/web/sql/IndexInfo;", "WebBasic"})
public final class ConnectionQueryKt {
    public static final int countAll(@NotNull Connection $this$countAll, @NotNull KClass<?> cls, Where ... ws) {
        Intrinsics.checkNotNullParameter((Object)$this$countAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        return ConnectionQueryKt.countAll($this$countAll, ConnectionBaseKt.getNameSQL(cls), Arrays.copyOf(ws, ws.length));
    }

    public static final int countAll(@NotNull Connection $this$countAll, @NotNull String tableName, Where ... ws) {
        Intrinsics.checkNotNullParameter((Object)$this$countAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        Integer n = ResultSetXKt.firstInt$default(SQLBuilderKt.querySQL($this$countAll, (Function1<? super SQLBuilder, Unit>)((Function1)new Function1<SQLBuilder, Unit>(tableName, ws){
            final /* synthetic */ String $tableName;
            final /* synthetic */ Where[] $ws;
            {
                this.$tableName = $tableName;
                this.$ws = $ws;
                super(1);
            }

            public final void invoke(@NotNull SQLBuilder $this$querySQL) {
                Intrinsics.checkNotNullParameter((Object)$this$querySQL, (String)"$this$querySQL");
                Object[] objectArray = new Object[]{$this$querySQL.COUNT("*")};
                $this$querySQL.select(objectArray);
                objectArray = new Object[]{this.$tableName};
                $this$querySQL.from(objectArray);
                $this$querySQL.where(Arrays.copyOf(this.$ws, this.$ws.length));
            }
        })), 0, 1, null);
        return n != null ? n : 0;
    }

    public static final boolean tableExists(@NotNull Connection $this$tableExists, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)$this$tableExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        String tname = ConnectionBaseKt.getTrimSQL(tableName);
        String[] stringArray = new String[]{"TABLE"};
        ResultSet rs = $this$tableExists.getMetaData().getTables($this$tableExists.getCatalog(), $this$tableExists.getSchema(), tname, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        OrmMap ormMap = ResultSetXKt.getFirstOrmMap(rs);
        if (ormMap == null) {
            return false;
        }
        OrmMap map = ormMap;
        Object object = map.get((Object)"TABLE_NAME");
        if (object == null || (object = object.toString()) == null) {
            Object object2 = map.get((Object)"table_name");
            object = object2 != null ? object2.toString() : "";
        }
        Object s2 = object;
        return Intrinsics.areEqual((Object)StringExtKt.getLowerCased((String)s2), (Object)StringExtKt.getLowerCased(tname));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ColumnInfo> tableDesc(@NotNull Connection $this$tableDesc, @NotNull String tableName) {
        void $this$mapTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$tableDesc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        DatabaseMetaData meta = $this$tableDesc.getMetaData();
        ResultSet rs = meta.getColumns($this$tableDesc.getCatalog(), $this$tableDesc.getSchema(), ConnectionBaseKt.getTrimSQL(tableName), "%");
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        ResultSet $this$toListOrmModel$iv = rs;
        boolean $i$f$toListOrmModel = false;
        Iterable $this$map$iv$iv = ResultSetXKt.toListOrmMap($this$toListOrmModel$iv);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            OrmMap ormMap = (OrmMap)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            OrmModel m$iv = (OrmModel)RefKt.createInstanceX(Reflection.getOrCreateKotlinClass(ColumnInfo.class), new Object[0]);
            m$iv.getModel().putAll((Map)it$iv);
            collection.add(m$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IndexInfo> tableIndexList(@NotNull Connection $this$tableIndexList, @NotNull String tableName) {
        void $this$mapTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$tableIndexList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        DatabaseMetaData meta = $this$tableIndexList.getMetaData();
        ResultSet rs = meta.getIndexInfo($this$tableIndexList.getCatalog(), $this$tableIndexList.getSchema(), ConnectionBaseKt.getTrimSQL(tableName), false, false);
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        ResultSet $this$toListOrmModel$iv = rs;
        boolean $i$f$toListOrmModel = false;
        Iterable $this$map$iv$iv = ResultSetXKt.toListOrmMap($this$toListOrmModel$iv);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            OrmMap ormMap = (OrmMap)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            OrmModel m$iv = (OrmModel)RefKt.createInstanceX(Reflection.getOrCreateKotlinClass(IndexInfo.class), new Object[0]);
            m$iv.getModel().putAll((Map)it$iv);
            collection.add(m$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    public static final boolean procExist(@NotNull Connection $this$procExist, @NotNull String procName) {
        Intrinsics.checkNotNullParameter((Object)$this$procExist, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)procName, (String)"procName");
        DatabaseMetaData meta = $this$procExist.getMetaData();
        ResultSet rs = meta.getProcedures($this$procExist.getCatalog(), $this$procExist.getSchema(), ConnectionBaseKt.getTrimSQL(procName));
        String string = ConnectionBaseKt.getTrimSQL(procName);
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return Intrinsics.areEqual((Object)string, (Object)ResultSetXKt.firstString(rs, "PROCEDURE_NAME"));
    }

    public static final boolean funExist(@NotNull Connection $this$funExist, @NotNull String funName) {
        Intrinsics.checkNotNullParameter((Object)$this$funExist, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)funName, (String)"funName");
        DatabaseMetaData meta = $this$funExist.getMetaData();
        ResultSet rs = meta.getFunctions($this$funExist.getCatalog(), $this$funExist.getSchema(), ConnectionBaseKt.getTrimSQL(funName));
        String string = ConnectionBaseKt.getTrimSQL(funName);
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        return Intrinsics.areEqual((Object)string, (Object)ResultSetXKt.firstString(rs, "FUNCTION_NAME"));
    }

    public static final void dumpIndex(@NotNull Connection $this$dumpIndex, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)$this$dumpIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        DatabaseMetaData meta = $this$dumpIndex.getMetaData();
        ResultSet rs = meta.getIndexInfo($this$dumpIndex.getCatalog(), $this$dumpIndex.getSchema(), ConnectionBaseKt.getTrimSQL(tableName), false, false);
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        ResultSetXKt.dump(rs);
    }
}

