/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import fmgp.crypto.Curve;
import fmgp.crypto.Curve$;
import fmgp.crypto.ECKey;
import fmgp.crypto.ECPrivateKey;
import fmgp.crypto.ECPublicKey;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKPPrivateKey;
import fmgp.crypto.OKPPublicKey;
import fmgp.crypto.OKP_EC_Key;
import fmgp.crypto.PrivateKey;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$;
import fmgp.crypto.error.CurveError;
import fmgp.crypto.error.UnsupportedCurve;
import fmgp.crypto.error.UnsupportedCurve$;
import fmgp.did.comm.SignedMessage;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.ZIO;
import zio.ZIO$;

public final class PlatformSpecificOperations$
implements Serializable {
    public static final PlatformSpecificOperations$ MODULE$ = new PlatformSpecificOperations$();

    private PlatformSpecificOperations$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlatformSpecificOperations$.class);
    }

    public ZIO<Object, CurveError, SignedMessage> sign(PrivateKey key, byte[] payload) {
        PrivateKey privateKey = key;
        if (privateKey instanceof OKPPrivateKey) {
            OKPPrivateKey oKPPrivateKey;
            OKPPrivateKey okp = oKPPrivateKey = (OKPPrivateKey)privateKey;
            Curve curve = okp.crv();
            Curve curve2 = Curve$.Ed25519;
            if (!(curve != null ? !curve.equals(curve2) : curve2 != null)) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> UtilsJVM$.MODULE$.signWithEd25519(UtilsJVM$.MODULE$.toJWK((OKPKey)okp), payload, ((OKP_EC_Key)key).jwaAlgorithmtoSign()), (Object)"fmgp.crypto.PlatformSpecificOperations.sign(PlatformSpecificOperations.scala:18)");
            }
            OKPPrivateKey okp2 = oKPPrivateKey;
            return ZIO$.MODULE$.fail(() -> this.sign$$anonfun$2(okp2), (Object)"fmgp.crypto.PlatformSpecificOperations.sign(PlatformSpecificOperations.scala:20)");
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey ec = (ECPrivateKey)privateKey;
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> UtilsJVM$.MODULE$.sign(UtilsJVM$.MODULE$.toJWK((ECKey)ec), payload, ((OKP_EC_Key)key).jwaAlgorithmtoSign()), (Object)"fmgp.crypto.PlatformSpecificOperations.sign(PlatformSpecificOperations.scala:22)");
        }
        throw new MatchError((Object)privateKey);
    }

    public ZIO<Object, Nothing$, Object> verify(PublicKey key, SignedMessage jwm) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> {
            PublicKey publicKey = key;
            if (publicKey instanceof OKPPublicKey) {
                OKPPublicKey okp = (OKPPublicKey)publicKey;
                return UtilsJVM$.MODULE$.verify(UtilsJVM$.MODULE$.toJWK((OKPKey)okp), jwm, ((OKP_EC_Key)key).jwaAlgorithmtoSign());
            }
            if (publicKey instanceof ECPublicKey) {
                ECPublicKey ec = (ECPublicKey)publicKey;
                return UtilsJVM$.MODULE$.verify(UtilsJVM$.MODULE$.toJWK((ECKey)ec), jwm, ((OKP_EC_Key)key).jwaAlgorithmtoSign());
            }
            throw new MatchError((Object)publicKey);
        }, (Object)"fmgp.crypto.PlatformSpecificOperations.verify(PlatformSpecificOperations.scala:29)");
    }

    private final UnsupportedCurve sign$$anonfun$2(OKPPrivateKey okp$2) {
        return UnsupportedCurve$.MODULE$.apply(okp$2.crv(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{Curve$.Ed25519})));
    }
}

