/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.Ed25519Signer;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.jwk.CurveBasedJWK;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.StandardCharset;
import fmgp.crypto.Curve;
import fmgp.crypto.Curve$;
import fmgp.crypto.ECKey;
import fmgp.crypto.JWAAlgorithm;
import fmgp.crypto.JWAAlgorithm$;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKP_EC_Key;
import fmgp.crypto.PrivateKey;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64_Base64URL$;
import fmgp.crypto.UtilsJVM$unsafe$;
import fmgp.crypto.error.UnsupportedCurve;
import fmgp.crypto.error.UnsupportedCurve$;
import fmgp.did.comm.JWMSignatureObj;
import fmgp.did.comm.JWMSignatureObj$;
import fmgp.did.comm.OpaqueTypes;
import fmgp.did.comm.SignProtectedHeader$;
import fmgp.did.comm.SignedMessage;
import fmgp.did.comm.SignedMessage$;
import fmgp.util.Base64;
import java.io.Serializable;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class UtilsJVM$
implements Serializable {
    public static final UtilsJVM$unsafe$ unsafe;
    public static final UtilsJVM$ MODULE$;

    private UtilsJVM$() {
    }

    static {
        MODULE$ = new UtilsJVM$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UtilsJVM$.class);
    }

    public JWSAlgorithm toJWSAlgorithm(JWAAlgorithm alg) {
        JWAAlgorithm jWAAlgorithm = alg;
        JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
        JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
        if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
            return JWSAlgorithm.ES256K;
        }
        JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
        JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
        if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
            return JWSAlgorithm.ES256;
        }
        JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
        JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
        if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
            return JWSAlgorithm.ES384;
        }
        JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
        JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
        if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
            return JWSAlgorithm.ES512;
        }
        JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
        JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
        if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
            return JWSAlgorithm.EdDSA;
        }
        throw new MatchError((Object)jWAAlgorithm);
    }

    public com.nimbusds.jose.jwk.Curve toJWKCurve(Curve curve) {
        Curve curve2 = curve;
        Curve curve3 = Curve$.P$minus256;
        Curve curve4 = curve2;
        if (!(curve3 != null ? !curve3.equals(curve4) : curve4 != null)) {
            return com.nimbusds.jose.jwk.Curve.P_256;
        }
        Curve curve5 = Curve$.P$minus384;
        Curve curve6 = curve2;
        if (!(curve5 != null ? !curve5.equals(curve6) : curve6 != null)) {
            return com.nimbusds.jose.jwk.Curve.P_384;
        }
        Curve curve7 = Curve$.P$minus521;
        Curve curve8 = curve2;
        if (!(curve7 != null ? !curve7.equals(curve8) : curve8 != null)) {
            return com.nimbusds.jose.jwk.Curve.P_521;
        }
        Curve curve9 = Curve$.secp256k1;
        Curve curve10 = curve2;
        if (!(curve9 != null ? !curve9.equals(curve10) : curve10 != null)) {
            return com.nimbusds.jose.jwk.Curve.SECP256K1;
        }
        Curve curve11 = Curve$.X25519;
        Curve curve12 = curve2;
        if (!(curve11 != null ? !curve11.equals(curve12) : curve12 != null)) {
            return com.nimbusds.jose.jwk.Curve.X25519;
        }
        Curve curve13 = Curve$.Ed25519;
        Curve curve14 = curve2;
        if (!(curve13 != null ? !curve13.equals(curve14) : curve14 != null)) {
            return com.nimbusds.jose.jwk.Curve.Ed25519;
        }
        throw new MatchError((Object)curve2);
    }

    public boolean ecKeyVerify(com.nimbusds.jose.jwk.ECKey ecKey, SignedMessage jwm, JWAAlgorithm alg) {
        com.nimbusds.jose.jwk.ECKey _key = ecKey.toPublicJWK();
        ECDSAVerifier verifier = new ECDSAVerifier(_key.toPublicJWK());
        JWSHeader header = new JWSHeader.Builder(this.toJWSAlgorithm(alg)).keyID(_key.getKeyID()).build();
        return verifier.verify(header, jwm.base64noSignature().getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)OpaqueTypes.package.SignatureJWM$.MODULE$.base64(((JWMSignatureObj)jwm.signatures().head()).signature())));
    }

    public SignedMessage ecKeySign(com.nimbusds.jose.jwk.ECKey ecKey, byte[] payload, JWAAlgorithm alg) {
        Object object;
        Predef$.MODULE$.require(ecKey.isPrivate(), this::ecKeySign$$anonfun$1);
        ECDSASigner signer = new ECDSASigner(ecKey);
        JWSHeader header = new JWSHeader.Builder(this.toJWSAlgorithm(alg)).keyID(ecKey.getKeyID()).build();
        Payload payloadObj = new Payload(payload);
        JWSObject jwsObject = new JWSObject(header, payloadObj);
        jwsObject.sign((JWSSigner)signer);
        String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(jwsObject.serialize()), '.');
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 3) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
            String protectedValue = string;
            String payload2 = string2;
            String signature = string3;
            String string4 = payload2;
            String string5 = payloadObj.toBase64URL().toString();
            if (string4 == null ? string5 != null : !string4.equals(string5)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            String string6 = signature;
            String string7 = jwsObject.getSignature().toString();
            if (string6 == null ? string7 != null : !string6.equals(string7)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            return SignedMessage$.MODULE$.apply(OpaqueTypes.package.Payload$.MODULE$.fromBase64url(payload2), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JWMSignatureObj[]{JWMSignatureObj$.MODULE$.apply(Base64.package.Base64$.MODULE$.unsafeAsObj(Base64.package.Base64$.MODULE$.apply(protectedValue), SignProtectedHeader$.MODULE$.decoder()), OpaqueTypes.package.SignatureJWM$.MODULE$.apply(signature), (Option)None$.MODULE$)})));
        }
        throw new MatchError((Object)stringArray);
    }

    public boolean okpKeyVerifyWithEd25519(OctetKeyPair okpKey, SignedMessage jwm, JWAAlgorithm alg) {
        OctetKeyPair _key = okpKey.toPublicJWK();
        Ed25519Verifier verifier = new Ed25519Verifier(_key.toPublicJWK());
        JWSHeader header = new JWSHeader.Builder(this.toJWSAlgorithm(alg)).keyID(_key.getKeyID()).build();
        return verifier.verify(header, jwm.base64noSignature().getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)OpaqueTypes.package.SignatureJWM$.MODULE$.base64(((JWMSignatureObj)jwm.signatures().head()).signature())));
    }

    public SignedMessage okpKeySignWithEd25519(OctetKeyPair okpKey, byte[] payload, JWAAlgorithm alg) {
        Object object;
        Predef$.MODULE$.require(okpKey.isPrivate(), this::okpKeySignWithEd25519$$anonfun$1);
        String string = okpKey.getCurve().getName();
        String string2 = com.nimbusds.jose.jwk.Curve.Ed25519.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"This method can only be call with Curve.Ed25519");
        }
        Ed25519Signer signer = new Ed25519Signer(okpKey);
        JWSHeader header = new JWSHeader.Builder(this.toJWSAlgorithm(alg)).keyID(okpKey.getKeyID()).build();
        Payload payloadObj = new Payload(payload);
        JWSObject jwsObject = new JWSObject(header, payloadObj);
        jwsObject.sign((JWSSigner)signer);
        String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(jwsObject.serialize()), '.');
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 3) == 0) {
            String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string4 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String string5 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
            String protectedValue = string3;
            String payload2 = string4;
            String signature = string5;
            String string6 = payload2;
            String string7 = payloadObj.toBase64URL().toString();
            if (string6 == null ? string7 != null : !string6.equals(string7)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            String string8 = signature;
            String string9 = jwsObject.getSignature().toString();
            if (string8 == null ? string9 != null : !string8.equals(string9)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            return SignedMessage$.MODULE$.apply(OpaqueTypes.package.Payload$.MODULE$.fromBase64url(payload2), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JWMSignatureObj[]{JWMSignatureObj$.MODULE$.apply(Base64.package.Base64$.MODULE$.unsafeAsObj(Base64.package.Base64$.MODULE$.apply(protectedValue), SignProtectedHeader$.MODULE$.decoder()), OpaqueTypes.package.SignatureJWM$.MODULE$.apply(signature), (Option)None$.MODULE$)})));
        }
        throw new MatchError((Object)stringArray);
    }

    public CurveBasedJWK toJWK(OKP_EC_Key key) {
        OKP_EC_Key oKP_EC_Key = key;
        if (oKP_EC_Key instanceof ECKey) {
            ECKey ec = (ECKey)oKP_EC_Key;
            return this.toJWK(ec);
        }
        if (oKP_EC_Key instanceof OKPKey) {
            OKPKey okp = (OKPKey)oKP_EC_Key;
            return this.okpKey2JWK(okp);
        }
        throw new MatchError((Object)oKP_EC_Key);
    }

    public OctetKeyPair toJWK(OKPKey okp) {
        return this.okpKey2JWK(okp);
    }

    public com.nimbusds.jose.jwk.ECKey toJWK(ECKey ec) {
        return this.ecKey2JWK(ec);
    }

    public com.nimbusds.jose.jwk.ECKey ecKey2JWK(ECKey ec) {
        BoxedUnit boxedUnit;
        ECKey.Builder builder;
        Vector x = Base64.package.Base64$.MODULE$.fromBase64url(ec.x());
        Vector y = Base64.package.Base64$.MODULE$.fromBase64url(ec.y());
        Curve curve = ec.getCurve();
        if (curve == Curve$.P$minus256) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else if (curve == Curve$.P$minus384) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else if (curve == Curve$.P$minus521) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else if (curve == Curve$.secp256k1) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else {
            throw new MatchError((Object)curve);
        }
        ECKey.Builder builder2 = builder;
        ec.kid().foreach((Function1 & Serializable)x$0 -> builder2.keyID(x$0));
        ECKey eCKey = ec;
        if (eCKey instanceof PublicKey) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (eCKey instanceof PrivateKey) {
            ECKey k = (ECKey)((PrivateKey)eCKey);
            boxedUnit = builder2.d(UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(((PrivateKey)k).d())));
        } else {
            throw new MatchError((Object)eCKey);
        }
        return builder2.build();
    }

    public OctetKeyPair okpKey2JWK(OKPKey okp) {
        BoxedUnit boxedUnit;
        OctetKeyPair.Builder builder;
        Curve curve = okp.getCurve();
        if (curve == Curve$.Ed25519) {
            Curve c = curve;
            builder = new OctetKeyPair.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(okp.x())));
        } else if (curve == Curve$.X25519) {
            Curve c = curve;
            builder = new OctetKeyPair.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(okp.x())));
        } else {
            throw new MatchError((Object)curve);
        }
        OctetKeyPair.Builder builder2 = builder;
        okp.kid().foreach((Function1 & Serializable)x$0 -> builder2.keyID(x$0));
        OKPKey oKPKey = okp;
        if (oKPKey instanceof PublicKey) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (oKPKey instanceof PrivateKey) {
            OKPKey k = (OKPKey)((PrivateKey)oKPKey);
            boxedUnit = builder2.d(UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(((PrivateKey)k).d())));
        } else {
            throw new MatchError((Object)oKPKey);
        }
        return builder2.build();
    }

    public Either<UnsupportedCurve, Object> verify(PublicKey key, SignedMessage jwm) {
        CurveBasedJWK curveBasedJWK = this.toJWK((OKP_EC_Key)key);
        if (curveBasedJWK instanceof com.nimbusds.jose.jwk.ECKey) {
            com.nimbusds.jose.jwk.ECKey ecKey = (com.nimbusds.jose.jwk.ECKey)curveBasedJWK;
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)this.ecKeyVerify(ecKey, jwm, ((OKP_EC_Key)key).jwaAlgorithmtoSign())));
        }
        if (curveBasedJWK instanceof OctetKeyPair) {
            OctetKeyPair octetKeyPair;
            OctetKeyPair okpKey = octetKeyPair = (OctetKeyPair)curveBasedJWK;
            Curve curve = ((OKP_EC_Key)key).crv();
            Curve curve2 = Curve$.Ed25519;
            if (!(curve != null ? !curve.equals(curve2) : curve2 != null)) {
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)this.okpKeyVerifyWithEd25519(okpKey, jwm, ((OKP_EC_Key)key).jwaAlgorithmtoSign())));
            }
            OctetKeyPair okpKey2 = octetKeyPair;
            return package$.MODULE$.Left().apply((Object)UnsupportedCurve$.MODULE$.apply(((OKP_EC_Key)key).crv(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{Curve$.Ed25519}))));
        }
        throw new MatchError((Object)curveBasedJWK);
    }

    public Either<UnsupportedCurve, SignedMessage> sign(PrivateKey key, byte[] payload) {
        CurveBasedJWK curveBasedJWK = this.toJWK((OKP_EC_Key)key.toPublicKey());
        if (curveBasedJWK instanceof com.nimbusds.jose.jwk.ECKey) {
            com.nimbusds.jose.jwk.ECKey ecKey = (com.nimbusds.jose.jwk.ECKey)curveBasedJWK;
            return package$.MODULE$.Right().apply((Object)this.ecKeySign(ecKey, payload, ((OKP_EC_Key)key).jwaAlgorithmtoSign()));
        }
        if (curveBasedJWK instanceof OctetKeyPair) {
            OctetKeyPair octetKeyPair;
            OctetKeyPair okpKey = octetKeyPair = (OctetKeyPair)curveBasedJWK;
            Curve curve = ((OKP_EC_Key)key).crv();
            Curve curve2 = Curve$.Ed25519;
            if (!(curve != null ? !curve.equals(curve2) : curve2 != null)) {
                return package$.MODULE$.Right().apply((Object)this.okpKeySignWithEd25519(okpKey, payload, ((OKP_EC_Key)key).jwaAlgorithmtoSign()));
            }
            OctetKeyPair okpKey2 = octetKeyPair;
            return package$.MODULE$.Left().apply((Object)UnsupportedCurve$.MODULE$.apply(((OKP_EC_Key)key).crv(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{Curve$.Ed25519}))));
        }
        throw new MatchError((Object)curveBasedJWK);
    }

    private final Object ecKeySign$$anonfun$1() {
        return "EC JWK must include the private key (d)";
    }

    private final Object okpKeySignWithEd25519$$anonfun$1() {
        return "EC JWK must include the private key (d)";
    }
}

