/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import com.google.crypto.tink.subtle.X25519;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.impl.AAD;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.crypto.impl.ECDH1PU;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.Base64URL;
import fmgp.crypto.Curve;
import fmgp.crypto.ECDH_AuthCryptoProvider;
import fmgp.crypto.ECDH_AuthCryptoProvider$;
import fmgp.crypto.ECDH_UtilsOKP;
import fmgp.crypto.JWERecipient;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKPPublicKey;
import fmgp.crypto.OKPPublicKey$;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64_Base64URL$;
import fmgp.crypto.UtilsJVM$unsafe$given_Conversion_ENCAlgorithm_EncryptionMethod$;
import fmgp.crypto.UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$;
import fmgp.crypto.error.CryptoErrorCollection$;
import fmgp.crypto.error.CryptoFailToParse$;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.KeyMissingEpkJWEHeader$;
import fmgp.crypto.error.SomeThrowable$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.comm.AuthHeaderBuilder;
import fmgp.did.comm.AuthProtectedHeader;
import fmgp.did.comm.EncryptedMessageGeneric;
import fmgp.did.comm.ProtectedHeader;
import fmgp.did.comm.ProtectedHeader$;
import fmgp.util.Base64;
import fmgp.util.Base64$package$;
import fmgp.util.Base64Obj;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.Tuple7;
import scala.Tuple7$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.json.package;

public final class ECDH_AuthOKP$
implements ECDH_UtilsOKP,
Serializable {
    public static final ECDH_AuthOKP$ MODULE$ = new ECDH_AuthOKP$();

    private ECDH_AuthOKP$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ECDH_AuthOKP$.class);
    }

    public Either<CryptoFailed, EncryptedMessageGeneric> encrypt(OKPKey sender, Seq<Tuple2<VerificationMethodReferenced, OKPKey>> okpRecipientsKeys, AuthHeaderBuilder header, byte[] clearText) {
        return this.getCurve((Seq)okpRecipientsKeys).map((Function1 & Serializable)_$6 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$6)).map((Function1 & Serializable)curve -> {
            byte[] ephemeralPrivateKeyBytes = X25519.generatePrivateKey();
            byte[] ephemeralPublicKeyBytes = (byte[])Try$.MODULE$.apply(() -> this.$anonfun$3(ephemeralPrivateKeyBytes)).recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof InvalidKeyException) {
                        InvalidKeyException ex = (InvalidKeyException)throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof InvalidKeyException) {
                        InvalidKeyException ex = (InvalidKeyException)throwable;
                        throw ex;
                    }
                    return function1.apply((Object)x);
                }
            }).get();
            Base64$package$ base64$package$ = Base64$package$.MODULE$;
            Base64.package.Base64$ Base64$_this = Base64.package.Base64$.MODULE$;
            Base64$package$ Base64$package$_this = base64$package$;
            Base64$package$ base64$package$2 = Base64$package$.MODULE$;
            Base64.package.Base64$ Base64$_this2 = Base64.package.Base64$.MODULE$;
            Base64$package$ Base64$package$_this2 = base64$package$2;
            OctetKeyPair ephemeralPrivateKey = new OctetKeyPair.Builder(curve, UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Predef$.MODULE$.wrapByteArray(Base64$_this.urlEncoder().encode(ephemeralPublicKeyBytes)).toVector())).d(UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Predef$.MODULE$.wrapByteArray(Base64$_this2.urlEncoder().encode(ephemeralPrivateKeyBytes)).toVector())).build();
            OctetKeyPair ephemeralPublicKey = ephemeralPrivateKey.toPublicJWK();
            return Tuple5$.MODULE$.apply(curve, (Object)ephemeralPrivateKeyBytes, (Object)ephemeralPublicKeyBytes, (Object)ephemeralPrivateKey, (Object)ephemeralPublicKey);
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple5 tuple5 = x$12;
            if (tuple5 != null) {
                byte[] byArray = (byte[])tuple5._2();
                byte[] byArray2 = (byte[])tuple5._3();
                OctetKeyPair octetKeyPair = (OctetKeyPair)tuple5._4();
                OctetKeyPair octetKeyPair2 = (OctetKeyPair)tuple5._5();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple5._1();
                if (byArray instanceof byte[]) {
                    byte[] ephemeralPrivateKeyBytes = byArray;
                    if (byArray2 instanceof byte[]) {
                        byte[] ephemeralPublicKeyBytes = byArray2;
                        if (octetKeyPair != null) {
                            OctetKeyPair ephemeralPrivateKey = octetKeyPair;
                            if (octetKeyPair2 != null) {
                                OctetKeyPair ephemeralPublicKey = octetKeyPair2;
                                return package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)ephemeralPublicKey.toJSONString()), OKPPublicKey$.MODULE$.decoder()).left().map((Function1 & Serializable)_$7 -> CryptoFailToParse$.MODULE$.apply(_$7)).map((Function1 & Serializable)okpKeyEphemeral -> {
                                    AuthProtectedHeader updatedHeader = header.buildWithKey((PublicKey)okpKeyEphemeral);
                                    byte[] updatedAAD = AAD.compute((JWEHeader)UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$.MODULE$.apply((ProtectedHeader)updatedHeader));
                                    Seq sharedSecrets = (Seq)okpRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                                        Tuple2 tuple2 = x$1;
                                        if (tuple2 != null) {
                                            VerificationMethodReferenced vmr = (VerificationMethodReferenced)tuple2._1();
                                            OKPKey key = (OKPKey)tuple2._2();
                                            return Tuple2$.MODULE$.apply((Object)vmr, (Object)ECDH1PU.deriveSenderZ((OctetKeyPair)UtilsJVM$.MODULE$.toJWK(sender), (OctetKeyPair)UtilsJVM$.MODULE$.toJWK(key), (OctetKeyPair)ephemeralPrivateKey));
                                        }
                                        throw new MatchError((Object)tuple2);
                                    });
                                    SecretKey cek = ContentCryptoProvider.generateCEK((EncryptionMethod)UtilsJVM$unsafe$given_Conversion_ENCAlgorithm_EncryptionMethod$.MODULE$.apply(updatedHeader.enc()), (SecureRandom)new SecureRandom());
                                    ECDH_AuthCryptoProvider myProvider = new ECDH_AuthCryptoProvider(curve, cek);
                                    EncryptedMessageGeneric ret = myProvider.encryptAUX((ProtectedHeader)updatedHeader, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, clearText, updatedAAD);
                                    return Tuple7$.MODULE$.apply(okpKeyEphemeral, (Object)updatedHeader, (Object)updatedAAD, (Object)sharedSecrets, (Object)cek, (Object)myProvider, (Object)ret);
                                }).map((Function1 & Serializable)x$1 -> {
                                    Tuple7 tuple7 = x$1;
                                    if (tuple7 != null) {
                                        SecretKey secretKey = (SecretKey)tuple7._5();
                                        OKPPublicKey okpKeyEphemeral = (OKPPublicKey)tuple7._1();
                                        AuthProtectedHeader updatedHeader = (AuthProtectedHeader)tuple7._2();
                                        byte[] updatedAAD = (byte[])tuple7._3();
                                        Seq sharedSecrets = (Seq)tuple7._4();
                                        if (secretKey != null) {
                                            SecretKey cek = secretKey;
                                            ECDH_AuthCryptoProvider myProvider = (ECDH_AuthCryptoProvider)tuple7._6();
                                            EncryptedMessageGeneric ret = (EncryptedMessageGeneric)tuple7._7();
                                            return ret;
                                        }
                                    }
                                    throw new MatchError((Object)tuple7);
                                });
                            }
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple5);
        });
    }

    public Either<CryptoFailed, byte[]> decrypt(OKPKey sender, Seq<Tuple2<VerificationMethodReferenced, OKPKey>> okpRecipientsKeys, Base64Obj<ProtectedHeader> header, Seq<JWERecipient> recipients, String iv, String cipherText, String authTag) {
        return this.getCurve((Seq)okpRecipientsKeys).map((Function1 & Serializable)_$8 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$8)).map((Function1 & Serializable)curve -> {
            CriticalHeaderParamsDeferral aux = new CriticalHeaderParamsDeferral();
            aux.ensureHeaderPasses(UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header));
            CriticalHeaderParamsDeferral critPolicy = aux;
            return Tuple2$.MODULE$.apply(curve, (Object)critPolicy);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                CriticalHeaderParamsDeferral criticalHeaderParamsDeferral = (CriticalHeaderParamsDeferral)tuple2._2();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple2._1();
                if (criticalHeaderParamsDeferral != null) {
                    CriticalHeaderParamsDeferral critPolicy = criticalHeaderParamsDeferral;
                    return Option$.MODULE$.apply((Object)UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header).getEphemeralPublicKey()).map((Function1 & Serializable)_$9 -> (OctetKeyPair)_$9).toRight(this::decrypt$$anonfun$6$$anonfun$2).flatMap((Function1 & Serializable)ephemeralPublicKey -> CryptoErrorCollection$.MODULE$.unfold((Seq)okpRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 instanceof Tuple2) {
                            Tuple2 recipient = tuple2;
                            OctetKeyPair recipientKey = UtilsJVM$.MODULE$.toJWK((OKPKey)recipient._2());
                            Either either = Try$.MODULE$.apply(() -> this.decrypt$$anonfun$6$$anonfun$3$$anonfun$1$$anonfun$1(recipientKey, sender, ephemeralPublicKey)).toEither();
                            if (either instanceof Left) {
                                Throwable ex = (Throwable)((Left)either).value();
                                return package$.MODULE$.Left().apply((Object)SomeThrowable$.MODULE$.apply(ex));
                            }
                            if (either instanceof Right) {
                                SecretKey z = (SecretKey)((Right)either).value();
                                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply(recipient._1(), (Object)z));
                            }
                            throw new MatchError((Object)either);
                        }
                        throw new MatchError((Object)tuple2);
                    })).flatMap((Function1 & Serializable)sharedSecrets -> ECDH_AuthCryptoProvider$.MODULE$.apply(curve, null).decryptAUX(header, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, recipients, iv, cipherText, authTag, AAD.compute((Base64URL)new Base64URL(header.base64url(ProtectedHeader$.MODULE$.encoder())))).map((Function1 & Serializable)ret -> ret)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final byte[] $anonfun$3(byte[] ephemeralPrivateKeyBytes$2) {
        return X25519.publicFromPrivate((byte[])ephemeralPrivateKeyBytes$2);
    }

    private final KeyMissingEpkJWEHeader$ decrypt$$anonfun$6$$anonfun$2() {
        return KeyMissingEpkJWEHeader$.MODULE$;
    }

    private final SecretKey decrypt$$anonfun$6$$anonfun$3$$anonfun$1$$anonfun$1(OctetKeyPair recipientKey$2, OKPKey sender$6, OctetKeyPair ephemeralPublicKey$3) {
        return ECDH1PU.deriveRecipientZ((OctetKeyPair)recipientKey$2, (OctetKeyPair)UtilsJVM$.MODULE$.toJWK(sender$6).toPublicJWK(), (OctetKeyPair)ephemeralPublicKey$3);
    }
}

