/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.impl.AAD;
import com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.crypto.impl.ECDH1PU;
import com.nimbusds.jose.crypto.utils.ECChecks;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jose.util.Base64URL;
import fmgp.crypto.Curve;
import fmgp.crypto.ECDH_AuthCryptoProvider;
import fmgp.crypto.ECDH_UtilsEC;
import fmgp.crypto.ECKey;
import fmgp.crypto.ECPublicKey;
import fmgp.crypto.ECPublicKey$;
import fmgp.crypto.JWERecipient;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$;
import fmgp.crypto.UtilsJVM$unsafe$given_Conversion_ENCAlgorithm_EncryptionMethod$;
import fmgp.crypto.UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$;
import fmgp.crypto.error.CryptoErrorCollection$;
import fmgp.crypto.error.CryptoFailToParse$;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.KeyMissingEpkJWEHeader$;
import fmgp.crypto.error.PointNotOnCurve$;
import fmgp.crypto.error.SomeThrowable$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.comm.AuthHeaderBuilder;
import fmgp.did.comm.AuthProtectedHeader;
import fmgp.did.comm.EncryptedMessageGeneric;
import fmgp.did.comm.ProtectedHeader;
import fmgp.did.comm.ProtectedHeader$;
import fmgp.util.Base64Obj;
import java.io.Serializable;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import javax.crypto.SecretKey;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple7;
import scala.Tuple7$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.json.package;

public final class ECDH_AuthEC$
implements ECDH_UtilsEC,
Serializable {
    public static final ECDH_AuthEC$ MODULE$ = new ECDH_AuthEC$();

    private ECDH_AuthEC$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ECDH_AuthEC$.class);
    }

    public Either<CryptoFailed, EncryptedMessageGeneric> encrypt(ECKey sender, Seq<Tuple2<VerificationMethodReferenced, ECKey>> ecRecipientsKeys, AuthHeaderBuilder header, byte[] clearText) {
        return this.getCurve((Seq)ecRecipientsKeys).map((Function1 & Serializable)_$6 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$6)).map((Function1 & Serializable)curve -> {
            com.nimbusds.jose.jwk.ECKey ephemeralKeyPair = new ECKeyGenerator(curve).generate();
            java.security.interfaces.ECPublicKey ephemeralPublicKey = ephemeralKeyPair.toECPublicKey();
            ECPrivateKey ephemeralPrivateKey = ephemeralKeyPair.toECPrivateKey();
            return Tuple4$.MODULE$.apply(curve, (Object)ephemeralKeyPair, (Object)ephemeralPublicKey, (Object)ephemeralPrivateKey);
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple4 tuple4 = x$12;
            if (tuple4 != null) {
                com.nimbusds.jose.jwk.ECKey eCKey = (com.nimbusds.jose.jwk.ECKey)tuple4._2();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple4._1();
                if (eCKey != null) {
                    com.nimbusds.jose.jwk.ECKey ephemeralKeyPair = eCKey;
                    java.security.interfaces.ECPublicKey ephemeralPublicKey = (java.security.interfaces.ECPublicKey)tuple4._3();
                    ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)tuple4._4();
                    return package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)ephemeralKeyPair.toJSONString()), ECPublicKey$.MODULE$.decoder()).left().map((Function1 & Serializable)_$7 -> CryptoFailToParse$.MODULE$.apply(_$7)).map((Function1 & Serializable)ecKeyEphemeral -> {
                        AuthProtectedHeader updatedHeader = header.buildWithKey((PublicKey)ecKeyEphemeral);
                        byte[] updatedAAD = AAD.compute((JWEHeader)UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$.MODULE$.apply((ProtectedHeader)updatedHeader));
                        SecretKey cek = ContentCryptoProvider.generateCEK((EncryptionMethod)UtilsJVM$unsafe$given_Conversion_ENCAlgorithm_EncryptionMethod$.MODULE$.apply(updatedHeader.enc()), (SecureRandom)new SecureRandom());
                        ECDH_AuthCryptoProvider myProvider = new ECDH_AuthCryptoProvider(curve, cek);
                        Seq sharedSecrets = (Seq)ecRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                VerificationMethodReferenced vmr = (VerificationMethodReferenced)tuple2._1();
                                ECKey key = (ECKey)tuple2._2();
                                Object use_the_defualt_JCA_Provider = null;
                                return Tuple2$.MODULE$.apply((Object)vmr, (Object)ECDH1PU.deriveSenderZ((ECPrivateKey)UtilsJVM$.MODULE$.toJWK(sender).toECPrivateKey(), (java.security.interfaces.ECPublicKey)UtilsJVM$.MODULE$.toJWK(key).toECPublicKey(), (ECPrivateKey)ephemeralPrivateKey, null));
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        EncryptedMessageGeneric ret = myProvider.encryptAUX((ProtectedHeader)updatedHeader, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, clearText, updatedAAD);
                        return Tuple7$.MODULE$.apply(ecKeyEphemeral, (Object)updatedHeader, (Object)updatedAAD, (Object)cek, (Object)myProvider, (Object)sharedSecrets, (Object)ret);
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple7 tuple7 = x$1;
                        if (tuple7 != null) {
                            SecretKey secretKey = (SecretKey)tuple7._4();
                            ECPublicKey ecKeyEphemeral = (ECPublicKey)tuple7._1();
                            AuthProtectedHeader updatedHeader = (AuthProtectedHeader)tuple7._2();
                            byte[] updatedAAD = (byte[])tuple7._3();
                            if (secretKey != null) {
                                SecretKey cek = secretKey;
                                ECDH_AuthCryptoProvider myProvider = (ECDH_AuthCryptoProvider)tuple7._5();
                                Seq sharedSecrets = (Seq)tuple7._6();
                                EncryptedMessageGeneric ret = (EncryptedMessageGeneric)tuple7._7();
                                return ret;
                            }
                        }
                        throw new MatchError((Object)tuple7);
                    });
                }
            }
            throw new MatchError((Object)tuple4);
        });
    }

    public Either<CryptoFailed, byte[]> decrypt(ECKey sender, Seq<Tuple2<VerificationMethodReferenced, ECKey>> ecRecipientsKeys, Base64Obj<ProtectedHeader> header, Seq<JWERecipient> recipients, String iv, String cipherText, String authTag) {
        return this.getCurve((Seq)ecRecipientsKeys).map((Function1 & Serializable)_$8 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$8)).map((Function1 & Serializable)curve -> {
            void var3_2;
            CriticalHeaderParamsDeferral aux = new CriticalHeaderParamsDeferral();
            aux.ensureHeaderPasses(UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header));
            void critPolicy = var3_2;
            return Tuple2$.MODULE$.apply(curve, (Object)critPolicy);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                CriticalHeaderParamsDeferral criticalHeaderParamsDeferral = (CriticalHeaderParamsDeferral)tuple2._2();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple2._1();
                if (criticalHeaderParamsDeferral != null) {
                    CriticalHeaderParamsDeferral critPolicy = criticalHeaderParamsDeferral;
                    return Option$.MODULE$.apply((Object)UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header).getEphemeralPublicKey()).map((Function1 & Serializable)_$9 -> (com.nimbusds.jose.jwk.ECKey)_$9).toRight(ECDH_AuthEC$::decrypt$$anonfun$6$$anonfun$2).flatMap((Function1 & Serializable)ephemeralKey -> CryptoErrorCollection$.MODULE$.unfold((Seq)ecRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 instanceof Tuple2) {
                            Tuple2 recipient = tuple2;
                            com.nimbusds.jose.jwk.ECKey recipientKey = UtilsJVM$.MODULE$.toJWK((ECKey)recipient._2());
                            if (!ECChecks.isPointOnCurve((java.security.interfaces.ECPublicKey)ephemeralKey.toECPublicKey(), (ECPrivateKey)recipientKey.toECPrivateKey())) {
                                return package$.MODULE$.Left().apply((Object)PointNotOnCurve$.MODULE$.apply("Curve of ephemeral public key does not match curve of private key"));
                            }
                            Either either = Try$.MODULE$.apply(() -> ECDH_AuthEC$.decrypt$$anonfun$6$$anonfun$3$$anonfun$1$$anonfun$1(recipientKey, sender, ephemeralKey)).toEither();
                            if (either instanceof Left) {
                                Throwable ex = (Throwable)((Left)either).value();
                                return package$.MODULE$.Left().apply((Object)SomeThrowable$.MODULE$.apply(ex));
                            }
                            if (either instanceof Right) {
                                SecretKey z = (SecretKey)((Right)either).value();
                                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply(recipient._1(), (Object)z));
                            }
                            throw new MatchError((Object)either);
                        }
                        throw new MatchError((Object)tuple2);
                    })).flatMap((Function1 & Serializable)sharedSecrets -> new ECDH_AuthCryptoProvider(curve, null).decryptAUX(header, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, recipients, iv, cipherText, authTag, AAD.compute((Base64URL)new Base64URL(header.base64url(ProtectedHeader$.MODULE$.encoder())))).map((Function1 & Serializable)ret -> ret)));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final KeyMissingEpkJWEHeader$ decrypt$$anonfun$6$$anonfun$2() {
        return KeyMissingEpkJWEHeader$.MODULE$;
    }

    private static final SecretKey decrypt$$anonfun$6$$anonfun$3$$anonfun$1$$anonfun$1(com.nimbusds.jose.jwk.ECKey recipientKey$2, ECKey sender$7, com.nimbusds.jose.jwk.ECKey ephemeralKey$4) {
        return ECDH1PU.deriveRecipientZ((ECPrivateKey)recipientKey$2.toECPrivateKey(), (java.security.interfaces.ECPublicKey)UtilsJVM$.MODULE$.toJWK(sender$7).toECPublicKey(), (java.security.interfaces.ECPublicKey)ephemeralKey$4.toECPublicKey(), null);
    }
}

