/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.Ed25519Signer;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.jwk.CurveBasedJWK;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.StandardCharset;
import fmgp.crypto.Curve;
import fmgp.crypto.Curve$;
import fmgp.crypto.ECKey;
import fmgp.crypto.JWAAlgorithm;
import fmgp.crypto.JWAAlgorithm$;
import fmgp.crypto.JWT_JWM;
import fmgp.crypto.JWT_JWM$package$;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKP_EC_Key;
import fmgp.crypto.PrivateKey;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64_Base64URL$;
import fmgp.crypto.UtilsJVM$unsafe$;
import fmgp.crypto.error.UnsupportedCurve;
import fmgp.crypto.error.UnsupportedCurve$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.VerificationMethodReferenced$;
import fmgp.did.comm.JWMSignatureObj$;
import fmgp.did.comm.MediaTypes;
import fmgp.did.comm.SignProtectedHeader;
import fmgp.did.comm.SignProtectedHeader$;
import fmgp.did.comm.SignedMessage;
import fmgp.did.comm.SignedMessage$;
import fmgp.util.Base64;
import java.io.Serializable;
import java.security.Provider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.json.ast.Json;
import zio.json.package;

public final class UtilsJVM$
implements Serializable {
    public static final UtilsJVM$unsafe$ unsafe;
    public static final UtilsJVM$ MODULE$;

    private UtilsJVM$() {
    }

    static {
        MODULE$ = new UtilsJVM$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UtilsJVM$.class);
    }

    public JWSAlgorithm toJWSAlgorithm(JWAAlgorithm alg) {
        JWAAlgorithm jWAAlgorithm = alg;
        JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
        JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
        if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
            return JWSAlgorithm.ES256K;
        }
        JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
        JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
        if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
            return JWSAlgorithm.ES256;
        }
        JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
        JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
        if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
            return JWSAlgorithm.ES384;
        }
        JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
        JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
        if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
            return JWSAlgorithm.ES512;
        }
        JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
        JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
        if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
            return JWSAlgorithm.EdDSA;
        }
        throw new MatchError((Object)jWAAlgorithm);
    }

    public com.nimbusds.jose.jwk.Curve toJWKCurve(Curve curve) {
        Curve curve2 = curve;
        Curve curve3 = Curve$.P$minus256;
        Curve curve4 = curve2;
        if (!(curve3 != null ? !curve3.equals(curve4) : curve4 != null)) {
            return com.nimbusds.jose.jwk.Curve.P_256;
        }
        Curve curve5 = Curve$.P$minus384;
        Curve curve6 = curve2;
        if (!(curve5 != null ? !curve5.equals(curve6) : curve6 != null)) {
            return com.nimbusds.jose.jwk.Curve.P_384;
        }
        Curve curve7 = Curve$.P$minus521;
        Curve curve8 = curve2;
        if (!(curve7 != null ? !curve7.equals(curve8) : curve8 != null)) {
            return com.nimbusds.jose.jwk.Curve.P_521;
        }
        Curve curve9 = Curve$.secp256k1;
        Curve curve10 = curve2;
        if (!(curve9 != null ? !curve9.equals(curve10) : curve10 != null)) {
            return com.nimbusds.jose.jwk.Curve.SECP256K1;
        }
        Curve curve11 = Curve$.X25519;
        Curve curve12 = curve2;
        if (!(curve11 != null ? !curve11.equals(curve12) : curve12 != null)) {
            return com.nimbusds.jose.jwk.Curve.X25519;
        }
        Curve curve13 = Curve$.Ed25519;
        Curve curve14 = curve2;
        if (!(curve13 != null ? !curve13.equals(curve14) : curve14 != null)) {
            return com.nimbusds.jose.jwk.Curve.Ed25519;
        }
        throw new MatchError((Object)curve2);
    }

    public boolean ecKeyVerifyJWM(com.nimbusds.jose.jwk.ECKey ecKey, SignedMessage jwm, JWAAlgorithm alg) {
        Seq seq;
        Option maybeKeyID = Option$.MODULE$.apply((Object)ecKey.getKeyID());
        com.nimbusds.jose.jwk.ECKey _key = ecKey.toPublicJWK();
        ECDSAVerifier verifier = new ECDSAVerifier(_key.toPublicJWK());
        verifier.getJCAContext().setProvider((Provider)new BouncyCastleProvider());
        Option option = maybeKeyID;
        if (None$.MODULE$.equals(option)) {
            seq = jwm.signatures();
        } else if (option instanceof Some) {
            String keyId = (String)((Some)option).value();
            seq = (Seq)jwm.signatures().filter((Function1 & Serializable)_$1 -> {
                VerificationMethodReferenced verificationMethodReferenced;
                Option option = ((SignProtectedHeader)_$1.protected().obj()).kid();
                if (None$.MODULE$.equals(option)) {
                    return true;
                }
                if (option instanceof Some && (verificationMethodReferenced = (VerificationMethodReferenced)((Some)option).value()) != null) {
                    String string;
                    VerificationMethodReferenced verificationMethodReferenced2 = VerificationMethodReferenced$.MODULE$.unapply(verificationMethodReferenced);
                    String value = string = verificationMethodReferenced2._1();
                    String string2 = keyId;
                    String string3 = value;
                    return !(string2 != null ? !string2.equals(string3) : string3 != null);
                }
                throw new MatchError((Object)option);
            });
        } else {
            throw new MatchError((Object)option);
        }
        Seq signatureObjs = seq;
        return signatureObjs.exists((Function1 & Serializable)obj -> {
            String base64noSignature = new StringBuilder(1).append(obj.protected().base64url(SignProtectedHeader$.MODULE$.encoder())).append(".").append(JWT_JWM.package.Payload$.MODULE$.base64url(jwm.payload())).toString();
            JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm(((SignProtectedHeader)obj.protected().obj()).alg()));
            maybeKeyID.foreach((Function1 & Serializable)_$2 -> h.keyID(_$2));
            JWSHeader header = h.build();
            return verifier.verify(header, base64noSignature.getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWM$.MODULE$.base64(obj.signature())));
        });
    }

    public boolean ecKeyVerifyJWT(ECKey ecKey, Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt) {
        return this.ecKeyVerifyJWT(this.toJWK(ecKey), jwt);
    }

    public boolean ecKeyVerifyJWT(com.nimbusds.jose.jwk.ECKey ecKey, Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt) {
        JWT_JWM$package$ jWT_JWM$package$;
        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy1 = jwt;
        return BoxesRunTime.unboxToBoolean((Object)package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)JWT_JWM.package.ProtectedHeaderJWT$.MODULE$.content((Vector)jwt$proxy1._1())), Json.Obj$.MODULE$.decoder()).flatMap((Function1 & Serializable)headerJson -> {
            Left left;
            Option option = headerJson.get("alg").map((Function1 & Serializable)_$3 -> _$3.asString());
            if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply((Object)"The field 'alg' must exist");
                return left.flatMap((Function1 & Serializable)alg -> {
                    Right right;
                    Either either = Try$.MODULE$.apply(() -> this.ecKeyVerifyJWT$$anonfun$1$$anonfun$2$$anonfun$1(alg)).toEither();
                    if (either instanceof Right) {
                        JWAAlgorithm value = (JWAAlgorithm)((Right)either).value();
                        right = package$.MODULE$.Right().apply((Object)value);
                    } else if (either instanceof Left) {
                        Throwable ex = (Throwable)((Left)either).value();
                        right = package$.MODULE$.Left().apply((Object)ex.getMessage());
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return right.flatMap((Function1 & Serializable)algorithmTmp -> {
                        Right right;
                        JWAAlgorithm jWAAlgorithm = algorithmTmp;
                        JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
                        JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
                        if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
                            right = package$.MODULE$.Right().apply(algorithmTmp);
                        } else {
                            JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
                            JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
                            if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
                                right = package$.MODULE$.Right().apply(algorithmTmp);
                            } else {
                                JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
                                JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
                                if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
                                    right = package$.MODULE$.Right().apply(algorithmTmp);
                                } else {
                                    JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
                                    JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
                                    if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
                                        right = package$.MODULE$.Right().apply(algorithmTmp);
                                    } else {
                                        JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
                                        JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
                                        if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
                                            right = package$.MODULE$.Left().apply((Object)new StringBuilder(39).append("This method do not support algorithm '").append(algorithmTmp).append("'").toString());
                                        } else {
                                            throw new MatchError((Object)jWAAlgorithm);
                                        }
                                    }
                                }
                            }
                        }
                        return right.map((Function1 & Serializable)algorithm -> {
                            JWT_JWM$package$ jWT_JWM$package$;
                            JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm((JWAAlgorithm)algorithm));
                            Option$.MODULE$.apply((Object)ecKey.getKeyID()).foreach((Function1 & Serializable)_$4 -> h.keyID(_$4));
                            JWSHeader header = h.build();
                            JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
                            Tuple3 jwt$proxy2 = jwt;
                            boolean ret = new ECDSAVerifier(ecKey.toPublicJWK().toPublicJWK()).verify(header, JWT_JWM.package.JWT$.MODULE$.base64JWTFormatWithNoSignature(jwt).getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWT$.MODULE$.base64((Vector)jwt$proxy2._3())));
                            return Tuple3$.MODULE$.apply(algorithm, (Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)ret));
                        }).map((Function1 & Serializable)x$1 -> {
                            Tuple3 tuple3 = x$1;
                            if (tuple3 != null) {
                                JWAAlgorithm algorithm = (JWAAlgorithm)tuple3._1();
                                JWSHeader header = (JWSHeader)tuple3._2();
                                boolean ret = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                                return ret;
                            }
                            throw new MatchError((Object)tuple3);
                        });
                    });
                });
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Option option2 = (Option)((Some)option).value();
                if (None$.MODULE$.equals(option2)) {
                    left = package$.MODULE$.Left().apply((Object)"The field 'alg' must be of the type String");
                    return left.flatMap((Function1 & Serializable)alg -> {
                        Right right;
                        Either either = Try$.MODULE$.apply(() -> this.ecKeyVerifyJWT$$anonfun$1$$anonfun$2$$anonfun$1(alg)).toEither();
                        if (either instanceof Right) {
                            JWAAlgorithm value = (JWAAlgorithm)((Right)either).value();
                            right = package$.MODULE$.Right().apply((Object)value);
                        } else if (either instanceof Left) {
                            Throwable ex = (Throwable)((Left)either).value();
                            right = package$.MODULE$.Left().apply((Object)ex.getMessage());
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return right.flatMap((Function1 & Serializable)algorithmTmp -> {
                            Right right;
                            JWAAlgorithm jWAAlgorithm = algorithmTmp;
                            JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
                            JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
                            if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
                                right = package$.MODULE$.Right().apply(algorithmTmp);
                            } else {
                                JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
                                JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
                                if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
                                    right = package$.MODULE$.Right().apply(algorithmTmp);
                                } else {
                                    JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
                                    JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
                                    if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
                                        right = package$.MODULE$.Right().apply(algorithmTmp);
                                    } else {
                                        JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
                                        JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
                                        if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
                                            right = package$.MODULE$.Right().apply(algorithmTmp);
                                        } else {
                                            JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
                                            JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
                                            if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
                                                right = package$.MODULE$.Left().apply((Object)new StringBuilder(39).append("This method do not support algorithm '").append(algorithmTmp).append("'").toString());
                                            } else {
                                                throw new MatchError((Object)jWAAlgorithm);
                                            }
                                        }
                                    }
                                }
                            }
                            return right.map((Function1 & Serializable)algorithm -> {
                                JWT_JWM$package$ jWT_JWM$package$;
                                JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm((JWAAlgorithm)algorithm));
                                Option$.MODULE$.apply((Object)ecKey.getKeyID()).foreach((Function1 & Serializable)_$4 -> h.keyID(_$4));
                                JWSHeader header = h.build();
                                JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
                                Tuple3 jwt$proxy2 = jwt;
                                boolean ret = new ECDSAVerifier(ecKey.toPublicJWK().toPublicJWK()).verify(header, JWT_JWM.package.JWT$.MODULE$.base64JWTFormatWithNoSignature(jwt).getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWT$.MODULE$.base64((Vector)jwt$proxy2._3())));
                                return Tuple3$.MODULE$.apply(algorithm, (Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)ret));
                            }).map((Function1 & Serializable)x$1 -> {
                                Tuple3 tuple3 = x$1;
                                if (tuple3 != null) {
                                    JWAAlgorithm algorithm = (JWAAlgorithm)tuple3._1();
                                    JWSHeader header = (JWSHeader)tuple3._2();
                                    boolean ret = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                                    return ret;
                                }
                                throw new MatchError((Object)tuple3);
                            });
                        });
                    });
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option);
                    String value = (String)((Some)option2).value();
                    left = package$.MODULE$.Right().apply((Object)value);
                }
            }
            return left.flatMap((Function1 & Serializable)alg -> {
                Right right;
                Either either = Try$.MODULE$.apply(() -> this.ecKeyVerifyJWT$$anonfun$1$$anonfun$2$$anonfun$1(alg)).toEither();
                if (either instanceof Right) {
                    JWAAlgorithm value = (JWAAlgorithm)((Right)either).value();
                    right = package$.MODULE$.Right().apply((Object)value);
                } else if (either instanceof Left) {
                    Throwable ex = (Throwable)((Left)either).value();
                    right = package$.MODULE$.Left().apply((Object)ex.getMessage());
                } else {
                    throw new MatchError((Object)either);
                }
                return right.flatMap((Function1 & Serializable)algorithmTmp -> {
                    Right right;
                    JWAAlgorithm jWAAlgorithm = algorithmTmp;
                    JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
                    JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
                    if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
                        right = package$.MODULE$.Right().apply(algorithmTmp);
                    } else {
                        JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
                        JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
                        if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
                            right = package$.MODULE$.Right().apply(algorithmTmp);
                        } else {
                            JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
                            JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
                            if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
                                right = package$.MODULE$.Right().apply(algorithmTmp);
                            } else {
                                JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
                                JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
                                if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
                                    right = package$.MODULE$.Right().apply(algorithmTmp);
                                } else {
                                    JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
                                    JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
                                    if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
                                        right = package$.MODULE$.Left().apply((Object)new StringBuilder(39).append("This method do not support algorithm '").append(algorithmTmp).append("'").toString());
                                    } else {
                                        throw new MatchError((Object)jWAAlgorithm);
                                    }
                                }
                            }
                        }
                    }
                    return right.map((Function1 & Serializable)algorithm -> {
                        JWT_JWM$package$ jWT_JWM$package$;
                        JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm((JWAAlgorithm)algorithm));
                        Option$.MODULE$.apply((Object)ecKey.getKeyID()).foreach((Function1 & Serializable)_$4 -> h.keyID(_$4));
                        JWSHeader header = h.build();
                        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
                        Tuple3 jwt$proxy2 = jwt;
                        boolean ret = new ECDSAVerifier(ecKey.toPublicJWK().toPublicJWK()).verify(header, JWT_JWM.package.JWT$.MODULE$.base64JWTFormatWithNoSignature(jwt).getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWT$.MODULE$.base64((Vector)jwt$proxy2._3())));
                        return Tuple3$.MODULE$.apply(algorithm, (Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)ret));
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            JWAAlgorithm algorithm = (JWAAlgorithm)tuple3._1();
                            JWSHeader header = (JWSHeader)tuple3._2();
                            boolean ret = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                            return ret;
                        }
                        throw new MatchError((Object)tuple3);
                    });
                });
            });
        }).getOrElse(UtilsJVM$::ecKeyVerifyJWT$$anonfun$2));
    }

    public SignedMessage ecKeySignJWM(com.nimbusds.jose.jwk.ECKey ecKey, byte[] payload, JWAAlgorithm alg) {
        JWT_JWM$package$ jWT_JWM$package$;
        JWT_JWM$package$ jWT_JWM$package$2;
        JWT_JWM$package$ jWT_JWM$package$3;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt = this.ecKeySignJWT(ecKey, payload, alg);
        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$3 = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy3 = jwt;
        JWT_JWM$package$ JWT_JWM$package$_this2 = jWT_JWM$package$2 = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy4 = jwt;
        JWT_JWM$package$ JWT_JWM$package$_this3 = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy5 = jwt;
        return SignedMessage$.MODULE$.apply((Vector)jwt$proxy3._2(), (Seq)((SeqOps)new .colon.colon((Object)JWMSignatureObj$.MODULE$.apply(Base64.package.Base64$.MODULE$.unsafeAsObj(JWT_JWM.package.ProtectedHeaderJWT$.MODULE$.base64((Vector)jwt$proxy4._1()), SignProtectedHeader$.MODULE$.decoder()), JWT_JWM.package.SignatureJWM$.MODULE$.apply(JWT_JWM.package.SignatureJWT$.MODULE$.base64url((Vector)jwt$proxy5._3())), (Option)None$.MODULE$), (List)Nil$.MODULE$)));
    }

    public Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> ecKeySignJWT(ECKey ecKey, byte[] payload) {
        return this.ecKeySignJWT(this.toJWK(ecKey), payload, ecKey.jwaAlgorithmtoSign());
    }

    public Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> ecKeySignJWT(com.nimbusds.jose.jwk.ECKey ecKey, byte[] payload, JWAAlgorithm alg) {
        JWT_JWM$package$ jWT_JWM$package$;
        JWT_JWM$package$ jWT_JWM$package$2;
        Predef$.MODULE$.require(ecKey.isPrivate(), UtilsJVM$::ecKeySignJWT$$anonfun$1);
        ECDSASigner signer = new ECDSASigner(ecKey);
        signer.getJCAContext().setProvider((Provider)new BouncyCastleProvider());
        JWSHeader header = new JWSHeader.Builder(this.toJWSAlgorithm(alg)).keyID(ecKey.getKeyID()).build();
        Payload payloadObj = new Payload(payload);
        JWSObject jwsObject = new JWSObject(header, payloadObj);
        jwsObject.sign((JWSSigner)signer);
        Tuple3 jwt = JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwsObject.serialize());
        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$2 = JWT_JWM$package$.MODULE$;
        Tuple3 jwt$proxy6 = jwt;
        String string = JWT_JWM.package.Payload$.MODULE$.base64url((Vector)jwt$proxy6._2());
        String string2 = payloadObj.toBase64URL().toString();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        JWT_JWM$package$ JWT_JWM$package$_this2 = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
        Tuple3 jwt$proxy7 = jwt;
        String string3 = JWT_JWM.package.SignatureJWT$.MODULE$.base64url((Vector)jwt$proxy7._3());
        String string4 = jwsObject.getSignature().toString();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return jwt;
    }

    public boolean okpKeyVerifyJWMWithEd25519(OctetKeyPair okpKey, SignedMessage jwm, JWAAlgorithm alg) {
        Seq seq;
        String string = okpKey.getCurve().getName();
        String string2 = com.nimbusds.jose.jwk.Curve.Ed25519.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"This method can only be call with Curve.Ed25519");
        }
        JWAAlgorithm jWAAlgorithm = alg;
        JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.EdDSA;
        if (jWAAlgorithm == null ? jWAAlgorithm2 != null : !jWAAlgorithm.equals(jWAAlgorithm2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"This method can only be call with JWAAlgorithm.EdDSA");
        }
        Option maybeKeyID = Option$.MODULE$.apply((Object)okpKey.getKeyID());
        OctetKeyPair _key = okpKey.toPublicJWK();
        Ed25519Verifier verifier = new Ed25519Verifier(_key.toPublicJWK());
        verifier.getJCAContext().setProvider((Provider)new BouncyCastleProvider());
        Option option = maybeKeyID;
        if (None$.MODULE$.equals(option)) {
            seq = jwm.signatures();
        } else if (option instanceof Some) {
            String keyId = (String)((Some)option).value();
            seq = (Seq)jwm.signatures().filter((Function1 & Serializable)_$5 -> {
                VerificationMethodReferenced verificationMethodReferenced;
                Option option = ((SignProtectedHeader)_$5.protected().obj()).kid();
                if (None$.MODULE$.equals(option)) {
                    return true;
                }
                if (option instanceof Some && (verificationMethodReferenced = (VerificationMethodReferenced)((Some)option).value()) != null) {
                    String string;
                    VerificationMethodReferenced verificationMethodReferenced2 = VerificationMethodReferenced$.MODULE$.unapply(verificationMethodReferenced);
                    String value = string = verificationMethodReferenced2._1();
                    String string2 = keyId;
                    String string3 = value;
                    return !(string2 != null ? !string2.equals(string3) : string3 != null);
                }
                throw new MatchError((Object)option);
            });
        } else {
            throw new MatchError((Object)option);
        }
        Seq signatureObjs = seq;
        return signatureObjs.exists((Function1 & Serializable)obj -> {
            String base64noSignature = new StringBuilder(1).append(obj.protected().base64url(SignProtectedHeader$.MODULE$.encoder())).append(".").append(JWT_JWM.package.Payload$.MODULE$.base64url(jwm.payload())).toString();
            JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm(((SignProtectedHeader)obj.protected().obj()).alg()));
            maybeKeyID.foreach((Function1 & Serializable)_$6 -> h.keyID(_$6));
            JWSHeader header = h.build();
            return verifier.verify(header, base64noSignature.getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWM$.MODULE$.base64(obj.signature())));
        });
    }

    public boolean okpKeyVerifyJWTWithEd25519(OKPKey okpKey, Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt) {
        return this.okpKeyVerifyJWTWithEd25519(this.toJWK(okpKey), jwt);
    }

    public boolean okpKeyVerifyJWTWithEd25519(OctetKeyPair okpKey, Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt) {
        JWT_JWM$package$ jWT_JWM$package$;
        String string = okpKey.getCurve().getName();
        String string2 = com.nimbusds.jose.jwk.Curve.Ed25519.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"This method can only be call with Curve.Ed25519");
        }
        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy8 = jwt;
        return BoxesRunTime.unboxToBoolean((Object)package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)JWT_JWM.package.ProtectedHeaderJWT$.MODULE$.content((Vector)jwt$proxy8._1())), Json.Obj$.MODULE$.decoder()).flatMap((Function1 & Serializable)headerJson -> {
            Left left;
            Option option = headerJson.get("alg").map((Function1 & Serializable)_$7 -> _$7.asString());
            if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply((Object)"The field 'alg' must exist");
                return left.flatMap((Function1 & Serializable)alg -> {
                    Right right;
                    Either either = Try$.MODULE$.apply(() -> this.okpKeyVerifyJWTWithEd25519$$anonfun$1$$anonfun$2$$anonfun$1(alg)).toEither();
                    if (either instanceof Right) {
                        JWAAlgorithm value = (JWAAlgorithm)((Right)either).value();
                        right = package$.MODULE$.Right().apply((Object)value);
                    } else if (either instanceof Left) {
                        Throwable ex = (Throwable)((Left)either).value();
                        right = package$.MODULE$.Left().apply((Object)ex.getMessage());
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return right.flatMap((Function1 & Serializable)algorithmTmp -> {
                        Left left;
                        JWAAlgorithm jWAAlgorithm = algorithmTmp;
                        JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
                        JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
                        if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
                            left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                        } else {
                            JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
                            JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
                            if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
                                left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                            } else {
                                JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
                                JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
                                if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
                                    left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                                } else {
                                    JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
                                    JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
                                    if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
                                        left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                                    } else {
                                        JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
                                        JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
                                        if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
                                            left = package$.MODULE$.Right().apply((Object)JWAAlgorithm$.EdDSA);
                                        } else {
                                            throw new MatchError((Object)jWAAlgorithm);
                                        }
                                    }
                                }
                            }
                        }
                        return left.map((Function1 & Serializable)algorithm -> {
                            JWT_JWM$package$ jWT_JWM$package$;
                            JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm((JWAAlgorithm)algorithm));
                            Option$.MODULE$.apply((Object)okpKey.getKeyID()).foreach((Function1 & Serializable)_$8 -> h.keyID(_$8));
                            JWSHeader header = h.build();
                            JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
                            Tuple3 jwt$proxy9 = jwt;
                            boolean ret = new Ed25519Verifier(okpKey.toPublicJWK().toPublicJWK()).verify(header, JWT_JWM.package.JWT$.MODULE$.base64JWTFormatWithNoSignature(jwt).getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWT$.MODULE$.base64((Vector)jwt$proxy9._3())));
                            return Tuple3$.MODULE$.apply(algorithm, (Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)ret));
                        }).map((Function1 & Serializable)x$1 -> {
                            Tuple3 tuple3 = x$1;
                            if (tuple3 != null) {
                                JWAAlgorithm algorithm = (JWAAlgorithm)tuple3._1();
                                JWSHeader header = (JWSHeader)tuple3._2();
                                boolean ret = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                                return ret;
                            }
                            throw new MatchError((Object)tuple3);
                        });
                    });
                });
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Option option2 = (Option)((Some)option).value();
                if (None$.MODULE$.equals(option2)) {
                    left = package$.MODULE$.Left().apply((Object)"The field 'alg' must be of the type String");
                    return left.flatMap((Function1 & Serializable)alg -> {
                        Right right;
                        Either either = Try$.MODULE$.apply(() -> this.okpKeyVerifyJWTWithEd25519$$anonfun$1$$anonfun$2$$anonfun$1(alg)).toEither();
                        if (either instanceof Right) {
                            JWAAlgorithm value = (JWAAlgorithm)((Right)either).value();
                            right = package$.MODULE$.Right().apply((Object)value);
                        } else if (either instanceof Left) {
                            Throwable ex = (Throwable)((Left)either).value();
                            right = package$.MODULE$.Left().apply((Object)ex.getMessage());
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return right.flatMap((Function1 & Serializable)algorithmTmp -> {
                            Left left;
                            JWAAlgorithm jWAAlgorithm = algorithmTmp;
                            JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
                            JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
                            if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
                                left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                            } else {
                                JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
                                JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
                                if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
                                    left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                                } else {
                                    JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
                                    JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
                                    if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
                                        left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                                    } else {
                                        JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
                                        JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
                                        if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
                                            left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                                        } else {
                                            JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
                                            JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
                                            if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
                                                left = package$.MODULE$.Right().apply((Object)JWAAlgorithm$.EdDSA);
                                            } else {
                                                throw new MatchError((Object)jWAAlgorithm);
                                            }
                                        }
                                    }
                                }
                            }
                            return left.map((Function1 & Serializable)algorithm -> {
                                JWT_JWM$package$ jWT_JWM$package$;
                                JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm((JWAAlgorithm)algorithm));
                                Option$.MODULE$.apply((Object)okpKey.getKeyID()).foreach((Function1 & Serializable)_$8 -> h.keyID(_$8));
                                JWSHeader header = h.build();
                                JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
                                Tuple3 jwt$proxy9 = jwt;
                                boolean ret = new Ed25519Verifier(okpKey.toPublicJWK().toPublicJWK()).verify(header, JWT_JWM.package.JWT$.MODULE$.base64JWTFormatWithNoSignature(jwt).getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWT$.MODULE$.base64((Vector)jwt$proxy9._3())));
                                return Tuple3$.MODULE$.apply(algorithm, (Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)ret));
                            }).map((Function1 & Serializable)x$1 -> {
                                Tuple3 tuple3 = x$1;
                                if (tuple3 != null) {
                                    JWAAlgorithm algorithm = (JWAAlgorithm)tuple3._1();
                                    JWSHeader header = (JWSHeader)tuple3._2();
                                    boolean ret = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                                    return ret;
                                }
                                throw new MatchError((Object)tuple3);
                            });
                        });
                    });
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option);
                    String value = (String)((Some)option2).value();
                    left = package$.MODULE$.Right().apply((Object)value);
                }
            }
            return left.flatMap((Function1 & Serializable)alg -> {
                Right right;
                Either either = Try$.MODULE$.apply(() -> this.okpKeyVerifyJWTWithEd25519$$anonfun$1$$anonfun$2$$anonfun$1(alg)).toEither();
                if (either instanceof Right) {
                    JWAAlgorithm value = (JWAAlgorithm)((Right)either).value();
                    right = package$.MODULE$.Right().apply((Object)value);
                } else if (either instanceof Left) {
                    Throwable ex = (Throwable)((Left)either).value();
                    right = package$.MODULE$.Left().apply((Object)ex.getMessage());
                } else {
                    throw new MatchError((Object)either);
                }
                return right.flatMap((Function1 & Serializable)algorithmTmp -> {
                    Left left;
                    JWAAlgorithm jWAAlgorithm = algorithmTmp;
                    JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
                    JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
                    if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
                        left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                    } else {
                        JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
                        JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
                        if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
                            left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                        } else {
                            JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
                            JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
                            if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
                                left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                            } else {
                                JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
                                JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
                                if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
                                    left = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("This method can only be call with JWAAlgorithm.EdDSA (got '").append(algorithmTmp).append("')").toString());
                                } else {
                                    JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
                                    JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
                                    if (!(jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null)) {
                                        left = package$.MODULE$.Right().apply((Object)JWAAlgorithm$.EdDSA);
                                    } else {
                                        throw new MatchError((Object)jWAAlgorithm);
                                    }
                                }
                            }
                        }
                    }
                    return left.map((Function1 & Serializable)algorithm -> {
                        JWT_JWM$package$ jWT_JWM$package$;
                        JWSHeader.Builder h = new JWSHeader.Builder(MODULE$.toJWSAlgorithm((JWAAlgorithm)algorithm));
                        Option$.MODULE$.apply((Object)okpKey.getKeyID()).foreach((Function1 & Serializable)_$8 -> h.keyID(_$8));
                        JWSHeader header = h.build();
                        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
                        Tuple3 jwt$proxy9 = jwt;
                        boolean ret = new Ed25519Verifier(okpKey.toPublicJWK().toPublicJWK()).verify(header, JWT_JWM.package.JWT$.MODULE$.base64JWTFormatWithNoSignature(jwt).getBytes(StandardCharset.UTF_8), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)JWT_JWM.package.SignatureJWT$.MODULE$.base64((Vector)jwt$proxy9._3())));
                        return Tuple3$.MODULE$.apply(algorithm, (Object)header, (Object)BoxesRunTime.boxToBoolean((boolean)ret));
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            JWAAlgorithm algorithm = (JWAAlgorithm)tuple3._1();
                            JWSHeader header = (JWSHeader)tuple3._2();
                            boolean ret = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                            return ret;
                        }
                        throw new MatchError((Object)tuple3);
                    });
                });
            });
        }).getOrElse(UtilsJVM$::okpKeyVerifyJWTWithEd25519$$anonfun$2));
    }

    public SignedMessage okpKeySignJWMWithEd25519(OctetKeyPair okpKey, byte[] payload, JWAAlgorithm alg) {
        JWT_JWM$package$ jWT_JWM$package$;
        JWT_JWM$package$ jWT_JWM$package$2;
        JWT_JWM$package$ jWT_JWM$package$3;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt = this.okpKeySignJWTWithEd25519(okpKey, payload, alg);
        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$3 = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy10 = jwt;
        JWT_JWM$package$ JWT_JWM$package$_this2 = jWT_JWM$package$2 = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy11 = jwt;
        JWT_JWM$package$ JWT_JWM$package$_this3 = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
        Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt$proxy12 = jwt;
        return SignedMessage$.MODULE$.apply((Vector)jwt$proxy10._2(), (Seq)((SeqOps)new .colon.colon((Object)JWMSignatureObj$.MODULE$.apply(Base64.package.Base64$.MODULE$.unsafeAsObj(JWT_JWM.package.ProtectedHeaderJWT$.MODULE$.base64((Vector)jwt$proxy11._1()), SignProtectedHeader$.MODULE$.decoder()), JWT_JWM.package.SignatureJWM$.MODULE$.apply(JWT_JWM.package.SignatureJWT$.MODULE$.base64url((Vector)jwt$proxy12._3())), (Option)None$.MODULE$), (List)Nil$.MODULE$)));
    }

    public Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> okpKeySignJWTWithEd25519(OKPKey okpKey, byte[] payload) {
        return this.okpKeySignJWTWithEd25519(this.toJWK(okpKey), payload, okpKey.jwaAlgorithmtoSign());
    }

    public Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> okpKeySignJWTWithEd25519(OctetKeyPair okpKey, byte[] payload, JWAAlgorithm alg) {
        JWT_JWM$package$ jWT_JWM$package$;
        JWT_JWM$package$ jWT_JWM$package$2;
        Predef$.MODULE$.require(okpKey.isPrivate(), UtilsJVM$::okpKeySignJWTWithEd25519$$anonfun$1);
        String string = okpKey.getCurve().getName();
        String string2 = com.nimbusds.jose.jwk.Curve.Ed25519.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"This method can only be call with Curve.Ed25519");
        }
        Ed25519Signer signer = new Ed25519Signer(okpKey);
        signer.getJCAContext().setProvider((Provider)new BouncyCastleProvider());
        JWSHeader header = new JWSHeader.Builder(this.toJWSAlgorithm(alg)).keyID(okpKey.getKeyID()).build();
        Payload payloadObj = new Payload(payload);
        JWSObject jwsObject = new JWSObject(header, payloadObj);
        jwsObject.sign((JWSSigner)signer);
        Tuple3 jwt = JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwsObject.serialize());
        JWT_JWM$package$ JWT_JWM$package$_this = jWT_JWM$package$2 = JWT_JWM$package$.MODULE$;
        Tuple3 jwt$proxy13 = jwt;
        String string3 = JWT_JWM.package.Payload$.MODULE$.base64url((Vector)jwt$proxy13._2());
        String string4 = payloadObj.toBase64URL().toString();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        JWT_JWM$package$ JWT_JWM$package$_this2 = jWT_JWM$package$ = JWT_JWM$package$.MODULE$;
        Tuple3 jwt$proxy14 = jwt;
        String string5 = JWT_JWM.package.SignatureJWT$.MODULE$.base64url((Vector)jwt$proxy14._3());
        String string6 = jwsObject.getSignature().toString();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return jwt;
    }

    public CurveBasedJWK toJWK(OKP_EC_Key key) {
        OKP_EC_Key oKP_EC_Key = key;
        if (oKP_EC_Key instanceof ECKey) {
            ECKey ec = (ECKey)oKP_EC_Key;
            return this.toJWK(ec);
        }
        if (oKP_EC_Key instanceof OKPKey) {
            OKPKey okp = (OKPKey)oKP_EC_Key;
            return this.okpKey2JWK(okp);
        }
        throw new MatchError((Object)oKP_EC_Key);
    }

    public OctetKeyPair toJWK(OKPKey okp) {
        return this.okpKey2JWK(okp);
    }

    public com.nimbusds.jose.jwk.ECKey toJWK(ECKey ec) {
        return this.ecKey2JWK(ec);
    }

    public com.nimbusds.jose.jwk.ECKey ecKey2JWK(ECKey ec) {
        BoxedUnit boxedUnit;
        ECKey.Builder builder;
        Vector x = Base64.package.Base64$.MODULE$.fromBase64url(ec.x());
        Vector y = Base64.package.Base64$.MODULE$.fromBase64url(ec.y());
        Curve curve = ec.getCurve();
        if (curve == Curve$.P$minus256) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else if (curve == Curve$.P$minus384) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else if (curve == Curve$.P$minus521) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else if (curve == Curve$.secp256k1) {
            Curve c = curve;
            builder = new ECKey.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)x), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)y));
        } else {
            throw new MatchError((Object)curve);
        }
        ECKey.Builder builder2 = builder;
        ec.maybeKid().foreach((Function1 & Serializable)x$0 -> builder2.keyID(x$0));
        ECKey eCKey = ec;
        if (eCKey instanceof PublicKey) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (eCKey instanceof PrivateKey) {
            ECKey k = (ECKey)((PrivateKey)eCKey);
            boxedUnit = builder2.d(UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(((PrivateKey)k).d())));
        } else {
            throw new MatchError((Object)eCKey);
        }
        return builder2.build();
    }

    public OctetKeyPair okpKey2JWK(OKPKey okp) {
        BoxedUnit boxedUnit;
        OctetKeyPair.Builder builder;
        Curve curve = okp.getCurve();
        if (curve == Curve$.Ed25519) {
            Curve c = curve;
            builder = new OctetKeyPair.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(okp.x())));
        } else if (curve == Curve$.X25519) {
            Curve c = curve;
            builder = new OctetKeyPair.Builder(this.toJWKCurve(c), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(okp.x())));
        } else {
            throw new MatchError((Object)curve);
        }
        OctetKeyPair.Builder builder2 = builder;
        okp.maybeKid().foreach((Function1 & Serializable)x$0 -> builder2.keyID(x$0));
        OKPKey oKPKey = okp;
        if (oKPKey instanceof PublicKey) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (oKPKey instanceof PrivateKey) {
            OKPKey k = (OKPKey)((PrivateKey)oKPKey);
            boxedUnit = builder2.d(UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)Base64.package.Base64$.MODULE$.fromBase64url(((PrivateKey)k).d())));
        } else {
            throw new MatchError((Object)oKPKey);
        }
        return builder2.build();
    }

    public Either<UnsupportedCurve, Object> verify(PublicKey key, SignedMessage jwm) {
        CurveBasedJWK curveBasedJWK = this.toJWK((OKP_EC_Key)key);
        if (curveBasedJWK instanceof com.nimbusds.jose.jwk.ECKey) {
            com.nimbusds.jose.jwk.ECKey ecKey = (com.nimbusds.jose.jwk.ECKey)curveBasedJWK;
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)this.ecKeyVerifyJWM(ecKey, jwm, key.jwaAlgorithmtoSign())));
        }
        if (curveBasedJWK instanceof OctetKeyPair) {
            OctetKeyPair octetKeyPair;
            OctetKeyPair okpKey = octetKeyPair = (OctetKeyPair)curveBasedJWK;
            Curve curve = key.crv();
            Curve curve2 = Curve$.Ed25519;
            if (!(curve != null ? !curve.equals(curve2) : curve2 != null)) {
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)this.okpKeyVerifyJWMWithEd25519(okpKey, jwm, key.jwaAlgorithmtoSign())));
            }
            OctetKeyPair okpKey2 = octetKeyPair;
            return package$.MODULE$.Left().apply((Object)UnsupportedCurve$.MODULE$.apply(key.crv(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{Curve$.Ed25519}))));
        }
        throw new MatchError((Object)curveBasedJWK);
    }

    public Either<UnsupportedCurve, SignedMessage> sign(PrivateKey key, byte[] payload) {
        CurveBasedJWK curveBasedJWK = this.toJWK((OKP_EC_Key)key.toPublicKey());
        if (curveBasedJWK instanceof com.nimbusds.jose.jwk.ECKey) {
            com.nimbusds.jose.jwk.ECKey ecKey = (com.nimbusds.jose.jwk.ECKey)curveBasedJWK;
            return package$.MODULE$.Right().apply((Object)this.ecKeySignJWM(ecKey, payload, key.jwaAlgorithmtoSign()));
        }
        if (curveBasedJWK instanceof OctetKeyPair) {
            OctetKeyPair octetKeyPair;
            OctetKeyPair okpKey = octetKeyPair = (OctetKeyPair)curveBasedJWK;
            Curve curve = key.crv();
            Curve curve2 = Curve$.Ed25519;
            if (!(curve != null ? !curve.equals(curve2) : curve2 != null)) {
                return package$.MODULE$.Right().apply((Object)this.okpKeySignJWMWithEd25519(okpKey, payload, key.jwaAlgorithmtoSign()));
            }
            OctetKeyPair okpKey2 = octetKeyPair;
            return package$.MODULE$.Left().apply((Object)UnsupportedCurve$.MODULE$.apply(key.crv(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{Curve$.Ed25519}))));
        }
        throw new MatchError((Object)curveBasedJWK);
    }

    public static final /* synthetic */ JWEHeader.Builder fmgp$crypto$UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$$$_$apply$$anonfun$1(JWEHeader.Builder aux$1, MediaTypes e) {
        return aux$1.type(new JOSEObjectType(e.typ()));
    }

    public static final /* synthetic */ JWEHeader.Builder fmgp$crypto$UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$$$_$apply$$anonfun$2(JWEHeader.Builder aux$2, MediaTypes e) {
        return aux$2.type(new JOSEObjectType(e.typ()));
    }

    private final JWAAlgorithm block$proxy1$1(String alg$1) {
        return JWAAlgorithm$.MODULE$.valueOf(alg$1);
    }

    private final JWAAlgorithm ecKeyVerifyJWT$$anonfun$1$$anonfun$2$$anonfun$1(String alg$3) {
        return this.block$proxy1$1(alg$3);
    }

    private static final boolean ecKeyVerifyJWT$$anonfun$2() {
        return false;
    }

    private static final Object ecKeySignJWT$$anonfun$1() {
        return "EC JWK must include the private key (d)";
    }

    private final JWAAlgorithm block$proxy2$1(String alg$2) {
        return JWAAlgorithm$.MODULE$.valueOf(alg$2);
    }

    private final JWAAlgorithm okpKeyVerifyJWTWithEd25519$$anonfun$1$$anonfun$2$$anonfun$1(String alg$4) {
        return this.block$proxy2$1(alg$4);
    }

    private static final boolean okpKeyVerifyJWTWithEd25519$$anonfun$2() {
        return false;
    }

    private static final Object okpKeySignJWTWithEd25519$$anonfun$1() {
        return "OKP JWK must include the private key (d)";
    }
}

