/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.impl.AESKW;
import com.nimbusds.jose.crypto.impl.ConcatKDF;
import com.nimbusds.jose.crypto.impl.ECDH;
import com.nimbusds.jose.crypto.impl.ECDH1PU;
import com.nimbusds.jose.crypto.impl.ECDH1PUCryptoProvider;
import com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.util.Base64URL;
import fmgp.crypto.ECDH_AuthCryptoProvider$;
import fmgp.crypto.JWERecipient;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64_Base64URL$;
import fmgp.crypto.UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$;
import fmgp.crypto.error.CryptoErrorCollection$;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.MACCheckFailed$;
import fmgp.crypto.error.MultiDifferentResults$;
import fmgp.crypto.error.SomeThrowable$;
import fmgp.crypto.error.ZeroResults$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.comm.EncryptedMessageGeneric;
import fmgp.did.comm.EncryptedMessageGeneric$;
import fmgp.did.comm.OpaqueTypes;
import fmgp.did.comm.ProtectedHeader;
import fmgp.did.comm.ProtectedHeader$;
import fmgp.did.comm.Recipient$;
import fmgp.did.comm.RecipientHeader$;
import fmgp.util.Base64;
import fmgp.util.Base64$package$;
import fmgp.util.Base64Obj;
import fmgp.util.Base64Obj$;
import java.io.Serializable;
import java.security.Provider;
import javax.crypto.SecretKey;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;
import zio.json.package;

public class ECDH_AuthCryptoProvider
extends ECDH1PUCryptoProvider
implements Product,
Serializable {
    private final Curve curve;
    private final SecretKey cek;

    public static ECDH_AuthCryptoProvider apply(Curve curve, SecretKey secretKey) {
        return ECDH_AuthCryptoProvider$.MODULE$.apply(curve, secretKey);
    }

    public static ECDH_AuthCryptoProvider fromProduct(Product product) {
        return ECDH_AuthCryptoProvider$.MODULE$.fromProduct(product);
    }

    public static ECDH_AuthCryptoProvider unapply(ECDH_AuthCryptoProvider eCDH_AuthCryptoProvider) {
        return ECDH_AuthCryptoProvider$.MODULE$.unapply(eCDH_AuthCryptoProvider);
    }

    public ECDH_AuthCryptoProvider(Curve curve, SecretKey cek) {
        this.curve = curve;
        this.cek = cek;
        super(curve, cek);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ECDH_AuthCryptoProvider)) return false;
        ECDH_AuthCryptoProvider eCDH_AuthCryptoProvider = (ECDH_AuthCryptoProvider)object;
        Curve curve = this.curve();
        Curve curve2 = eCDH_AuthCryptoProvider.curve();
        if (curve == null) {
            if (curve2 != null) {
                return false;
            }
        } else if (!curve.equals(curve2)) return false;
        SecretKey secretKey = this.cek();
        SecretKey secretKey2 = eCDH_AuthCryptoProvider.cek();
        if (secretKey == null) {
            if (secretKey2 != null) {
                return false;
            }
        } else if (!secretKey.equals(secretKey2)) return false;
        if (!eCDH_AuthCryptoProvider.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ECDH_AuthCryptoProvider;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ECDH_AuthCryptoProvider";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "curve";
        }
        if (1 == n2) {
            return "cek";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Curve curve() {
        return this.curve;
    }

    public SecretKey cek() {
        return this.cek;
    }

    public java.util.Set<Curve> supportedEllipticCurves() {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{this.curve()}))).asJava();
    }

    public EncryptedMessageGeneric encryptAUX(ProtectedHeader header, Seq<Tuple2<VerificationMethodReferenced, SecretKey>> sharedSecrets, byte[] clearText, byte[] aad) {
        ECDH.AlgorithmMode algMode;
        JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull((JWEHeader)UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$.MODULE$.apply(header));
        ECDH.AlgorithmMode algorithmMode = algMode = ECDH1PU.resolveAlgorithmMode((JWEAlgorithm)alg);
        ECDH.AlgorithmMode algorithmMode2 = ECDH.AlgorithmMode.KW;
        if (algorithmMode == null ? algorithmMode2 != null : !algorithmMode.equals(algorithmMode2)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        Seq<Tuple2<VerificationMethodReferenced, SecretKey>> seq = sharedSecrets;
        if (seq instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)seq;
            List list = colon2.next$access$1();
            Tuple2 head = (Tuple2)colon2.head();
            List tail = list;
            JWECryptoParts headParts = this.encryptWithZ(UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$.MODULE$.apply(header), (SecretKey)head._2(), clearText, aad);
            List recipients = tail.map((Function1 & Serializable)rs -> {
                SecretKey sharedKey = ECDH1PU.deriveSharedKey((JWEHeader)UtilsJVM$unsafe$given_Conversion_ProtectedHeader_JWEHeader$.MODULE$.apply(header), (SecretKey)((SecretKey)rs._2()), (Base64URL)headParts.getAuthenticationTag(), (ConcatKDF)this.getConcatKDF());
                Base64$package$ base64$package$ = Base64$package$.MODULE$;
                Base64.package.Base64$ Base64$_this = Base64.package.Base64$.MODULE$;
                Base64$package$ Base64$package$_this = base64$package$;
                byte[] data$proxy2 = AESKW.wrapCEK((SecretKey)this.cek(), (SecretKey)sharedKey, (Provider)this.getJCAContext().getKeyEncryptionProvider());
                Vector encryptedKey = Predef$.MODULE$.wrapByteArray(Base64$_this.urlEncoder().encode(data$proxy2)).toVector();
                return Tuple2$.MODULE$.apply(rs._1(), (Object)encryptedKey);
            });
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(head._1(), (Object)Base64.package.Base64$.MODULE$.fromBase64url(headParts.getEncryptedKey().toString()));
            List auxRecipient = ((List)recipients.$plus$colon((Object)tuple2)).map((Function1 & Serializable)e -> Recipient$.MODULE$.apply((Vector)e._2(), RecipientHeader$.MODULE$.apply((VerificationMethodReferenced)e._1())));
            ProtectedHeader protectedHeader = (ProtectedHeader)package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)headParts.getHeader().toString()), ProtectedHeader$.MODULE$.decoder()).toOption().get();
            return EncryptedMessageGeneric$.MODULE$.apply(OpaqueTypes.package.CipherText$.MODULE$.apply(headParts.getCipherText().toString()), Base64Obj$.MODULE$.apply((Object)protectedHeader, Base64Obj$.MODULE$.$lessinit$greater$default$2()), auxRecipient.toSeq(), OpaqueTypes.package.TAG$.MODULE$.apply(headParts.getAuthenticationTag().toString()), OpaqueTypes.package.IV$.MODULE$.apply(headParts.getInitializationVector().toString()));
        }
        throw new MatchError(seq);
    }

    public Either<CryptoFailed, byte[]> decryptAUX(Base64Obj<ProtectedHeader> header, Seq<Tuple2<VerificationMethodReferenced, SecretKey>> sharedSecrets, Seq<JWERecipient> recipients, String iv, String cipherText, String authTag, byte[] aad) {
        Seq tmp = (Seq)((IterableOps)sharedSecrets.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                VerificationMethodReferenced vmr = (VerificationMethodReferenced)tuple2._1();
                SecretKey secretKey = (SecretKey)tuple2._2();
                return recipients.find((Function1 & Serializable)recipient -> {
                    VerificationMethodReferenced verificationMethodReferenced = recipient.vmr();
                    VerificationMethodReferenced verificationMethodReferenced2 = vmr;
                    return !(verificationMethodReferenced != null ? !verificationMethodReferenced.equals(verificationMethodReferenced2) : verificationMethodReferenced2 != null);
                }).map((Function1 & Serializable)_$3 -> _$3.encryptedKey()).map((Function1 & Serializable)encryptedKey -> Try$.MODULE$.apply(() -> this.$anonfun$6$$anonfun$3$$anonfun$1(header, aad, secretKey, encryptedKey, iv, cipherText, authTag)).toEither().left().map((Function1 & Serializable)x$1 -> {
                    MACCheckFailed$ mACCheckFailed$;
                    Throwable throwable = x$1;
                    if (throwable instanceof JOSEException) {
                        JOSEException jOSEException;
                        JOSEException ex = jOSEException = (JOSEException)throwable;
                        String string = ex.getMessage();
                        String string2 = "MAC check failed";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            mACCheckFailed$ = MACCheckFailed$.MODULE$;
                        } else {
                            JOSEException ex2 = jOSEException;
                            mACCheckFailed$ = SomeThrowable$.MODULE$.apply((Throwable)ex2);
                        }
                    } else {
                        throw new MatchError((Object)throwable);
                    }
                    return (CryptoFailed)mACCheckFailed$;
                }));
            }
            throw new MatchError((Object)tuple2);
        })).flatten(Predef$.MODULE$.$conforms());
        return CryptoErrorCollection$.MODULE$.unfold(tmp).flatMap((Function1 & Serializable)result -> {
            if (((IterableOnceOps)result.tail()).forall((Function1 & Serializable)_$4 -> Predef$.MODULE$.wrapByteArray(_$4).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray((byte[])result.head())))) {
                Option option = result.headOption();
                if (option instanceof Some) {
                    byte[] value = (byte[])((Some)option).value();
                    return package$.MODULE$.Right().apply((Object)value);
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply((Object)ZeroResults$.MODULE$);
                }
                throw new MatchError((Object)option);
            }
            return package$.MODULE$.Left().apply((Object)MultiDifferentResults$.MODULE$);
        });
    }

    public ECDH_AuthCryptoProvider copy(Curve curve, SecretKey cek) {
        return new ECDH_AuthCryptoProvider(curve, cek);
    }

    public Curve copy$default$1() {
        return this.curve();
    }

    public SecretKey copy$default$2() {
        return this.cek();
    }

    public Curve _1() {
        return this.curve();
    }

    public SecretKey _2() {
        return this.cek();
    }

    private final byte[] $anonfun$6$$anonfun$3$$anonfun$1(Base64Obj header$8, byte[] aad$6, SecretKey secretKey$4, Vector encryptedKey$2, String iv$6, String cipherText$6, String authTag$6) {
        return this.decryptWithZ(UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply((Base64Obj<ProtectedHeader>)header$8), aad$6, secretKey$4, UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)encryptedKey$2), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)OpaqueTypes.package.IV$.MODULE$.base64(iv$6)), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)OpaqueTypes.package.CipherText$.MODULE$.base64(cipherText$6)), UtilsJVM$package$given_Conversion_Base64_Base64URL$.MODULE$.apply((Vector<Object>)OpaqueTypes.package.TAG$.MODULE$.base64(authTag$6)));
    }
}

