/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import fmgp.crypto.Curve;
import fmgp.crypto.Curve$;
import fmgp.crypto.ECKey;
import fmgp.crypto.ECPrivateKey;
import fmgp.crypto.ECPublicKey;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKPPrivateKey;
import fmgp.crypto.OKPPublicKey;
import fmgp.crypto.PrivateKey;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.CurveError;
import fmgp.crypto.error.UnsupportedCurve;
import fmgp.crypto.error.UnsupportedCurve$;
import fmgp.did.comm.SignedMessage;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;

public final class PlatformSpecificOperations$
implements Serializable {
    public static final PlatformSpecificOperations$ MODULE$ = new PlatformSpecificOperations$();

    private PlatformSpecificOperations$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlatformSpecificOperations$.class);
    }

    public ZIO<Object, CryptoFailed, Tuple3<Vector<Object>, Vector<Object>, Vector<Object>>> signJWT(PrivateKey key, byte[] payload) {
        PrivateKey privateKey = key;
        if (privateKey instanceof OKPPrivateKey) {
            OKPPrivateKey okp = (OKPPrivateKey)privateKey;
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.signJWT(PlatformSpecificOperations.scala:24)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return UtilsJVM$.MODULE$.okpKeySignJWTWithEd25519((OKPKey)okp, payload);
            });
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey ec = (ECPrivateKey)privateKey;
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.signJWT(PlatformSpecificOperations.scala:25)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return UtilsJVM$.MODULE$.ecKeySignJWT((ECKey)ec, payload);
            });
        }
        throw new MatchError((Object)privateKey);
    }

    public ZIO<Object, CryptoFailed, Object> verifyJWT(PublicKey key, Tuple3<Vector<Object>, Vector<Object>, Vector<Object>> jwt) {
        PublicKey publicKey = key;
        if (publicKey instanceof OKPPublicKey) {
            OKPPublicKey okp = (OKPPublicKey)publicKey;
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.verifyJWT(PlatformSpecificOperations.scala:32)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return UtilsJVM$.MODULE$.okpKeyVerifyJWTWithEd25519((OKPKey)okp, jwt);
            });
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ec = (ECPublicKey)publicKey;
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.verifyJWT(PlatformSpecificOperations.scala:33)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return UtilsJVM$.MODULE$.ecKeyVerifyJWT((ECKey)ec, jwt);
            });
        }
        throw new MatchError((Object)publicKey);
    }

    public ZIO<Object, CurveError, SignedMessage> sign(PrivateKey key, byte[] payload) {
        PrivateKey privateKey = key;
        if (privateKey instanceof OKPPrivateKey) {
            OKPPrivateKey okp = (OKPPrivateKey)privateKey;
            Curve curve = ((OKPKey)okp).crv();
            Curve curve2 = Curve$.Ed25519;
            Curve curve3 = curve;
            if (!(curve2 != null ? !curve2.equals(curve3) : curve3 != null)) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.sign(PlatformSpecificOperations.scala:48)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return UtilsJVM$.MODULE$.okpKeySignJWMWithEd25519(UtilsJVM$.MODULE$.okpKey2JWK((OKPKey)okp), payload, key.jwaAlgorithmtoSign());
                });
            }
            Curve curve4 = Curve$.X25519;
            Curve curve5 = curve;
            if (!(curve4 != null ? !curve4.equals(curve5) : curve5 != null)) {
                return ZIO$.MODULE$.fail(() -> PlatformSpecificOperations$.sign$$anonfun$2(okp), (Object)"fmgp.crypto.PlatformSpecificOperations.sign(PlatformSpecificOperations.scala:49)");
            }
            throw new MatchError((Object)curve);
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey ec = (ECPrivateKey)privateKey;
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.sign(PlatformSpecificOperations.scala:50)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return UtilsJVM$.MODULE$.ecKeySignJWM(UtilsJVM$.MODULE$.toJWK((ECKey)ec), payload, key.jwaAlgorithmtoSign());
            });
        }
        throw new MatchError((Object)privateKey);
    }

    public ZIO<Object, CurveError, Object> verify(PublicKey key, SignedMessage jwm) {
        PublicKey publicKey = key;
        if (publicKey instanceof OKPPublicKey) {
            OKPPublicKey okp = (OKPPublicKey)publicKey;
            Curve curve = ((OKPKey)okp).crv();
            Curve curve2 = Curve$.Ed25519;
            Curve curve3 = curve;
            if (!(curve2 != null ? !curve2.equals(curve3) : curve3 != null)) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.verify(PlatformSpecificOperations.scala:57)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    return UtilsJVM$.MODULE$.okpKeyVerifyJWMWithEd25519(UtilsJVM$.MODULE$.okpKey2JWK((OKPKey)okp), jwm, key.jwaAlgorithmtoSign());
                });
            }
            Curve curve4 = Curve$.X25519;
            Curve curve5 = curve;
            if (!(curve4 != null ? !curve4.equals(curve5) : curve5 != null)) {
                return ZIO$.MODULE$.fail(() -> PlatformSpecificOperations$.verify$$anonfun$2(okp), (Object)"fmgp.crypto.PlatformSpecificOperations.verify(PlatformSpecificOperations.scala:58)");
            }
            throw new MatchError((Object)curve);
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ec = (ECPublicKey)publicKey;
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"fmgp.crypto.PlatformSpecificOperations.verify(PlatformSpecificOperations.scala:60)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return UtilsJVM$.MODULE$.ecKeyVerifyJWM(UtilsJVM$.MODULE$.toJWK((ECKey)ec), jwm, key.jwaAlgorithmtoSign());
            });
        }
        throw new MatchError((Object)publicKey);
    }

    private static final UnsupportedCurve sign$$anonfun$2(OKPPrivateKey okp$4) {
        return UnsupportedCurve$.MODULE$.apply(((OKPKey)okp$4).crv(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{Curve$.Ed25519})));
    }

    private static final UnsupportedCurve verify$$anonfun$2(OKPPublicKey okp$6) {
        return UnsupportedCurve$.MODULE$.apply(((OKPKey)okp$6).crv(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Curve[]{Curve$.Ed25519})));
    }
}

