/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.nimbusds.jose.crypto.impl.ECDH;
import com.nimbusds.jose.crypto.utils.ECChecks;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import fmgp.crypto.Curve;
import fmgp.crypto.ECDH_AnonCryptoProvider;
import fmgp.crypto.ECDH_UtilsEC;
import fmgp.crypto.ECKey;
import fmgp.crypto.ECPublicKey;
import fmgp.crypto.ECPublicKey$;
import fmgp.crypto.JWERecipient;
import fmgp.crypto.PublicKey;
import fmgp.crypto.UtilsJVM$;
import fmgp.crypto.UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$;
import fmgp.crypto.error.CryptoErrorCollection$;
import fmgp.crypto.error.CryptoFailToParse$;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.KeyMissingEpkJWEHeader$;
import fmgp.crypto.error.PointNotOnCurve$;
import fmgp.crypto.error.SomeThrowable$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.comm.AnonHeaderBuilder;
import fmgp.did.comm.AnonProtectedHeader;
import fmgp.did.comm.EncryptedMessageGeneric;
import fmgp.did.comm.ProtectedHeader;
import fmgp.util.Base64Obj;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import javax.crypto.SecretKey;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.json.package;

public final class ECDH_AnonEC$
implements ECDH_UtilsEC,
Serializable {
    public static final ECDH_AnonEC$ MODULE$ = new ECDH_AnonEC$();

    private ECDH_AnonEC$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ECDH_AnonEC$.class);
    }

    public Either<CryptoFailed, EncryptedMessageGeneric> encrypt(Seq<Tuple2<VerificationMethodReferenced, ECKey>> ecRecipientsKeys, AnonHeaderBuilder header, byte[] clearText) {
        return this.getCurve((Seq)ecRecipientsKeys).map((Function1 & Serializable)_$2 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$2)).map((Function1 & Serializable)curve -> {
            ECDH_AnonCryptoProvider myProvider = new ECDH_AnonCryptoProvider((com.nimbusds.jose.jwk.Curve)curve);
            com.nimbusds.jose.jwk.ECKey ephemeralKeyPair = new ECKeyGenerator(curve).generate();
            java.security.interfaces.ECPublicKey ephemeralPublicKey = ephemeralKeyPair.toECPublicKey();
            ECPrivateKey ephemeralPrivateKey = ephemeralKeyPair.toECPrivateKey();
            return Tuple5$.MODULE$.apply(curve, (Object)myProvider, (Object)ephemeralKeyPair, (Object)ephemeralPublicKey, (Object)ephemeralPrivateKey);
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple5 tuple5 = x$12;
            if (tuple5 != null) {
                com.nimbusds.jose.jwk.ECKey eCKey = (com.nimbusds.jose.jwk.ECKey)tuple5._3();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple5._1();
                ECDH_AnonCryptoProvider myProvider = (ECDH_AnonCryptoProvider)tuple5._2();
                if (eCKey != null) {
                    com.nimbusds.jose.jwk.ECKey ephemeralKeyPair = eCKey;
                    java.security.interfaces.ECPublicKey ephemeralPublicKey = (java.security.interfaces.ECPublicKey)tuple5._4();
                    ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)tuple5._5();
                    return package.DecoderOps$.MODULE$.fromJson$extension(zio.json.package$.MODULE$.DecoderOps((CharSequence)ephemeralKeyPair.toJSONString()), ECPublicKey$.MODULE$.decoder()).left().map((Function1 & Serializable)_$3 -> CryptoFailToParse$.MODULE$.apply(_$3)).map((Function1 & Serializable)ecKeyEphemeral -> {
                        AnonProtectedHeader updatedHeader = header.buildWithKey((PublicKey)ecKeyEphemeral);
                        Seq sharedSecrets = (Seq)ecRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                VerificationMethodReferenced vmr = (VerificationMethodReferenced)tuple2._1();
                                ECKey key = (ECKey)tuple2._2();
                                Object use_the_defualt_JCA_Provider = null;
                                return Tuple2$.MODULE$.apply((Object)vmr, (Object)ECDH.deriveSharedSecret((java.security.interfaces.ECPublicKey)UtilsJVM$.MODULE$.toJWK(key).toECPublicKey(), (PrivateKey)ephemeralPrivateKey, null));
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        EncryptedMessageGeneric ret = myProvider.encryptAUX((ProtectedHeader)updatedHeader, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, clearText);
                        return Tuple4$.MODULE$.apply(ecKeyEphemeral, (Object)updatedHeader, (Object)sharedSecrets, (Object)ret);
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple4 tuple4 = x$1;
                        if (tuple4 != null) {
                            ECPublicKey ecKeyEphemeral = (ECPublicKey)tuple4._1();
                            AnonProtectedHeader updatedHeader = (AnonProtectedHeader)tuple4._2();
                            Seq sharedSecrets = (Seq)tuple4._3();
                            EncryptedMessageGeneric ret = (EncryptedMessageGeneric)tuple4._4();
                            return ret;
                        }
                        throw new MatchError((Object)tuple4);
                    });
                }
            }
            throw new MatchError((Object)tuple5);
        });
    }

    public Either<CryptoFailed, byte[]> decrypt(Seq<Tuple2<VerificationMethodReferenced, ECKey>> ecRecipientsKeys, Base64Obj<ProtectedHeader> header, Seq<JWERecipient> recipients, String iv, String cipherText, String authTag) {
        return this.getCurve((Seq)ecRecipientsKeys).map((Function1 & Serializable)_$4 -> UtilsJVM$.MODULE$.toJWKCurve((Curve)_$4)).map((Function1 & Serializable)curve -> {
            ECDH_AnonCryptoProvider myProvider = new ECDH_AnonCryptoProvider((com.nimbusds.jose.jwk.Curve)curve);
            CriticalHeaderParamsDeferral aux = new CriticalHeaderParamsDeferral();
            aux.ensureHeaderPasses(UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header));
            CriticalHeaderParamsDeferral critPolicy = aux;
            return Tuple3$.MODULE$.apply(curve, (Object)myProvider, (Object)critPolicy);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                CriticalHeaderParamsDeferral criticalHeaderParamsDeferral = (CriticalHeaderParamsDeferral)tuple3._3();
                com.nimbusds.jose.jwk.Curve curve = (com.nimbusds.jose.jwk.Curve)tuple3._1();
                ECDH_AnonCryptoProvider myProvider = (ECDH_AnonCryptoProvider)tuple3._2();
                if (criticalHeaderParamsDeferral != null) {
                    CriticalHeaderParamsDeferral critPolicy = criticalHeaderParamsDeferral;
                    return Option$.MODULE$.apply((Object)UtilsJVM$package$given_Conversion_Base64Obj_JWEHeader$.MODULE$.apply(header).getEphemeralPublicKey()).map((Function1 & Serializable)_$5 -> (com.nimbusds.jose.jwk.ECKey)_$5).toRight(this::decrypt$$anonfun$3$$anonfun$2).flatMap((Function1 & Serializable)ephemeralKey -> CryptoErrorCollection$.MODULE$.unfold((Seq)ecRecipientsKeys.map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 instanceof Tuple2) {
                            Tuple2 recipient = tuple2;
                            com.nimbusds.jose.jwk.ECKey recipientKey = UtilsJVM$.MODULE$.toJWK((ECKey)recipient._2());
                            if (!ECChecks.isPointOnCurve((java.security.interfaces.ECPublicKey)ephemeralKey.toECPublicKey(), (ECPrivateKey)recipientKey.toECPrivateKey())) {
                                return package$.MODULE$.Left().apply((Object)PointNotOnCurve$.MODULE$.apply("Curve of ephemeral public key does not match curve of private key"));
                            }
                            Either either = Try$.MODULE$.apply(() -> this.decrypt$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$1(ephemeralKey, recipientKey)).toEither();
                            if (either instanceof Left) {
                                Throwable ex = (Throwable)((Left)either).value();
                                return package$.MODULE$.Left().apply((Object)SomeThrowable$.MODULE$.apply(ex));
                            }
                            if (either instanceof Right) {
                                SecretKey z = (SecretKey)((Right)either).value();
                                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply(recipient._1(), (Object)z));
                            }
                            throw new MatchError((Object)either);
                        }
                        throw new MatchError((Object)tuple2);
                    })).flatMap((Function1 & Serializable)sharedSecrets -> myProvider.decryptAUX(header, (Seq<Tuple2<VerificationMethodReferenced, SecretKey>>)sharedSecrets, recipients, iv, cipherText, authTag).map((Function1 & Serializable)ret -> ret)));
                }
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private final KeyMissingEpkJWEHeader$ decrypt$$anonfun$3$$anonfun$2() {
        return KeyMissingEpkJWEHeader$.MODULE$;
    }

    private final SecretKey decrypt$$anonfun$3$$anonfun$3$$anonfun$1$$anonfun$1(com.nimbusds.jose.jwk.ECKey ephemeralKey$2, com.nimbusds.jose.jwk.ECKey recipientKey$1) {
        return ECDH.deriveSharedSecret((java.security.interfaces.ECPublicKey)ephemeralKey$2.toECPublicKey(), (PrivateKey)recipientKey$1.toECPrivateKey(), null);
    }
}

