/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import fmgp.crypto.ECKey;
import fmgp.crypto.ECPrivateKey;
import fmgp.crypto.JWAAlgorithm;
import fmgp.crypto.JWAAlgorithm$;
import fmgp.crypto.JWT_JWM;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKPPrivateKey;
import fmgp.crypto.OKP_EC_Key;
import fmgp.crypto.OKP_EC_Key$;
import fmgp.crypto.PrivateKey;
import fmgp.crypto.PublicKey;
import fmgp.crypto.error.CryptoFailToParse$;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.CryptoNotImplementedError$;
import fmgp.crypto.error.FailToExtractKid;
import fmgp.crypto.error.FailToExtractKid$;
import fmgp.crypto.error.SomeThrowable;
import fmgp.crypto.error.SomeThrowable$;
import fmgp.crypto.error.UnknownError$;
import fmgp.crypto.error.WrongAlgorithmForKey$;
import fmgp.did.comm.JWMSignatureObj$;
import fmgp.did.comm.SignProtectedHeader$;
import fmgp.did.comm.SignedMessage;
import fmgp.did.comm.SignedMessage$;
import fmgp.typings.jose.generalSignMod;
import fmgp.typings.jose.mod;
import fmgp.typings.jose.mod$;
import fmgp.typings.jose.typesMod.CompactJWSHeaderParameters;
import fmgp.typings.jose.typesMod.GeneralJWSInput;
import fmgp.typings.jose.typesMod.JWK;
import fmgp.typings.jose.typesMod.JWK$;
import fmgp.typings.jose.typesMod.JWSHeaderParameters;
import fmgp.typings.jose.typesMod.JWTHeaderParameters;
import fmgp.typings.jose.typesMod.JWTPayload;
import fmgp.typings.jose.typesMod.KeyLike;
import fmgp.util.Base64;
import java.io.Serializable;
import org.scalablytyped.runtime.StObject;
import org.scalablytyped.runtime.StObject$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.ArrayOps$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.JSON$;
import scala.scalajs.js.JavaScriptException;
import scala.scalajs.js.Object;
import scala.scalajs.js.Promise;
import scala.scalajs.js.SyntaxError;
import scala.scalajs.js.TypeError;
import scala.scalajs.js.UndefOrOps$;
import scala.scalajs.js.internal.UnitOps$;
import scala.scalajs.js.typedarray.Uint8Array;
import scala.scalajs.js.typedarray.Uint8Array$;
import scala.util.ChainingOps$;
import scala.util.NotGiven$;
import scala.util.package;
import zio.CanFail$;
import zio.ZIO;
import zio.ZIO$;
import zio.json.package;
import zio.json.package$;

public final class UtilsJS$
implements Serializable {
    public static final UtilsJS$ MODULE$ = new UtilsJS$();

    private UtilsJS$() {
    }

    private java.lang.Object writeReplace() {
        return new ModuleSerializationProxy(UtilsJS$.class);
    }

    private JWK toJWK(OKP_EC_Key key) {
        java.lang.Object object;
        java.lang.Object object2;
        Object __obj = Dynamic.literal$.MODULE$.applyDynamic("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Tuple2[0]));
        JWK keyJWK = (JWK)__obj;
        JWK MutableBuilder_this = JWK$.MODULE$.MutableBuilder(keyJWK);
        String value$proxy1 = key.kty().toString();
        JWK cfr_ignored_0 = (JWK)StObject$.MODULE$.set((Any)MutableBuilder_this, "kty", (java.lang.Object)((Any)value$proxy1));
        JWK MutableBuilder_this2 = JWK$.MODULE$.MutableBuilder(keyJWK);
        String value$proxy2 = key.x();
        JWK cfr_ignored_1 = (JWK)StObject$.MODULE$.set((Any)MutableBuilder_this2, "x", (java.lang.Object)((Any)value$proxy2));
        OKP_EC_Key oKP_EC_Key = key;
        if (oKP_EC_Key instanceof ECKey) {
            ECKey ec = (ECKey)oKP_EC_Key;
            JWK MutableBuilder_this3 = JWK$.MODULE$.MutableBuilder(keyJWK);
            String value$proxy3 = ec.y();
            object2 = (JWK)StObject$.MODULE$.set((Any)MutableBuilder_this3, "y", (java.lang.Object)((Any)value$proxy3));
        } else if (oKP_EC_Key instanceof OKPKey) {
            OKPKey okp = (OKPKey)oKP_EC_Key;
            object2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((java.lang.Object)oKP_EC_Key);
        }
        JWK MutableBuilder_this4 = JWK$.MODULE$.MutableBuilder(keyJWK);
        String value$proxy4 = key.crv().toString();
        JWK cfr_ignored_2 = (JWK)StObject$.MODULE$.set((Any)MutableBuilder_this4, "crv", (java.lang.Object)((Any)value$proxy4));
        JWK MutableBuilder_this5 = JWK$.MODULE$.MutableBuilder(keyJWK);
        String value$proxy5 = key.alg().toString();
        JWK cfr_ignored_3 = (JWK)StObject$.MODULE$.set((Any)MutableBuilder_this5, "alg", (java.lang.Object)((Any)value$proxy5));
        key.kid().foreach((Function1 & Serializable)id -> {
            JWK MutableBuilder_this = JWK$.MODULE$.MutableBuilder(keyJWK);
            return (JWK)StObject$.MODULE$.set((Any)MutableBuilder_this, "kid", (java.lang.Object)((Any)id));
        });
        OKP_EC_Key oKP_EC_Key2 = key;
        if (oKP_EC_Key2 instanceof PublicKey) {
            object = BoxedUnit.UNIT;
        } else if (oKP_EC_Key2 instanceof PrivateKey) {
            PrivateKey k = (PrivateKey)oKP_EC_Key2;
            JWK MutableBuilder_this6 = JWK$.MODULE$.MutableBuilder(keyJWK);
            String value$proxy6 = k.d();
            object = (JWK)StObject$.MODULE$.set((Any)MutableBuilder_this6, "d", (java.lang.Object)((Any)value$proxy6));
        } else {
            throw new MatchError((java.lang.Object)oKP_EC_Key2);
        }
        return keyJWK;
    }

    public ZIO<java.lang.Object, CryptoFailed, Tuple3<KeyLike, String, String>> toKeyLike(OKP_EC_Key key) {
        Option option = key.kid();
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(() -> this.toKeyLike$$anonfun$1(key), (java.lang.Object)"fmgp.crypto.UtilsJS.toKeyLike(UtilsJS.scala:103)");
        }
        if (option instanceof Some) {
            String kid = (String)((Some)option).value();
            JWK aux = this.toJWK(key);
            return ZIO$.MODULE$.fromPromiseJS(() -> this.toKeyLike$$anonfun$2(aux), (java.lang.Object)"fmgp.crypto.UtilsJS.toKeyLike(UtilsJS.scala:107)").map((Function1 & Serializable)k -> {
                java.lang.Object object = UnitOps$.MODULE$.unitOrOps(aux.alg());
                return Tuple3$.MODULE$.apply((java.lang.Object)((KeyLike)k), (java.lang.Object)((String)UndefOrOps$.MODULE$.get$extension((.bar)object)), (java.lang.Object)kid);
            }, (java.lang.Object)"fmgp.crypto.UtilsJS.toKeyLike(UtilsJS.scala:108)").orElseFail(this::toKeyLike$$anonfun$4, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.toKeyLike(UtilsJS.scala:109)");
        }
        throw new MatchError((java.lang.Object)option);
    }

    public ZIO<java.lang.Object, CryptoFailed, java.lang.Object> verify(OKP_EC_Key key, SignedMessage jwm) {
        return ZIO$.MODULE$.from(() -> this.verify$$anonfun$1(jwm), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:115)").mapError((Function1 & Serializable)_$1 -> {
            SomeThrowable someThrowable;
            java.lang.Object object;
            Throwable throwable = _$1;
            if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                SyntaxError error = (SyntaxError)object;
                someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
            } else if (throwable != null) {
                Throwable ex = throwable;
                someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
            } else {
                throw new MatchError((java.lang.Object)throwable);
            }
            return (CryptoFailed)someThrowable;
        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:121)").flatMap((Function1 & Serializable)jwmAux -> this.toKeyLike(key).flatMap((Function1 & Serializable)thisKey -> ZIO$.MODULE$.fromPromiseJS(() -> this.verify$$anonfun$3$$anonfun$1$$anonfun$1(jwmAux, thisKey), (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:124)").map((Function1 & Serializable)_$2 -> true, (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:125)").catchAll((Function1 & Serializable)x$1 -> {
            java.lang.Object object;
            Throwable throwable = x$1;
            if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof TypeError) {
                TypeError ex = (TypeError)object;
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> false, (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:127)");
            }
            throw new MatchError((java.lang.Object)throwable);
        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:129)"), (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:130)").map((Function1 & Serializable)ret -> this.verify$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToBoolean((java.lang.Object)ret)), (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:131)"), (java.lang.Object)"fmgp.crypto.UtilsJS.verify(UtilsJS.scala:131)");
    }

    public ZIO<java.lang.Object, CryptoFailed, java.lang.Object> verifyJWT(OKP_EC_Key key, Tuple3<Vector<java.lang.Object>, Vector<java.lang.Object>, Vector<java.lang.Object>> jwt) {
        return this.toKeyLike(key).flatMap((Function1 & Serializable)thisKey -> ZIO$.MODULE$.fromPromiseJS(() -> this.verifyJWT$$anonfun$1$$anonfun$1(jwt, thisKey), (java.lang.Object)"fmgp.crypto.UtilsJS.verifyJWT(UtilsJS.scala:143)").map((Function1 & Serializable)_$3 -> true, (java.lang.Object)"fmgp.crypto.UtilsJS.verifyJWT(UtilsJS.scala:144)").catchAll((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof JavaScriptException) {
                java.lang.Object object = ((JavaScriptException)throwable).exception();
                if (object instanceof TypeError) {
                    TypeError ex = (TypeError)object;
                    return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> false, (java.lang.Object)"fmgp.crypto.UtilsJS.verifyJWT(UtilsJS.scala:146)");
                }
                if (object instanceof mod.errors.JWSSignatureVerificationFailed) {
                    mod.errors.JWSSignatureVerificationFailed ex = (mod.errors.JWSSignatureVerificationFailed)object;
                    return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> false, (java.lang.Object)"fmgp.crypto.UtilsJS.verifyJWT(UtilsJS.scala:147)");
                }
            }
            throw new MatchError((java.lang.Object)throwable);
        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.verifyJWT(UtilsJS.scala:148)"), (java.lang.Object)"fmgp.crypto.UtilsJS.verifyJWT(UtilsJS.scala:149)").map((Function1 & Serializable)ret -> this.verifyJWT$$anonfun$2(BoxesRunTime.unboxToBoolean((java.lang.Object)ret)), (java.lang.Object)"fmgp.crypto.UtilsJS.verifyJWT(UtilsJS.scala:150)");
    }

    public ZIO<java.lang.Object, CryptoFailed, SignedMessage> sign(PrivateKey key, byte[] payload) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> {
            java.lang.Object object = Predef$.MODULE$.byteArrayOps(payload);
            Iterable iterable = JSConverters$.MODULE$.JSRichIterable((Iterable)scala.collection.ArrayOps$.MODULE$.toSeq$extension(object).map((Function1 & Serializable)_$4 -> this.sign$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToByte((java.lang.Object)_$4))));
            return (Uint8Array)Uint8Array$.MODULE$.from(JSConverters.JSRichIterable$.MODULE$.toJSIterable$extension(iterable));
        }, (java.lang.Object)"fmgp.crypto.UtilsJS.sign(UtilsJS.scala:174)").flatMap((Function1 & Serializable)data -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
            KeyLike keyLike = (KeyLike)x$1._1();
            String string = (String)x$1._2();
            String string2 = (String)x$1._3();
            return ZIO$.MODULE$.fromPromiseJS(() -> this.sign$$anonfun$2$$anonfun$1$$anonfun$1(data, keyLike, string, string2), (java.lang.Object)"fmgp.crypto.UtilsJS.sign(UtilsJS.scala:185)").map((Function1 & Serializable)generalJWS -> {
                Array array = Any$.MODULE$.jsArrayOps(generalJWS.signatures());
                return SignedMessage$.MODULE$.apply(JWT_JWM.package.Payload$.MODULE$.fromBase64url(generalJWS.payload()), (Seq)ArrayOps$.MODULE$.toSeq$extension(array).map((Function1 & Serializable)v -> {
                    java.lang.Object object = UnitOps$.MODULE$.unitOrOps(v.protected());
                    return JWMSignatureObj$.MODULE$.apply(Base64.package.Base64$.MODULE$.unsafeAsObj(Base64.package.Base64$.MODULE$.apply((String)UndefOrOps$.MODULE$.get$extension((.bar)object)), SignProtectedHeader$.MODULE$.decoder()), JWT_JWM.package.SignatureJWM$.MODULE$.apply(v.signature()), JWMSignatureObj$.MODULE$.$lessinit$greater$default$3());
                }));
            }, (java.lang.Object)"fmgp.crypto.UtilsJS.sign(UtilsJS.scala:199)").orElseFail(this::sign$$anonfun$2$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.sign(UtilsJS.scala:200)");
        }, (java.lang.Object)"fmgp.crypto.UtilsJS.sign(UtilsJS.scala:201)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.sign(UtilsJS.scala:202)"), (java.lang.Object)"fmgp.crypto.UtilsJS.sign(UtilsJS.scala:202)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZIO<java.lang.Object, CryptoFailed, Tuple3<Vector<java.lang.Object>, Vector<java.lang.Object>, Vector<java.lang.Object>>> signJWT(PrivateKey key, byte[] payload, JWAAlgorithm alg) {
        ZIO zIO;
        PrivateKey privateKey = key;
        if (privateKey instanceof ECPrivateKey) {
            JWAAlgorithm jWAAlgorithm = alg;
            JWAAlgorithm jWAAlgorithm2 = JWAAlgorithm$.ES256K;
            JWAAlgorithm jWAAlgorithm3 = jWAAlgorithm;
            if (!(jWAAlgorithm2 != null ? !jWAAlgorithm2.equals(jWAAlgorithm3) : jWAAlgorithm3 != null)) {
                zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$1, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:211)");
                return zIO.flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                        SomeThrowable someThrowable;
                        java.lang.Object object;
                        Throwable throwable = _$6;
                        if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                            SyntaxError error = (SyntaxError)object;
                            someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                        } else if (throwable != null) {
                            Throwable ex = throwable;
                            someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                        } else {
                            throw new MatchError((java.lang.Object)throwable);
                        }
                        return (CryptoFailed)someThrowable;
                    }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                        KeyLike keyLike = (KeyLike)x$1._1();
                        String string = (String)x$1._2();
                        String string2 = (String)x$1._3();
                        return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                    }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
            } else {
                JWAAlgorithm jWAAlgorithm4 = JWAAlgorithm$.ES256;
                JWAAlgorithm jWAAlgorithm5 = jWAAlgorithm;
                if (!(jWAAlgorithm4 != null ? !jWAAlgorithm4.equals(jWAAlgorithm5) : jWAAlgorithm5 != null)) {
                    zIO = ZIO$.MODULE$.unit();
                    return zIO.flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                            SomeThrowable someThrowable;
                            java.lang.Object object;
                            Throwable throwable = _$6;
                            if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                                SyntaxError error = (SyntaxError)object;
                                someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                            } else if (throwable != null) {
                                Throwable ex = throwable;
                                someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                            } else {
                                throw new MatchError((java.lang.Object)throwable);
                            }
                            return (CryptoFailed)someThrowable;
                        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                            KeyLike keyLike = (KeyLike)x$1._1();
                            String string = (String)x$1._2();
                            String string2 = (String)x$1._3();
                            return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                        }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                    }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                } else {
                    JWAAlgorithm jWAAlgorithm6 = JWAAlgorithm$.ES384;
                    JWAAlgorithm jWAAlgorithm7 = jWAAlgorithm;
                    if (!(jWAAlgorithm6 != null ? !jWAAlgorithm6.equals(jWAAlgorithm7) : jWAAlgorithm7 != null)) {
                        zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$2, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:213)");
                        return zIO.flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                                SomeThrowable someThrowable;
                                java.lang.Object object;
                                Throwable throwable = _$6;
                                if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                                    SyntaxError error = (SyntaxError)object;
                                    someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                                } else if (throwable != null) {
                                    Throwable ex = throwable;
                                    someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                                } else {
                                    throw new MatchError((java.lang.Object)throwable);
                                }
                                return (CryptoFailed)someThrowable;
                            }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                                KeyLike keyLike = (KeyLike)x$1._1();
                                String string = (String)x$1._2();
                                String string2 = (String)x$1._3();
                                return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                            }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                        }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                    } else {
                        JWAAlgorithm jWAAlgorithm8 = JWAAlgorithm$.ES512;
                        JWAAlgorithm jWAAlgorithm9 = jWAAlgorithm;
                        if (!(jWAAlgorithm8 != null ? !jWAAlgorithm8.equals(jWAAlgorithm9) : jWAAlgorithm9 != null)) {
                            zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$3, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:214)");
                            return zIO.flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                                    SomeThrowable someThrowable;
                                    java.lang.Object object;
                                    Throwable throwable = _$6;
                                    if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                                        SyntaxError error = (SyntaxError)object;
                                        someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                                    } else if (throwable != null) {
                                        Throwable ex = throwable;
                                        someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                                    } else {
                                        throw new MatchError((java.lang.Object)throwable);
                                    }
                                    return (CryptoFailed)someThrowable;
                                }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                                    KeyLike keyLike = (KeyLike)x$1._1();
                                    String string = (String)x$1._2();
                                    String string2 = (String)x$1._3();
                                    return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                                }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                            }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                        } else {
                            JWAAlgorithm jWAAlgorithm10 = JWAAlgorithm$.EdDSA;
                            JWAAlgorithm jWAAlgorithm11 = jWAAlgorithm;
                            if (jWAAlgorithm10 != null ? !jWAAlgorithm10.equals(jWAAlgorithm11) : jWAAlgorithm11 != null) throw new MatchError((java.lang.Object)jWAAlgorithm);
                            zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$4, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:215)");
                        }
                    }
                }
            }
            return zIO.flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                    SomeThrowable someThrowable;
                    java.lang.Object object;
                    Throwable throwable = _$6;
                    if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                        SyntaxError error = (SyntaxError)object;
                        someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                    } else if (throwable != null) {
                        Throwable ex = throwable;
                        someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                    } else {
                        throw new MatchError((java.lang.Object)throwable);
                    }
                    return (CryptoFailed)someThrowable;
                }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                    KeyLike keyLike = (KeyLike)x$1._1();
                    String string = (String)x$1._2();
                    String string2 = (String)x$1._3();
                    return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
            }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
        } else {
            if (!(privateKey instanceof OKPPrivateKey)) throw new MatchError((java.lang.Object)privateKey);
            JWAAlgorithm jWAAlgorithm = alg;
            JWAAlgorithm jWAAlgorithm12 = JWAAlgorithm$.ES256K;
            JWAAlgorithm jWAAlgorithm13 = jWAAlgorithm;
            if (!(jWAAlgorithm12 != null ? !jWAAlgorithm12.equals(jWAAlgorithm13) : jWAAlgorithm13 != null)) {
                zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$5, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:218)");
                return zIO.flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                        SomeThrowable someThrowable;
                        java.lang.Object object;
                        Throwable throwable = _$6;
                        if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                            SyntaxError error = (SyntaxError)object;
                            someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                        } else if (throwable != null) {
                            Throwable ex = throwable;
                            someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                        } else {
                            throw new MatchError((java.lang.Object)throwable);
                        }
                        return (CryptoFailed)someThrowable;
                    }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                        KeyLike keyLike = (KeyLike)x$1._1();
                        String string = (String)x$1._2();
                        String string2 = (String)x$1._3();
                        return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                    }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
            } else {
                JWAAlgorithm jWAAlgorithm14 = JWAAlgorithm$.ES256;
                JWAAlgorithm jWAAlgorithm15 = jWAAlgorithm;
                if (!(jWAAlgorithm14 != null ? !jWAAlgorithm14.equals(jWAAlgorithm15) : jWAAlgorithm15 != null)) {
                    zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$6, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:219)");
                    return zIO.flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                            SomeThrowable someThrowable;
                            java.lang.Object object;
                            Throwable throwable = _$6;
                            if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                                SyntaxError error = (SyntaxError)object;
                                someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                            } else if (throwable != null) {
                                Throwable ex = throwable;
                                someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                            } else {
                                throw new MatchError((java.lang.Object)throwable);
                            }
                            return (CryptoFailed)someThrowable;
                        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                            KeyLike keyLike = (KeyLike)x$1._1();
                            String string = (String)x$1._2();
                            String string2 = (String)x$1._3();
                            return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                        }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                    }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                } else {
                    JWAAlgorithm jWAAlgorithm16 = JWAAlgorithm$.ES384;
                    JWAAlgorithm jWAAlgorithm17 = jWAAlgorithm;
                    if (!(jWAAlgorithm16 != null ? !jWAAlgorithm16.equals(jWAAlgorithm17) : jWAAlgorithm17 != null)) {
                        zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$7, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:220)");
                        return zIO.flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                                SomeThrowable someThrowable;
                                java.lang.Object object;
                                Throwable throwable = _$6;
                                if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                                    SyntaxError error = (SyntaxError)object;
                                    someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                                } else if (throwable != null) {
                                    Throwable ex = throwable;
                                    someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                                } else {
                                    throw new MatchError((java.lang.Object)throwable);
                                }
                                return (CryptoFailed)someThrowable;
                            }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                                KeyLike keyLike = (KeyLike)x$1._1();
                                String string = (String)x$1._2();
                                String string2 = (String)x$1._3();
                                return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                            }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                        }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                    } else {
                        JWAAlgorithm jWAAlgorithm18 = JWAAlgorithm$.ES512;
                        JWAAlgorithm jWAAlgorithm19 = jWAAlgorithm;
                        if (!(jWAAlgorithm18 != null ? !jWAAlgorithm18.equals(jWAAlgorithm19) : jWAAlgorithm19 != null)) {
                            zIO = ZIO$.MODULE$.fail(this::signJWT$$anonfun$8, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:221)");
                            return zIO.flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                                    SomeThrowable someThrowable;
                                    java.lang.Object object;
                                    Throwable throwable = _$6;
                                    if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                                        SyntaxError error = (SyntaxError)object;
                                        someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                                    } else if (throwable != null) {
                                        Throwable ex = throwable;
                                        someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                                    } else {
                                        throw new MatchError((java.lang.Object)throwable);
                                    }
                                    return (CryptoFailed)someThrowable;
                                }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                                    KeyLike keyLike = (KeyLike)x$1._1();
                                    String string = (String)x$1._2();
                                    String string2 = (String)x$1._3();
                                    return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
                                }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                            }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
                        } else {
                            JWAAlgorithm jWAAlgorithm20 = JWAAlgorithm$.EdDSA;
                            JWAAlgorithm jWAAlgorithm21 = jWAAlgorithm;
                            if (jWAAlgorithm20 != null ? !jWAAlgorithm20.equals(jWAAlgorithm21) : jWAAlgorithm21 != null) throw new MatchError((java.lang.Object)jWAAlgorithm);
                            zIO = ZIO$.MODULE$.unit();
                        }
                    }
                }
            }
        }
        return zIO.flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return ZIO$.MODULE$.from(() -> this.signJWT$$anonfun$9$$anonfun$1(payload), ZIO.ZIOConstructor$.MODULE$.AttemptConstructor(), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:225)").mapError((Function1 & Serializable)_$6 -> {
                SomeThrowable someThrowable;
                java.lang.Object object;
                Throwable throwable = _$6;
                if (throwable instanceof JavaScriptException && (object = ((JavaScriptException)throwable).exception()) instanceof SyntaxError) {
                    SyntaxError error = (SyntaxError)object;
                    someThrowable = CryptoFailToParse$.MODULE$.apply(new StringBuilder(26).append("JWT payload MUST be JSON: ").append(error.message()).toString());
                } else if (throwable != null) {
                    Throwable ex = throwable;
                    someThrowable = SomeThrowable$.MODULE$.apply(ex.getMessage());
                } else {
                    throw new MatchError((java.lang.Object)throwable);
                }
                return (CryptoFailed)someThrowable;
            }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:231)").flatMap((Function1 & Serializable)jwtPayload -> this.toKeyLike((OKP_EC_Key)key).flatMap((Function1 & Serializable)x$1 -> {
                KeyLike keyLike = (KeyLike)x$1._1();
                String string = (String)x$1._2();
                String string2 = (String)x$1._3();
                return ZIO$.MODULE$.fromPromiseJS(() -> this.signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(jwtPayload, string, string2, keyLike), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:239)").map((Function1 & Serializable)jwtStr -> JWT_JWM.package.JWT$.MODULE$.unsafeFromEncodedJWT(jwtStr), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:240)").orElseFail(this::signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:241)");
            }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:242)").map((Function1 & Serializable)ret -> ret, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)"), (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
        }, (java.lang.Object)"fmgp.crypto.UtilsJS.signJWT(UtilsJS.scala:243)");
    }

    private final FailToExtractKid toKeyLike$$anonfun$1(OKP_EC_Key key$1) {
        OKP_EC_Key oKP_EC_Key = (OKP_EC_Key)package$.MODULE$.EncoderOps((java.lang.Object)key$1);
        return FailToExtractKid$.MODULE$.apply(new StringBuilder(25).append("Fail to extract kid from ").append(package.EncoderOps$.MODULE$.toJson$extension((java.lang.Object)oKP_EC_Key, OKP_EC_Key$.MODULE$.encoder())).toString());
    }

    private final Promise toKeyLike$$anonfun$2(JWK aux$1) {
        return (Promise)((Dynamic)mod$.MODULE$.$up()).applyDynamic("importJWK", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Any[]{(Any)aux$1}));
    }

    private final UnknownError$ toKeyLike$$anonfun$4() {
        return UnknownError$.MODULE$;
    }

    private final GeneralJWSInput verify$$anonfun$1(SignedMessage jwm$1) {
        SignedMessage signedMessage = (SignedMessage)package$.MODULE$.EncoderOps((java.lang.Object)jwm$1);
        return (GeneralJWSInput)JSON$.MODULE$.parse(package.EncoderOps$.MODULE$.toJson$extension((java.lang.Object)signedMessage, SignedMessage$.MODULE$.encoder()), JSON$.MODULE$.parse$default$2());
    }

    private final Promise verify$$anonfun$3$$anonfun$1$$anonfun$1(GeneralJWSInput jwmAux$2, Tuple3 thisKey$1) {
        return (Promise)((Dynamic)mod$.MODULE$.$up()).applyDynamic("generalVerify", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Any[]{(Any)jwmAux$2, (Any)thisKey$1._1()}));
    }

    private final /* synthetic */ boolean verify$$anonfun$3$$anonfun$2(boolean ret) {
        return ret;
    }

    private final Promise verifyJWT$$anonfun$1$$anonfun$1(Tuple3 jwt$2, Tuple3 thisKey$2) {
        String jwt$proxy1 = JWT_JWM.package.JWT$.MODULE$.base64JWTFormat(jwt$2);
        return (Promise)((Dynamic)mod$.MODULE$.$up()).applyDynamic("jwtVerify", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Any[]{(Any)jwt$proxy1, (Any)thisKey$2._1()}));
    }

    private final /* synthetic */ boolean verifyJWT$$anonfun$2(boolean ret) {
        return ret;
    }

    private final /* synthetic */ short sign$$anonfun$1$$anonfun$1(byte _$4) {
        return _$4;
    }

    private final Promise sign$$anonfun$2$$anonfun$1$$anonfun$1(Uint8Array data$2, KeyLike thisKey$3, String alg$1, String kid$2) {
        mod.GeneralSign generalSign = (mod.GeneralSign)((java.lang.Object)package.chaining$.MODULE$.scalaUtilChainingOps((java.lang.Object)new mod.GeneralSign(data$2)));
        return ((generalSignMod.GeneralSign)((java.lang.Object)ChainingOps$.MODULE$.tap$extension((java.lang.Object)generalSign, (Function1 & Serializable)_$5 -> {
            Object __obj = Dynamic.literal$.MODULE$.applyDynamicNamed("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Tuple2[]{Tuple2$.MODULE$.apply((java.lang.Object)"alg", (java.lang.Object)((Any)alg$1))}));
            CompactJWSHeaderParameters compactJWSHeaderParameters = (CompactJWSHeaderParameters)StObject$.MODULE$.StObjectOps((StObject)((CompactJWSHeaderParameters)__obj));
            return _$5.addSignature(thisKey$3).setProtectedHeader((JWSHeaderParameters)StObject.StObjectOps$.MODULE$.set$extension((StObject)compactJWSHeaderParameters, "kid", (java.lang.Object)kid$2));
        }))).sign();
    }

    private final UnknownError$ sign$$anonfun$2$$anonfun$1$$anonfun$3() {
        return UnknownError$.MODULE$;
    }

    private final CryptoNotImplementedError$ signJWT$$anonfun$1() {
        return CryptoNotImplementedError$.MODULE$;
    }

    private final CryptoNotImplementedError$ signJWT$$anonfun$2() {
        return CryptoNotImplementedError$.MODULE$;
    }

    private final CryptoNotImplementedError$ signJWT$$anonfun$3() {
        return CryptoNotImplementedError$.MODULE$;
    }

    private final WrongAlgorithmForKey$ signJWT$$anonfun$4() {
        return WrongAlgorithmForKey$.MODULE$;
    }

    private final WrongAlgorithmForKey$ signJWT$$anonfun$5() {
        return WrongAlgorithmForKey$.MODULE$;
    }

    private final WrongAlgorithmForKey$ signJWT$$anonfun$6() {
        return WrongAlgorithmForKey$.MODULE$;
    }

    private final WrongAlgorithmForKey$ signJWT$$anonfun$7() {
        return WrongAlgorithmForKey$.MODULE$;
    }

    private final WrongAlgorithmForKey$ signJWT$$anonfun$8() {
        return WrongAlgorithmForKey$.MODULE$;
    }

    private final JWTPayload signJWT$$anonfun$9$$anonfun$1(byte[] payload$3) {
        return (JWTPayload)JSON$.MODULE$.parse(new String(payload$3), JSON$.MODULE$.parse$default$2());
    }

    private final Promise signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$1(JWTPayload jwtPayload$2, String alg$3, String kid$4, KeyLike thisKey$5) {
        Object __obj = Dynamic.literal$.MODULE$.applyDynamicNamed("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((java.lang.Object[])new Tuple2[]{Tuple2$.MODULE$.apply((java.lang.Object)"alg", (java.lang.Object)((Any)alg$3))}));
        JWTHeaderParameters jWTHeaderParameters = (JWTHeaderParameters)StObject$.MODULE$.StObjectOps((StObject)((JWTHeaderParameters)__obj));
        return new mod.SignJWT(jwtPayload$2).setProtectedHeader((JWTHeaderParameters)StObject.StObjectOps$.MODULE$.set$extension((StObject)jWTHeaderParameters, "kid", (java.lang.Object)kid$4)).sign(thisKey$5);
    }

    private final UnknownError$ signJWT$$anonfun$9$$anonfun$3$$anonfun$1$$anonfun$3() {
        return UnknownError$.MODULE$;
    }
}

