package fmgp.typings.jose.typesMod

import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

trait JWK
  extends StObject
     with JWKParameters {
  
  /**
    * - EC JWK "crv" (Curve) Parameter
    * - OKP JWK "crv" (The Subtype of Key Pair) Parameter
    */
  var crv: js.UndefOr[String] = js.undefined
  
  /**
    * - Private RSA JWK "d" (Private Exponent) Parameter
    * - Private EC JWK "d" (ECC Private Key) Parameter
    * - Private OKP JWK "d" (The Private Key) Parameter
    */
  var d: js.UndefOr[String] = js.undefined
  
  /** Private RSA JWK "dp" (First Factor CRT Exponent) Parameter */
  var dp: js.UndefOr[String] = js.undefined
  
  /** Private RSA JWK "dq" (Second Factor CRT Exponent) Parameter */
  var dq: js.UndefOr[String] = js.undefined
  
  /** RSA JWK "e" (Exponent) Parameter */
  var e: js.UndefOr[String] = js.undefined
  
  /** Oct JWK "k" (Key Value) Parameter */
  var k: js.UndefOr[String] = js.undefined
  
  /** RSA JWK "n" (Modulus) Parameter */
  var n: js.UndefOr[String] = js.undefined
  
  /** Private RSA JWK "p" (First Prime Factor) Parameter */
  var p: js.UndefOr[String] = js.undefined
  
  /** Private RSA JWK "q" (Second Prime Factor) Parameter */
  var q: js.UndefOr[String] = js.undefined
  
  /** Private RSA JWK "qi" (First CRT Coefficient) Parameter */
  var qi: js.UndefOr[String] = js.undefined
  
  /**
    * - EC JWK "x" (X Coordinate) Parameter
    * - OKP JWK "x" (The public key) Parameter
    */
  var x: js.UndefOr[String] = js.undefined
  
  /** EC JWK "y" (Y Coordinate) Parameter */
  var y: js.UndefOr[String] = js.undefined
}
object JWK {
  
  inline def apply(kty: String): JWK = {
    val __obj = js.Dynamic.literal(kty = kty.asInstanceOf[js.Any])
    __obj.asInstanceOf[JWK]
  }
  
  @scala.inline
  implicit open class MutableBuilder[Self <: JWK] (val x: Self) extends AnyVal {
    
    inline def setCrv(value: String): Self = StObject.set(x, "crv", value.asInstanceOf[js.Any])
    
    inline def setCrvUndefined: Self = StObject.set(x, "crv", js.undefined)
    
    inline def setD(value: String): Self = StObject.set(x, "d", value.asInstanceOf[js.Any])
    
    inline def setDUndefined: Self = StObject.set(x, "d", js.undefined)
    
    inline def setDp(value: String): Self = StObject.set(x, "dp", value.asInstanceOf[js.Any])
    
    inline def setDpUndefined: Self = StObject.set(x, "dp", js.undefined)
    
    inline def setDq(value: String): Self = StObject.set(x, "dq", value.asInstanceOf[js.Any])
    
    inline def setDqUndefined: Self = StObject.set(x, "dq", js.undefined)
    
    inline def setE(value: String): Self = StObject.set(x, "e", value.asInstanceOf[js.Any])
    
    inline def setEUndefined: Self = StObject.set(x, "e", js.undefined)
    
    inline def setK(value: String): Self = StObject.set(x, "k", value.asInstanceOf[js.Any])
    
    inline def setKUndefined: Self = StObject.set(x, "k", js.undefined)
    
    inline def setN(value: String): Self = StObject.set(x, "n", value.asInstanceOf[js.Any])
    
    inline def setNUndefined: Self = StObject.set(x, "n", js.undefined)
    
    inline def setP(value: String): Self = StObject.set(x, "p", value.asInstanceOf[js.Any])
    
    inline def setPUndefined: Self = StObject.set(x, "p", js.undefined)
    
    inline def setQ(value: String): Self = StObject.set(x, "q", value.asInstanceOf[js.Any])
    
    inline def setQUndefined: Self = StObject.set(x, "q", js.undefined)
    
    inline def setQi(value: String): Self = StObject.set(x, "qi", value.asInstanceOf[js.Any])
    
    inline def setQiUndefined: Self = StObject.set(x, "qi", js.undefined)
    
    inline def setX(value: String): Self = StObject.set(x, "x", value.asInstanceOf[js.Any])
    
    inline def setXUndefined: Self = StObject.set(x, "x", js.undefined)
    
    inline def setY(value: String): Self = StObject.set(x, "y", value.asInstanceOf[js.Any])
    
    inline def setYUndefined: Self = StObject.set(x, "y", js.undefined)
  }
}
