package fmgp.typings.jose.typesMod

import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

trait JWKParameters extends StObject {
  
  /**
    * JWK "alg" (Algorithm) Parameter
    *
    * @see {@link https://github.com/panva/jose/issues/210 Algorithm Key Requirements}
    */
  var alg: js.UndefOr[String] = js.undefined
  
  /** JWK "ext" (Extractable) Parameter */
  var ext: js.UndefOr[Boolean] = js.undefined
  
  /** JWK "key_ops" (Key Operations) Parameter */
  var key_ops: js.UndefOr[js.Array[String]] = js.undefined
  
  /** JWK "kid" (Key ID) Parameter */
  var kid: js.UndefOr[String] = js.undefined
  
  /** JWK "kty" (Key Type) Parameter */
  var kty: String
  
  /** JWK "use" (Public Key Use) Parameter */
  var use: js.UndefOr[String] = js.undefined
  
  /** JWK "x5c" (X.509 Certificate Chain) Parameter */
  var x5c: js.UndefOr[js.Array[String]] = js.undefined
  
  /** JWK "x5t" (X.509 Certificate SHA-1 Thumbprint) Parameter */
  var x5t: js.UndefOr[String] = js.undefined
  
  /** JWK "x5t#S256" (X.509 Certificate SHA-256 Thumbprint) Parameter */
  @JSName("x5t#S256")
  var x5tNumbersignS256: js.UndefOr[String] = js.undefined
  
  /** JWK "x5u" (X.509 URL) Parameter */
  var x5u: js.UndefOr[String] = js.undefined
}
object JWKParameters {
  
  inline def apply(kty: String): JWKParameters = {
    val __obj = js.Dynamic.literal(kty = kty.asInstanceOf[js.Any])
    __obj.asInstanceOf[JWKParameters]
  }
  
  @scala.inline
  implicit open class MutableBuilder[Self <: JWKParameters] (val x: Self) extends AnyVal {
    
    inline def setAlg(value: String): Self = StObject.set(x, "alg", value.asInstanceOf[js.Any])
    
    inline def setAlgUndefined: Self = StObject.set(x, "alg", js.undefined)
    
    inline def setExt(value: Boolean): Self = StObject.set(x, "ext", value.asInstanceOf[js.Any])
    
    inline def setExtUndefined: Self = StObject.set(x, "ext", js.undefined)
    
    inline def setKey_ops(value: js.Array[String]): Self = StObject.set(x, "key_ops", value.asInstanceOf[js.Any])
    
    inline def setKey_opsUndefined: Self = StObject.set(x, "key_ops", js.undefined)
    
    inline def setKey_opsVarargs(value: String*): Self = StObject.set(x, "key_ops", js.Array(value*))
    
    inline def setKid(value: String): Self = StObject.set(x, "kid", value.asInstanceOf[js.Any])
    
    inline def setKidUndefined: Self = StObject.set(x, "kid", js.undefined)
    
    inline def setKty(value: String): Self = StObject.set(x, "kty", value.asInstanceOf[js.Any])
    
    inline def setUse(value: String): Self = StObject.set(x, "use", value.asInstanceOf[js.Any])
    
    inline def setUseUndefined: Self = StObject.set(x, "use", js.undefined)
    
    inline def setX5c(value: js.Array[String]): Self = StObject.set(x, "x5c", value.asInstanceOf[js.Any])
    
    inline def setX5cUndefined: Self = StObject.set(x, "x5c", js.undefined)
    
    inline def setX5cVarargs(value: String*): Self = StObject.set(x, "x5c", js.Array(value*))
    
    inline def setX5t(value: String): Self = StObject.set(x, "x5t", value.asInstanceOf[js.Any])
    
    inline def setX5tNumbersignS256(value: String): Self = StObject.set(x, "x5t#S256", value.asInstanceOf[js.Any])
    
    inline def setX5tNumbersignS256Undefined: Self = StObject.set(x, "x5t#S256", js.undefined)
    
    inline def setX5tUndefined: Self = StObject.set(x, "x5t", js.undefined)
    
    inline def setX5u(value: String): Self = StObject.set(x, "x5u", value.asInstanceOf[js.Any])
    
    inline def setX5uUndefined: Self = StObject.set(x, "x5u", js.undefined)
  }
}
