/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import fmgp.crypto.CryptoOperations;
import fmgp.crypto.Curve;
import fmgp.crypto.Curve$;
import fmgp.crypto.ECDH$;
import fmgp.crypto.ECKey;
import fmgp.crypto.ECPrivateKey;
import fmgp.crypto.ECPublicKey;
import fmgp.crypto.JWERecipient;
import fmgp.crypto.JWERecipient$;
import fmgp.crypto.OKPKey;
import fmgp.crypto.OKPPrivateKey;
import fmgp.crypto.OKPPublicKey;
import fmgp.crypto.OKP_EC_Key;
import fmgp.crypto.PlatformSpecificOperations$;
import fmgp.crypto.PrivateKey;
import fmgp.crypto.PublicKey;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.DidFail;
import fmgp.crypto.error.MissingDecryptionKey;
import fmgp.crypto.error.MissingDecryptionKey$;
import fmgp.crypto.error.NoKeys$;
import fmgp.crypto.error.WrongKeysTypeCombination$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.VerificationMethodReferencedWithKey;
import fmgp.did.VerificationMethodReferencedWithKey$;
import fmgp.did.comm.AnonHeaderBuilder;
import fmgp.did.comm.AnonHeaderBuilder$;
import fmgp.did.comm.AuthHeaderBuilder;
import fmgp.did.comm.AuthHeaderBuilder$;
import fmgp.did.comm.ENCAlgorithm$;
import fmgp.did.comm.EncryptedMessage;
import fmgp.did.comm.KWAlgorithm$;
import fmgp.did.comm.OpaqueTypes;
import fmgp.did.comm.PlaintextMessage;
import fmgp.did.comm.ProtectedHeader;
import fmgp.did.comm.SignedMessage;
import fmgp.util.Base64Obj;
import fmgp.util.IOR;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.ChainingOps$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.package;
import zio.ZIO;
import zio.ZIO$;

public final class CryptoOperationsImp$
implements CryptoOperations,
Serializable {
    public static final CryptoOperationsImp$ MODULE$ = new CryptoOperationsImp$();

    private CryptoOperationsImp$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CryptoOperationsImp$.class);
    }

    public ZIO<Object, CryptoFailed, SignedMessage> sign(PrivateKey key, PlaintextMessage plaintext) {
        return PlatformSpecificOperations$.MODULE$.sign(key, plaintext);
    }

    public ZIO<Object, CryptoFailed, Object> verify(PublicKey key, SignedMessage jwm) {
        return PlatformSpecificOperations$.MODULE$.verify(key, jwm);
    }

    public ZIO<Object, CryptoFailed, EncryptedMessage> anonEncrypt(Seq<Tuple2<VerificationMethodReferenced, PublicKey>> recipientKidsKeys, byte[] data) {
        return (ZIO)((IterableOps)recipientKidsKeys.groupBy((Function1 & Serializable)_$1 -> ((OKP_EC_Key)_$1._2()).crv()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Curve curve = (Curve)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                if (curve == Curve$.P$minus256 || curve == Curve$.P$minus384 || curve == Curve$.P$minus521 || curve == Curve$.secp256k1) {
                    Seq keys = seq;
                    return this.anoncryptEC((Seq<Tuple2<VerificationMethodReferenced, ECKey>>)keys, data);
                }
                if (curve == Curve$.X25519 || curve == Curve$.Ed25519) {
                    Seq keys = seq;
                    return this.anoncryptOKP((Seq<Tuple2<VerificationMethodReferenced, OKPKey>>)keys, data);
                }
            }
            throw new MatchError((Object)tuple2);
        })).headOption().getOrElse(this::anonEncrypt$$anonfun$3);
    }

    public ZIO<Object, CryptoFailed, EncryptedMessage> authEncrypt(Tuple2<VerificationMethodReferenced, PrivateKey> senderKidKey, Seq<Tuple2<VerificationMethodReferenced, PublicKey>> recipientKidsKeys, byte[] data) {
        PrivateKey privateKey = (PrivateKey)senderKidKey._2();
        if (privateKey instanceof ECKey) {
            ECKey ecSenderKey = (ECKey)privateKey;
            return this.authcryptEC((Tuple2<VerificationMethodReferenced, ECKey>)Tuple2$.MODULE$.apply(senderKidKey._1(), (Object)ecSenderKey), (Seq<VerificationMethodReferencedWithKey<ECPublicKey>>)((Seq)((IterableOps)Option$.MODULE$.option2Iterable(recipientKidsKeys.groupBy((Function1 & Serializable)_$2 -> ((OKP_EC_Key)_$2._2()).crv()).get((Object)ecSenderKey.crv())).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)e -> VerificationMethodReferencedWithKey$.MODULE$.apply(((VerificationMethodReferenced)e._1()).value(), (OKP_EC_Key)((ECPublicKey)e._2())))), data);
        }
        if (privateKey instanceof OKPKey) {
            OKPKey okpSenderKey = (OKPKey)privateKey;
            return this.authcryptOKP((Tuple2<VerificationMethodReferenced, OKPKey>)Tuple2$.MODULE$.apply(senderKidKey._1(), (Object)okpSenderKey), (Seq<VerificationMethodReferencedWithKey<OKPPublicKey>>)((Seq)((IterableOps)Option$.MODULE$.option2Iterable(recipientKidsKeys.groupBy((Function1 & Serializable)_$3 -> ((OKP_EC_Key)_$3._2()).crv()).get((Object)okpSenderKey.crv())).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)e -> VerificationMethodReferencedWithKey$.MODULE$.apply(((VerificationMethodReferenced)e._1()).value(), (OKP_EC_Key)((OKPPublicKey)e._2())))), data);
        }
        throw new MatchError((Object)privateKey);
    }

    public ZIO<Object, CryptoFailed, EncryptedMessage> anoncryptEC(Seq<Tuple2<VerificationMethodReferenced, ECKey>> ecRecipientsKeys, byte[] clearText) {
        AnonHeaderBuilder header = AnonHeaderBuilder$.MODULE$.apply(OpaqueTypes.package.APV$.MODULE$.apply((Seq)ecRecipientsKeys.map((Function1 & Serializable)_$4 -> (VerificationMethodReferenced)_$4._1())), ENCAlgorithm$.A256CBC$minusHS512, KWAlgorithm$.ECDH$minusES$plusA256KW);
        return ZIO$.MODULE$.fromEither(() -> this.anoncryptEC$$anonfun$1(ecRecipientsKeys, clearText, header), (Object)"fmgp.crypto.CryptoOperationsImp.anoncryptEC(CryptoOperationsImp.scala:79)");
    }

    public ZIO<Object, CryptoFailed, EncryptedMessage> anoncryptOKP(Seq<Tuple2<VerificationMethodReferenced, OKPKey>> okpRecipientKeys, byte[] clearText) {
        AnonHeaderBuilder header = AnonHeaderBuilder$.MODULE$.apply(OpaqueTypes.package.APV$.MODULE$.apply((Seq)okpRecipientKeys.map((Function1 & Serializable)_$5 -> (VerificationMethodReferenced)_$5._1())), ENCAlgorithm$.A256CBC$minusHS512, KWAlgorithm$.ECDH$minusES$plusA256KW);
        return ZIO$.MODULE$.fromEither(() -> this.anoncryptOKP$$anonfun$1(okpRecipientKeys, clearText, header), (Object)"fmgp.crypto.CryptoOperationsImp.anoncryptOKP(CryptoOperationsImp.scala:92)");
    }

    public ZIO<Object, CryptoFailed, EncryptedMessage> authcryptEC(Tuple2<VerificationMethodReferenced, ECKey> senderKidKey, Seq<VerificationMethodReferencedWithKey<ECPublicKey>> recipientKeys, byte[] clearText) {
        AuthHeaderBuilder header = AuthHeaderBuilder$.MODULE$.apply(OpaqueTypes.package.APV$.MODULE$.apply((Seq)recipientKeys.map((Function1 & Serializable)_$6 -> _$6.vmr())), (VerificationMethodReferenced)senderKidKey._1(), OpaqueTypes.package.APU$.MODULE$.apply((VerificationMethodReferenced)senderKidKey._1()), ENCAlgorithm$.A256CBC$minusHS512, KWAlgorithm$.ECDH$minus1PU$plusA256KW);
        return ZIO$.MODULE$.fromEither(() -> this.authcryptEC$$anonfun$1(senderKidKey, recipientKeys, clearText, header), (Object)"fmgp.crypto.CryptoOperationsImp.authcryptEC(CryptoOperationsImp.scala:107)");
    }

    public ZIO<Object, CryptoFailed, EncryptedMessage> authcryptOKP(Tuple2<VerificationMethodReferenced, OKPKey> senderKidKey, Seq<VerificationMethodReferencedWithKey<OKPPublicKey>> recipientKeys, byte[] clearText) {
        AuthHeaderBuilder header = AuthHeaderBuilder$.MODULE$.apply(OpaqueTypes.package.APV$.MODULE$.apply((Seq)recipientKeys.map((Function1 & Serializable)_$7 -> _$7.vmr())), (VerificationMethodReferenced)senderKidKey._1(), OpaqueTypes.package.APU$.MODULE$.apply((VerificationMethodReferenced)senderKidKey._1()), ENCAlgorithm$.A256CBC$minusHS512, KWAlgorithm$.ECDH$minus1PU$plusA256KW);
        return ZIO$.MODULE$.fromEither(() -> this.authcryptOKP$$anonfun$1(senderKidKey, recipientKeys, clearText, header), (Object)"fmgp.crypto.CryptoOperationsImp.authcryptOKP(CryptoOperationsImp.scala:122)");
    }

    public ZIO<Object, DidFail, byte[]> anonDecrypt(Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> recipientKidsKeys, EncryptedMessage msg) {
        Seq kids = (Seq)msg.recipients().map((Function1 & Serializable)_$8 -> _$8.header().kid().value());
        Seq seq = (Seq)recipientKidsKeys.filterNot((Function1 & Serializable)e -> kids.contains(e._1()));
        if (seq != null) {
            SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                return ZIO$.MODULE$.fail(() -> this.anonDecrypt$$anonfun$2(kids), (Object)"fmgp.crypto.CryptoOperationsImp.anonDecrypt(CryptoOperationsImp.scala:139)");
            }
            Option option = package$.MODULE$.$plus$colon().unapply((SeqOps)seq);
            if (!option.isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                Tuple2 firstKey = (Tuple2)tuple2._1();
                Seq tail = (Seq)tuple2._2();
                PrivateKey privateKey = (PrivateKey)firstKey._2();
                if (privateKey instanceof ECKey) {
                    ECKey ecKey = (ECKey)privateKey;
                    Seq jweRecipient = (Seq)msg.recipients().map((Function1 & Serializable)recipient -> JWERecipient$.MODULE$.apply(recipient.header().kid(), (Vector<Object>)recipient.encrypted_key()));
                    Seq ecRecipientsKeys = (Seq)recipientKidsKeys.map((Function1 & Serializable)e -> Tuple2$.MODULE$.apply(e._1(), (Object)((ECPrivateKey)e._2())));
                    return ZIO$.MODULE$.fromEither(() -> this.anonDecrypt$$anonfun$3(msg, jweRecipient, ecRecipientsKeys), (Object)"fmgp.crypto.CryptoOperationsImp.anonDecrypt(CryptoOperationsImp.scala:148)");
                }
                if (privateKey instanceof OKPKey) {
                    OKPKey okpKey = (OKPKey)privateKey;
                    Seq fixme = (Seq)recipientKidsKeys.map((Function1 & Serializable)e -> Tuple2$.MODULE$.apply(e._1(), (Object)((OKPPrivateKey)e._2())));
                    Seq jweRecipient = (Seq)msg.recipients().map((Function1 & Serializable)recipient -> JWERecipient$.MODULE$.apply(recipient.header().kid(), (Vector<Object>)recipient.encrypted_key()));
                    return ZIO$.MODULE$.fromEither(() -> this.anonDecrypt$$anonfun$4(msg, fixme, jweRecipient), (Object)"fmgp.crypto.CryptoOperationsImp.anonDecrypt(CryptoOperationsImp.scala:155)");
                }
                throw new MatchError((Object)privateKey);
            }
        }
        throw new MatchError((Object)seq);
    }

    public ZIO<Object, DidFail, byte[]> authDecrypt(PublicKey senderKey, Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> recipientKidsKeys, EncryptedMessage msg) {
        Seq jweRecipient = (Seq)msg.recipients().map((Function1 & Serializable)recipient -> JWERecipient$.MODULE$.apply(recipient.header().kid(), (Vector<Object>)recipient.encrypted_key()));
        PublicKey publicKey = senderKey;
        if (publicKey instanceof ECKey) {
            ECKey ecSenderKey = (ECKey)publicKey;
            return ZIO$.MODULE$.foreach((Iterable)msg.recipients(), (Function1 & Serializable)recipien -> {
                Option option = (Option)package.chaining$.MODULE$.scalaUtilChainingOps((Object)recipientKidsKeys.find((Function1 & Serializable)_$9 -> {
                    String string = ((VerificationMethodReferenced)_$9._1()).value();
                    String string2 = recipien.header().kid().value();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }));
                return (ZIO)ChainingOps$.MODULE$.pipe$extension((Object)option, (Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> package$.MODULE$.Left().apply((Object)MissingDecryptionKey$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{recipien.header().kid().value()}))), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:177)");
                    }
                    if (option instanceof Some) {
                        Tuple2 tuple2 = (Tuple2)((Some)option).value();
                        if (tuple2 != null) {
                            PrivateKey privateKey = (PrivateKey)tuple2._2();
                            VerificationMethodReferenced id = (VerificationMethodReferenced)tuple2._1();
                            if (privateKey instanceof ECKey) {
                                ECKey key = (ECKey)privateKey;
                                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> package$.MODULE$.Right().apply((Object)Tuple3$.MODULE$.apply((Object)recipien.encrypted_key(), (Object)id, (Object)key)), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:178)");
                            }
                        }
                        return ZIO$.MODULE$.fail(this::authDecrypt$$anonfun$1$$anonfun$2$$anonfun$3, (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:179)");
                    }
                    throw new MatchError((Object)option);
                });
            }, BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:181)").map((Function1 & Serializable)e -> (IOR.Both)e.foldLeft((Object)IOR.Both$.MODULE$.apply((Object)None$.MODULE$, (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    IOR.Both both = (IOR.Both)tuple2._1();
                    Either either = (Either)tuple2._2();
                    if (both != null) {
                        IOR.Both both2 = IOR.Both$.MODULE$.unapply(both);
                        Option option = (Option)both2._1();
                        Seq seq = (Seq)both2._2();
                        if (None$.MODULE$.equals(option)) {
                            Seq b = seq;
                            if (either instanceof Left) {
                                MissingDecryptionKey newEx = (MissingDecryptionKey)((Left)either).value();
                                return IOR.Both$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)newEx), (Object)b);
                            }
                        }
                        if (option instanceof Some) {
                            MissingDecryptionKey oldEx = (MissingDecryptionKey)((Some)option).value();
                            Seq b = seq;
                            if (either instanceof Left) {
                                MissingDecryptionKey newEx = (MissingDecryptionKey)((Left)either).value();
                                return IOR.Both$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)oldEx.$plus(newEx)), (Object)b);
                            }
                        }
                        Option a = option;
                        Seq b = seq;
                        if (either instanceof Right) {
                            Tuple3 r = (Tuple3)((Right)either).value();
                            return IOR.Both$.MODULE$.apply((Object)a, b.$colon$plus((Object)r));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:193)").map((Function1 & Serializable)x$12 -> {
                IOR.Both both = x$12;
                if (both != null) {
                    IOR.Both both2 = IOR.Both$.MODULE$.unapply(both);
                    Option option = (Option)both2._1();
                    Seq seq = (Seq)both2._2();
                    Option warnings = option;
                    Seq encryptedKey_vmr_keys = seq;
                    Seq ecRecipientsKeys = (Seq)encryptedKey_vmr_keys.map((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            Vector encryptedKey = (Vector)tuple3._1();
                            VerificationMethodReferenced vmr = (VerificationMethodReferenced)tuple3._2();
                            ECKey keys = (ECKey)tuple3._3();
                            return Tuple2$.MODULE$.apply((Object)vmr, (Object)keys);
                        }
                        throw new MatchError((Object)tuple3);
                    });
                    return ECDH$.MODULE$.authDecryptEC(ecSenderKey, (Seq<Tuple2<VerificationMethodReferenced, ECKey>>)ecRecipientsKeys, (Base64Obj<ProtectedHeader>)this.header$6(msg), (Seq<JWERecipient>)jweRecipient, msg.iv(), msg.ciphertext(), msg.tag());
                }
                throw new MatchError((Object)both);
            }, (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:197)").flatMap((Function1 & Serializable)v -> ZIO$.MODULE$.fromEither(() -> this.authDecrypt$$anonfun$4$$anonfun$1(v), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:198)"), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:198)");
        }
        if (publicKey instanceof OKPKey) {
            OKPKey okpSenderKey = (OKPKey)publicKey;
            return ZIO$.MODULE$.foreach((Iterable)msg.recipients(), (Function1 & Serializable)recipien -> {
                Option option = (Option)package.chaining$.MODULE$.scalaUtilChainingOps((Object)recipientKidsKeys.find((Function1 & Serializable)_$10 -> {
                    String string = ((VerificationMethodReferenced)_$10._1()).value();
                    String string2 = recipien.header().kid().value();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }));
                return (ZIO)ChainingOps$.MODULE$.pipe$extension((Object)option, (Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> package$.MODULE$.Left().apply((Object)MissingDecryptionKey$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{recipien.header().kid().value()}))), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:205)");
                    }
                    if (option instanceof Some) {
                        Tuple2 tuple2 = (Tuple2)((Some)option).value();
                        if (tuple2 != null) {
                            PrivateKey privateKey = (PrivateKey)tuple2._2();
                            VerificationMethodReferenced id = (VerificationMethodReferenced)tuple2._1();
                            if (privateKey instanceof OKPKey) {
                                OKPKey key = (OKPKey)privateKey;
                                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> package$.MODULE$.Right().apply((Object)Tuple3$.MODULE$.apply((Object)recipien.encrypted_key(), (Object)id, (Object)key)), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:206)");
                            }
                        }
                        return ZIO$.MODULE$.fail(this::authDecrypt$$anonfun$5$$anonfun$2$$anonfun$3, (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:207)");
                    }
                    throw new MatchError((Object)option);
                });
            }, BuildFrom$.MODULE$.buildFromIterableOps(), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:209)").map((Function1 & Serializable)e -> (IOR.Both)e.foldLeft((Object)IOR.Both$.MODULE$.apply((Object)None$.MODULE$, (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    IOR.Both both = (IOR.Both)tuple2._1();
                    Either either = (Either)tuple2._2();
                    if (both != null) {
                        IOR.Both both2 = IOR.Both$.MODULE$.unapply(both);
                        Option option = (Option)both2._1();
                        Seq seq = (Seq)both2._2();
                        if (None$.MODULE$.equals(option)) {
                            Seq b = seq;
                            if (either instanceof Left) {
                                MissingDecryptionKey newEx = (MissingDecryptionKey)((Left)either).value();
                                return IOR.Both$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)newEx), (Object)b);
                            }
                        }
                        if (option instanceof Some) {
                            MissingDecryptionKey oldEx = (MissingDecryptionKey)((Some)option).value();
                            Seq b = seq;
                            if (either instanceof Left) {
                                MissingDecryptionKey newEx = (MissingDecryptionKey)((Left)either).value();
                                return IOR.Both$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)oldEx.$plus(newEx)), (Object)b);
                            }
                        }
                        Option a = option;
                        Seq b = seq;
                        if (either instanceof Right) {
                            Tuple3 r = (Tuple3)((Right)either).value();
                            return IOR.Both$.MODULE$.apply((Object)a, b.$colon$plus((Object)r));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:221)").map((Function1 & Serializable)x$12 -> {
                IOR.Both both = x$12;
                if (both != null) {
                    IOR.Both both2 = IOR.Both$.MODULE$.unapply(both);
                    Option option = (Option)both2._1();
                    Seq seq = (Seq)both2._2();
                    Option warnings = option;
                    Seq encryptedKey_vmr_keys = seq;
                    Seq okpRecipientsKeys = (Seq)encryptedKey_vmr_keys.map((Function1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 != null) {
                            Vector encryptedKey = (Vector)tuple3._1();
                            VerificationMethodReferenced vmr = (VerificationMethodReferenced)tuple3._2();
                            OKPKey keys = (OKPKey)tuple3._3();
                            return Tuple2$.MODULE$.apply((Object)vmr, (Object)keys);
                        }
                        throw new MatchError((Object)tuple3);
                    });
                    return ECDH$.MODULE$.authDecryptOKP(okpSenderKey, (Seq<Tuple2<VerificationMethodReferenced, OKPKey>>)okpRecipientsKeys, (Base64Obj<ProtectedHeader>)this.header$6(msg), (Seq<JWERecipient>)jweRecipient, msg.iv(), msg.ciphertext(), msg.tag());
                }
                throw new MatchError((Object)both);
            }, (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:226)").flatMap((Function1 & Serializable)v -> ZIO$.MODULE$.fromEither(() -> this.authDecrypt$$anonfun$8$$anonfun$1(v), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:227)"), (Object)"fmgp.crypto.CryptoOperationsImp.authDecrypt(CryptoOperationsImp.scala:227)");
        }
        throw new MatchError((Object)publicKey);
    }

    private final NoKeys$ anonEncrypt$$anonfun$3$$anonfun$1() {
        return NoKeys$.MODULE$;
    }

    private final ZIO anonEncrypt$$anonfun$3() {
        return ZIO$.MODULE$.fail(this::anonEncrypt$$anonfun$3$$anonfun$1, (Object)"fmgp.crypto.CryptoOperationsImp.anonEncrypt(CryptoOperationsImp.scala:40)");
    }

    private final Either anoncryptEC$$anonfun$1(Seq ecRecipientsKeys$1, byte[] clearText$1, AnonHeaderBuilder header$1) {
        return ECDH$.MODULE$.anonEncryptEC((Seq<Tuple2<VerificationMethodReferenced, ECKey>>)ecRecipientsKeys$1, header$1, clearText$1);
    }

    private final Either anoncryptOKP$$anonfun$1(Seq okpRecipientKeys$1, byte[] clearText$2, AnonHeaderBuilder header$2) {
        return ECDH$.MODULE$.anonEncryptOKP((Seq<Tuple2<VerificationMethodReferenced, OKPKey>>)okpRecipientKeys$1, header$2, clearText$2);
    }

    private final Either authcryptEC$$anonfun$1(Tuple2 senderKidKey$1, Seq recipientKeys$1, byte[] clearText$3, AuthHeaderBuilder header$3) {
        return ECDH$.MODULE$.authEncryptEC((ECKey)senderKidKey$1._2(), (Seq<VerificationMethodReferencedWithKey<ECPublicKey>>)recipientKeys$1, header$3, clearText$3);
    }

    private final Either authcryptOKP$$anonfun$1(Tuple2 senderKidKey$2, Seq recipientKeys$2, byte[] clearText$4, AuthHeaderBuilder header$4) {
        return ECDH$.MODULE$.authEncryptOKP((OKPKey)senderKidKey$2._2(), (Seq<VerificationMethodReferencedWithKey<OKPPublicKey>>)recipientKeys$2, header$4, clearText$4);
    }

    private final Base64Obj header$5(EncryptedMessage msg$1) {
        return msg$1.protected();
    }

    private final MissingDecryptionKey anonDecrypt$$anonfun$2(Seq kids$2) {
        return MissingDecryptionKey$.MODULE$.apply(kids$2);
    }

    private final Either anonDecrypt$$anonfun$3(EncryptedMessage msg$2, Seq jweRecipient$1, Seq ecRecipientsKeys$2) {
        return ECDH$.MODULE$.anonDecryptEC((Seq<Tuple2<VerificationMethodReferenced, ECKey>>)ecRecipientsKeys$2, (Base64Obj<ProtectedHeader>)this.header$5(msg$2), (Seq<JWERecipient>)jweRecipient$1, msg$2.iv(), msg$2.ciphertext(), msg$2.tag());
    }

    private final Either anonDecrypt$$anonfun$4(EncryptedMessage msg$3, Seq fixme$1, Seq jweRecipient$2) {
        return ECDH$.MODULE$.anonDecryptOKP((Seq<Tuple2<VerificationMethodReferenced, OKPKey>>)fixme$1, (Base64Obj<ProtectedHeader>)this.header$5(msg$3), (Seq<JWERecipient>)jweRecipient$2, msg$3.iv(), msg$3.ciphertext(), msg$3.tag());
    }

    private final Base64Obj header$6(EncryptedMessage msg$4) {
        return msg$4.protected();
    }

    private final WrongKeysTypeCombination$ authDecrypt$$anonfun$1$$anonfun$2$$anonfun$3() {
        return WrongKeysTypeCombination$.MODULE$;
    }

    private final Either authDecrypt$$anonfun$4$$anonfun$1(Either v$1) {
        return v$1;
    }

    private final WrongKeysTypeCombination$ authDecrypt$$anonfun$5$$anonfun$2$$anonfun$3() {
        return WrongKeysTypeCombination$.MODULE$;
    }

    private final Either authDecrypt$$anonfun$8$$anonfun$1(Either v$2) {
        return v$2;
    }
}

