/*
 * Decompiled with CFR 0.152.
 */
package fmgp.prism;

import fmgp.prism.PrismKeyUsage;
import fmgp.prism.PrismPublicKey;
import fmgp.prism.PrismPublicKey$CompressedECKey$;
import fmgp.prism.PrismPublicKey$UncompressedECKey$;
import fmgp.prism.PrismPublicKey$VoidKey$;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left$;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CrytoUtil$
implements Serializable {
    private static final BouncyCastleProvider provider;
    public static final CrytoUtil$ MODULE$;

    private CrytoUtil$() {
    }

    static {
        MODULE$ = new CrytoUtil$();
        provider = new BouncyCastleProvider();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CrytoUtil$.class);
    }

    public BouncyCastleProvider provider() {
        return provider;
    }

    public Either<String, PublicKey> unsafeFromPrismPublicKey(PrismPublicKey key) {
        PrismPublicKey prismPublicKey = key;
        if (prismPublicKey instanceof PrismPublicKey.VoidKey) {
            PrismPublicKey.VoidKey voidKey = PrismPublicKey$VoidKey$.MODULE$.unapply((PrismPublicKey.VoidKey)prismPublicKey);
            String string = voidKey._1();
            String string2 = voidKey._2();
            String id = string;
            String reason = string2;
            return Left$.MODULE$.apply((Object)new StringBuilder(29).append("Fail to parse key '").append(id).append("' becuase ").append(reason).toString());
        }
        if (prismPublicKey instanceof PrismPublicKey.UncompressedECKey) {
            PrismPublicKey.UncompressedECKey uncompressedECKey = PrismPublicKey$UncompressedECKey$.MODULE$.unapply((PrismPublicKey.UncompressedECKey)prismPublicKey);
            String string = uncompressedECKey._1();
            PrismKeyUsage prismKeyUsage = uncompressedECKey._2();
            String string3 = uncompressedECKey._3();
            byte[] byArray = uncompressedECKey._4();
            byte[] byArray2 = uncompressedECKey._5();
            String id = string;
            PrismKeyUsage usage = prismKeyUsage;
            String curve = string3;
            byte[] x = byArray;
            byte[] y = byArray2;
            return this.unsafeFromByteCoordinates(x, y);
        }
        if (prismPublicKey instanceof PrismPublicKey.CompressedECKey) {
            PrismPublicKey.CompressedECKey compressedECKey = PrismPublicKey$CompressedECKey$.MODULE$.unapply((PrismPublicKey.CompressedECKey)prismPublicKey);
            String string = compressedECKey._1();
            PrismKeyUsage prismKeyUsage = compressedECKey._2();
            String string4 = compressedECKey._3();
            byte[] byArray = compressedECKey._4();
            String id = string;
            PrismKeyUsage usage = prismKeyUsage;
            String curve = string4;
            byte[] data = byArray;
            return this.unsafeFromCompressed(data);
        }
        throw new MatchError((Object)prismPublicKey);
    }

    public Either<String, PublicKey> unsafeFromCompressed(byte[] com) {
        ECParameterSpec params2;
        Object object;
        ECCurve curve;
        EllipticCurve ellipticCurve;
        ECPoint point;
        ECPublicKeySpec keySpec;
        ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        KeyFactory fact = KeyFactory.getInstance("ECDSA", (Provider)this.provider());
        Try try_ = Try$.MODULE$.apply(() -> CrytoUtil$.unsafeFromCompressed$$anonfun$1(fact, keySpec = new ECPublicKeySpec(point = ECPointUtil.decodePoint((EllipticCurve)(ellipticCurve = EC5Util.convertCurve((ECCurve)(curve = params.getCurve()), (byte[])params.getSeed())), (byte[])((byte[])ArrayOps$.MODULE$.toArray$extension(object = Predef$.MODULE$.byteArrayOps(com), ClassTag$.MODULE$.apply(Byte.TYPE)))), params2 = EC5Util.convertSpec((EllipticCurve)ellipticCurve, (org.bouncycastle.jce.spec.ECParameterSpec)params))));
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof InvalidKeySpecException) {
                InvalidKeySpecException exception = (InvalidKeySpecException)throwable;
                return Left$.MODULE$.apply((Object)exception.getMessage());
            }
            Throwable exception = throwable;
            return Left$.MODULE$.apply((Object)exception.getMessage());
        }
        if (try_ instanceof Success) {
            PublicKey value = (PublicKey)((Success)try_).value();
            return Right$.MODULE$.apply((Object)value);
        }
        throw new MatchError((Object)try_);
    }

    public Either<String, PublicKey> unsafeFromByteCoordinates(byte[] x, byte[] y) {
        BigInt xx = package$.MODULE$.BigInt().apply(1, x);
        BigInt yy = package$.MODULE$.BigInt().apply(1, y);
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", (Provider)this.provider());
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECNamedCurveSpec ecNamedCurveSpec = new ECNamedCurveSpec(ecParameterSpec.getName(), ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(new ECPoint(xx.bigInteger(), yy.bigInteger()), (ECParameterSpec)ecNamedCurveSpec);
        Try try_ = Try$.MODULE$.apply(() -> CrytoUtil$.unsafeFromByteCoordinates$$anonfun$1(keyFactory, ecPublicKeySpec));
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof InvalidKeySpecException) {
                InvalidKeySpecException exception = (InvalidKeySpecException)throwable;
                return Left$.MODULE$.apply((Object)exception.getMessage());
            }
            Throwable exception = throwable;
            return Left$.MODULE$.apply((Object)exception.getMessage());
        }
        if (try_ instanceof Success) {
            ECPublicKey value = (ECPublicKey)((Success)try_).value();
            return Right$.MODULE$.apply((Object)value);
        }
        throw new MatchError((Object)try_);
    }

    public Either<String, PublicKey> unsafeFromBigIntegerCoordinates(BigInt x, BigInt y) {
        ECParameterSpec params2;
        ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        KeyFactory fact = KeyFactory.getInstance("ECDSA", (Provider)this.provider());
        ECCurve curve = params.getCurve();
        EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)curve, (byte[])params.getSeed());
        ECPoint point = new ECPoint(x.bigInteger(), y.bigInteger());
        ECPublicKeySpec keySpec = new ECPublicKeySpec(point, params2 = EC5Util.convertSpec((EllipticCurve)ellipticCurve, (org.bouncycastle.jce.spec.ECParameterSpec)params));
        Try try_ = Try$.MODULE$.apply(() -> CrytoUtil$.unsafeFromBigIntegerCoordinates$$anonfun$1(fact, keySpec));
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof InvalidKeySpecException) {
                InvalidKeySpecException exception = (InvalidKeySpecException)throwable;
                return Left$.MODULE$.apply((Object)exception.getMessage());
            }
            Throwable exception = throwable;
            return Left$.MODULE$.apply((Object)exception.getMessage());
        }
        if (try_ instanceof Success) {
            PublicKey value = (PublicKey)((Success)try_).value();
            return Right$.MODULE$.apply((Object)value);
        }
        throw new MatchError((Object)try_);
    }

    public Either<String, Object> checkECDSASignature(byte[] msg, byte[] sig, PublicKey pubKey) {
        Signature ecdsa = Signature.getInstance("SHA256withECDSA", (Provider)this.provider());
        ecdsa.initVerify(pubKey);
        ecdsa.update(msg);
        Try try_ = Try$.MODULE$.apply(() -> CrytoUtil$.checkECDSASignature$$anonfun$1(ecdsa, sig));
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof SignatureException) {
                SignatureException exception = (SignatureException)throwable;
                return Left$.MODULE$.apply((Object)exception.getMessage());
            }
            Throwable exception = throwable;
            return Left$.MODULE$.apply((Object)exception.getMessage());
        }
        if (try_ instanceof Success) {
            boolean value = BoxesRunTime.unboxToBoolean((Object)((Success)try_).value());
            return Right$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)value));
        }
        throw new MatchError((Object)try_);
    }

    public Either<String, byte[]> signECDSASignature(byte[] msg, PrivateKey pivKey) {
        Signature ecdsa = Signature.getInstance("SHA256withECDSA", (Provider)this.provider());
        ecdsa.initSign(pivKey);
        ecdsa.update(msg);
        Try try_ = Try$.MODULE$.apply(() -> CrytoUtil$.signECDSASignature$$anonfun$1(ecdsa));
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            return Left$.MODULE$.apply((Object)exception.getMessage());
        }
        if (try_ instanceof Success) {
            byte[] value = (byte[])((Success)try_).value();
            return Right$.MODULE$.apply((Object)value);
        }
        throw new MatchError((Object)try_);
    }

    public Tuple2<ECPrivateKeyParameters, ECPublicKeyParameters> generateKeyPair() {
        ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECDomainParameters domainParams = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH(), params.getSeed());
        SecureRandom secureRandom = new SecureRandom();
        ECKeyGenerationParameters keyParams = new ECKeyGenerationParameters(domainParams, secureRandom);
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        generator.init((KeyGenerationParameters)keyParams);
        AsymmetricCipherKeyPair keyPair = generator.generateKeyPair();
        ECPrivateKeyParameters privateKeyParams = (ECPrivateKeyParameters)keyPair.getPrivate();
        ECPublicKeyParameters publicKeyParams = (ECPublicKeyParameters)keyPair.getPublic();
        byte[] privateKeyBytes = privateKeyParams.getD().toByteArray();
        byte[] publicKeyBytes = publicKeyParams.getQ().getEncoded(true);
        return Tuple2$.MODULE$.apply((Object)privateKeyParams, (Object)publicKeyParams);
    }

    private static final PublicKey unsafeFromCompressed$$anonfun$1(KeyFactory fact$1, ECPublicKeySpec keySpec$1) {
        return fact$1.generatePublic(keySpec$1);
    }

    private static final ECPublicKey unsafeFromByteCoordinates$$anonfun$1(KeyFactory keyFactory$1, ECPublicKeySpec ecPublicKeySpec$1) {
        return (ECPublicKey)keyFactory$1.generatePublic(ecPublicKeySpec$1);
    }

    private static final PublicKey unsafeFromBigIntegerCoordinates$$anonfun$1(KeyFactory fact$2, ECPublicKeySpec keySpec$2) {
        return fact$2.generatePublic(keySpec$2);
    }

    private static final boolean checkECDSASignature$$anonfun$1(Signature ecdsa$1, byte[] sig$1) {
        return ecdsa$1.verify(sig$1);
    }

    private static final byte[] signECDSASignature$$anonfun$1(Signature ecdsa$2) {
        return ecdsa$2.sign();
    }
}

