/*
 * Decompiled with CFR 0.152.
 */
package fmgp.prism;

import fmgp.crypto.Curve;
import fmgp.crypto.Curve$;
import fmgp.crypto.ECPublicKeyWithoutKid;
import fmgp.crypto.ECPublicKeyWithoutKid$;
import fmgp.crypto.KTY$;
import fmgp.crypto.Key;
import fmgp.crypto.OKPPublicKeyWithoutKid;
import fmgp.crypto.OKPPublicKeyWithoutKid$;
import fmgp.crypto.PublicKey;
import fmgp.crypto.PublicKeyWithoutKid;
import fmgp.did.VerificationMethod;
import fmgp.did.VerificationMethodEmbeddedJWK;
import fmgp.did.VerificationMethodEmbeddedJWK$;
import fmgp.prism.PrismKeyUsage;
import fmgp.prism.PrismPublicKey$;
import fmgp.prism.PrismPublicKey$CompressedECKey$;
import fmgp.prism.PrismPublicKey$UncompressedECKey$;
import fmgp.prism.PrismPublicKey$VoidKey$;
import fmgp.prism.SharedCryto$;
import fmgp.util.Base64;
import fmgp.util.Base64$package$;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import zio.json.JsonDecoder;
import zio.json.JsonEncoder;

public interface PrismPublicKey {
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(PrismPublicKey$.class.getDeclaredField("encoderECKey$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(PrismPublicKey$.class.getDeclaredField("decoderECKey$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(PrismPublicKey$.class.getDeclaredField("encoder$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(PrismPublicKey$.class.getDeclaredField("decoder$lzy1"));

    public static JsonDecoder<PrismPublicKey> decoder() {
        return PrismPublicKey$.MODULE$.decoder();
    }

    public static JsonDecoder<Serializable> decoderECKey() {
        return PrismPublicKey$.MODULE$.decoderECKey();
    }

    public static JsonEncoder<PrismPublicKey> encoder() {
        return PrismPublicKey$.MODULE$.encoder();
    }

    public static JsonEncoder<Serializable> encoderECKey() {
        return PrismPublicKey$.MODULE$.encoderECKey();
    }

    public static Seq<Serializable> filterECKey(Seq<PrismPublicKey> seq) {
        return PrismPublicKey$.MODULE$.filterECKey(seq);
    }

    public static PrismPublicKey fromProto(proto.prism.PublicKey publicKey) {
        return PrismPublicKey$.MODULE$.fromProto(publicKey);
    }

    public static int ordinal(PrismPublicKey prismPublicKey) {
        return PrismPublicKey$.MODULE$.ordinal(prismPublicKey);
    }

    public String id();

    public static class CompressedECKey
    implements PrismPublicKey_TMP,
    Product,
    Serializable {
        private final String id;
        private final PrismKeyUsage usage;
        private final String curve;
        private final byte[] data;

        public static CompressedECKey apply(String string, PrismKeyUsage prismKeyUsage, String string2, byte[] byArray) {
            return PrismPublicKey$CompressedECKey$.MODULE$.apply(string, prismKeyUsage, string2, byArray);
        }

        public static CompressedECKey fromProduct(Product product) {
            return PrismPublicKey$CompressedECKey$.MODULE$.fromProduct(product);
        }

        public static CompressedECKey unapply(CompressedECKey compressedECKey) {
            return PrismPublicKey$CompressedECKey$.MODULE$.unapply(compressedECKey);
        }

        public CompressedECKey(String id, PrismKeyUsage usage, String curve, byte[] data) {
            this.id = id;
            this.usage = usage;
            this.curve = curve;
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompressedECKey)) return false;
            CompressedECKey compressedECKey = (CompressedECKey)object;
            String string = this.id();
            String string2 = compressedECKey.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            PrismKeyUsage prismKeyUsage = this.usage();
            PrismKeyUsage prismKeyUsage2 = compressedECKey.usage();
            if (prismKeyUsage == null) {
                if (prismKeyUsage2 != null) {
                    return false;
                }
            } else if (!prismKeyUsage.equals(prismKeyUsage2)) return false;
            String string3 = this.curve();
            String string4 = compressedECKey.curve();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.data() != compressedECKey.data()) return false;
            if (!compressedECKey.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CompressedECKey;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "CompressedECKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "usage";
                }
                case 2: {
                    return "curve";
                }
                case 3: {
                    return "data";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public PrismKeyUsage usage() {
            return this.usage;
        }

        @Override
        public String curve() {
            return this.curve;
        }

        public byte[] data() {
            return this.data;
        }

        @Override
        public PublicKeyWithoutKid publicKey() {
            OKPPublicKeyWithoutKid oKPPublicKeyWithoutKid;
            Curve curve = Curve$.MODULE$.valueOf(this.curve());
            if (curve == Curve$.P$minus256 || curve == Curve$.P$minus384 || curve == Curve$.P$minus521 || curve == Curve$.secp256k1) {
                Curve c = curve;
                Tuple2 tuple2 = (Tuple2)SharedCryto$.MODULE$.getXY(this.data()).getOrElse(PrismPublicKey$::fmgp$prism$PrismPublicKey$CompressedECKey$$_$_$$anonfun$5);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String x = (String)tuple2._1();
                String y = (String)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)x, (Object)y);
                String x2 = (String)tuple22._1();
                String y2 = (String)tuple22._2();
                Base64$package$ base64$package$ = Base64$package$.MODULE$;
                Base64.package.Base64$ Base64$_this = Base64.package.Base64$.MODULE$;
                Base64$package$ Base64$package$_this = base64$package$;
                Object object = Predef$.MODULE$.byteArrayOps(this.data());
                byte[] data$proxy1 = (byte[])ArrayOps$.MODULE$.slice$extension(object, 1, 33);
                Base64$package$ base64$package$2 = Base64$package$.MODULE$;
                Base64.package.Base64$ Base64$_this2 = Base64.package.Base64$.MODULE$;
                Base64$package$ Base64$package$_this2 = base64$package$2;
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(y2.replaceAll("[^0-9A-Fa-f]", "")), 2, 2).toArray(ClassTag$.MODULE$.apply(String.class)));
                byte[] data$proxy2 = (byte[])ArrayOps$.MODULE$.map$extension(object2, PrismPublicKey$::fmgp$prism$PrismPublicKey$CompressedECKey$$_$_$$anonfun$6, ClassTag$.MODULE$.apply(Byte.TYPE));
                oKPPublicKeyWithoutKid = ECPublicKeyWithoutKid$.MODULE$.apply(KTY$.EC, (Curve)Key.package.ECCurve$.MODULE$.valueOf(this.curve()).getOrElse(PrismPublicKey$::fmgp$prism$PrismPublicKey$CompressedECKey$$_$publicKey$$anonfun$2), Base64.package.Base64$.MODULE$.urlBase64(Predef$.MODULE$.wrapByteArray(Base64$_this.urlEncoder().encode(data$proxy1)).toVector()), Base64.package.Base64$.MODULE$.urlBase64(Predef$.MODULE$.wrapByteArray(Base64$_this2.urlEncoder().encode(data$proxy2)).toVector()));
            } else if (curve == Curve$.X25519 || curve == Curve$.Ed25519) {
                Curve c = curve;
                Base64$package$ base64$package$ = Base64$package$.MODULE$;
                Base64.package.Base64$ Base64$_this = Base64.package.Base64$.MODULE$;
                Base64$package$ Base64$package$_this = base64$package$;
                oKPPublicKeyWithoutKid = OKPPublicKeyWithoutKid$.MODULE$.apply(KTY$.OKP, c, Base64.package.Base64$.MODULE$.urlBase64(Predef$.MODULE$.wrapByteArray(Base64$_this.urlEncoder().encode(this.data())).toVector()));
            } else {
                throw new MatchError((Object)curve);
            }
            return (PublicKeyWithoutKid)oKPPublicKeyWithoutKid;
        }

        public CompressedECKey copy(String id, PrismKeyUsage usage, String curve, byte[] data) {
            return new CompressedECKey(id, usage, curve, data);
        }

        public String copy$default$1() {
            return this.id();
        }

        public PrismKeyUsage copy$default$2() {
            return this.usage();
        }

        public String copy$default$3() {
            return this.curve();
        }

        public byte[] copy$default$4() {
            return this.data();
        }

        public String _1() {
            return this.id();
        }

        public PrismKeyUsage _2() {
            return this.usage();
        }

        public String _3() {
            return this.curve();
        }

        public byte[] _4() {
            return this.data();
        }
    }

    public static interface PrismPublicKey_TMP
    extends PrismPublicKey {
        public PrismKeyUsage usage();

        public String curve();

        public PublicKeyWithoutKid publicKey();

        public static VerificationMethodEmbeddedJWK getVerificationMethod$(PrismPublicKey_TMP $this, String id, String controller) {
            return $this.getVerificationMethod(id, controller);
        }

        default public VerificationMethodEmbeddedJWK getVerificationMethod(String id, String controller) {
            return VerificationMethodEmbeddedJWK$.MODULE$.apply(id, controller, VerificationMethod.package.VerificationMethodType$.MODULE$.JsonWebKey2020(), (Option)None$.MODULE$, (Option)None$.MODULE$, (PublicKey)this.publicKey().withKid(id), (Option)None$.MODULE$);
        }
    }

    public static class UncompressedECKey
    implements PrismPublicKey_TMP,
    Product,
    Serializable {
        private final String id;
        private final PrismKeyUsage usage;
        private final String curve;
        private final byte[] x;
        private final byte[] y;

        public static UncompressedECKey apply(String string, PrismKeyUsage prismKeyUsage, String string2, byte[] byArray, byte[] byArray2) {
            return PrismPublicKey$UncompressedECKey$.MODULE$.apply(string, prismKeyUsage, string2, byArray, byArray2);
        }

        public static UncompressedECKey fromProduct(Product product) {
            return PrismPublicKey$UncompressedECKey$.MODULE$.fromProduct(product);
        }

        public static UncompressedECKey unapply(UncompressedECKey uncompressedECKey) {
            return PrismPublicKey$UncompressedECKey$.MODULE$.unapply(uncompressedECKey);
        }

        public UncompressedECKey(String id, PrismKeyUsage usage, String curve, byte[] x, byte[] y) {
            this.id = id;
            this.usage = usage;
            this.curve = curve;
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UncompressedECKey)) return false;
            UncompressedECKey uncompressedECKey = (UncompressedECKey)object;
            String string = this.id();
            String string2 = uncompressedECKey.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            PrismKeyUsage prismKeyUsage = this.usage();
            PrismKeyUsage prismKeyUsage2 = uncompressedECKey.usage();
            if (prismKeyUsage == null) {
                if (prismKeyUsage2 != null) {
                    return false;
                }
            } else if (!prismKeyUsage.equals(prismKeyUsage2)) return false;
            String string3 = this.curve();
            String string4 = uncompressedECKey.curve();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.x() != uncompressedECKey.x()) return false;
            if (this.y() != uncompressedECKey.y()) return false;
            if (!uncompressedECKey.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UncompressedECKey;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "UncompressedECKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "usage";
                }
                case 2: {
                    return "curve";
                }
                case 3: {
                    return "x";
                }
                case 4: {
                    return "y";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public PrismKeyUsage usage() {
            return this.usage;
        }

        @Override
        public String curve() {
            return this.curve;
        }

        public byte[] x() {
            return this.x;
        }

        public byte[] y() {
            return this.y;
        }

        public ECPublicKeyWithoutKid publicKey() {
            Base64$package$ base64$package$ = Base64$package$.MODULE$;
            Base64.package.Base64$ Base64$_this = Base64.package.Base64$.MODULE$;
            Base64$package$ Base64$package$_this = base64$package$;
            Base64$package$ base64$package$2 = Base64$package$.MODULE$;
            Base64.package.Base64$ Base64$_this2 = Base64.package.Base64$.MODULE$;
            Base64$package$ Base64$package$_this2 = base64$package$2;
            return ECPublicKeyWithoutKid$.MODULE$.apply(KTY$.EC, (Curve)Key.package.ECCurve$.MODULE$.valueOf(this.curve()).getOrElse(PrismPublicKey$::fmgp$prism$PrismPublicKey$UncompressedECKey$$_$publicKey$$anonfun$1), Base64.package.Base64$.MODULE$.urlBase64(Predef$.MODULE$.wrapByteArray(Base64$_this.urlEncoder().encode(this.x())).toVector()), Base64.package.Base64$.MODULE$.urlBase64(Predef$.MODULE$.wrapByteArray(Base64$_this2.urlEncoder().encode(this.y())).toVector()));
        }

        public UncompressedECKey copy(String id, PrismKeyUsage usage, String curve, byte[] x, byte[] y) {
            return new UncompressedECKey(id, usage, curve, x, y);
        }

        public String copy$default$1() {
            return this.id();
        }

        public PrismKeyUsage copy$default$2() {
            return this.usage();
        }

        public String copy$default$3() {
            return this.curve();
        }

        public byte[] copy$default$4() {
            return this.x();
        }

        public byte[] copy$default$5() {
            return this.y();
        }

        public String _1() {
            return this.id();
        }

        public PrismKeyUsage _2() {
            return this.usage();
        }

        public String _3() {
            return this.curve();
        }

        public byte[] _4() {
            return this.x();
        }

        public byte[] _5() {
            return this.y();
        }
    }

    public static class VoidKey
    implements PrismPublicKey,
    Product,
    Serializable {
        private final String id;
        private final String reason;

        public static VoidKey apply(String string, String string2) {
            return PrismPublicKey$VoidKey$.MODULE$.apply(string, string2);
        }

        public static VoidKey fromProduct(Product product) {
            return PrismPublicKey$VoidKey$.MODULE$.fromProduct(product);
        }

        public static VoidKey unapply(VoidKey voidKey) {
            return PrismPublicKey$VoidKey$.MODULE$.unapply(voidKey);
        }

        public VoidKey(String id, String reason) {
            this.id = id;
            this.reason = reason;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VoidKey)) return false;
            VoidKey voidKey = (VoidKey)object;
            String string = this.id();
            String string2 = voidKey.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.reason();
            String string4 = voidKey.reason();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!voidKey.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof VoidKey;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "VoidKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "reason";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String id() {
            return this.id;
        }

        public String reason() {
            return this.reason;
        }

        public VoidKey copy(String id, String reason) {
            return new VoidKey(id, reason);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.reason();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.reason();
        }
    }
}

