package fmgp.typings.nobleCurves.abstractWeierstrassMod

import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

/* import warning: RemoveDifficultInheritance.summarizeChanges 
- Dropped / * import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Group<ProjPointType<T>> * / any */ @js.native
trait ProjPointType[T] extends StObject {
  
  /** @deprecated use `p.precompute(windowSize)` */
  def _setWindowSize(windowSize: Double): Unit = js.native
  
  def assertValidity(): Unit = js.native
  
  def clearCofactor(): ProjPointType[T] = js.native
  
  /** @deprecated use `p.y % 2n === 0n` */
  def hasEvenY(): Boolean = js.native
  
  def is0(): Boolean = js.native
  
  def isTorsionFree(): Boolean = js.native
  
  /** @deprecated use `multiplyUnsafe` */
  def multiplyAndAddUnsafe(Q: ProjPointType[T], a: js.BigInt, b: js.BigInt): js.UndefOr[ProjPointType[T]] = js.native
  
  def multiplyUnsafe(scalar: js.BigInt): ProjPointType[T] = js.native
  
  /**
    * Massively speeds up `p.multiply(n)` by using wnaf precompute tables (caching).
    * Table generation takes 30MB of ram and 10ms on high-end CPU, but may take
    * much longer on slow devices.
    * Actual generation will happen on first call of `.multiply()`.
    * By default, BASE point is precomputed.
    * @param windowSize - table window size
    * @param isLazy - (default true) allows to defer generation
    */
  def precompute(): ProjPointType[T] = js.native
  def precompute(windowSize: Double): ProjPointType[T] = js.native
  def precompute(windowSize: Double, isLazy: Boolean): ProjPointType[T] = js.native
  def precompute(windowSize: Unit, isLazy: Boolean): ProjPointType[T] = js.native
  
  /** projective x coordinate. Note: different from .x */
  val px: T = js.native
  
  /** projective y coordinate. Note: different from .y */
  val py: T = js.native
  
  /** projective z coordinate */
  val pz: T = js.native
  
  /** Converts 3D XYZ projective point to 2D xy affine coordinates */
  def toAffine(): Any = js.native
  def toAffine(invertedZ: T): Any = js.native
  
  /** Encodes point using IEEE P1363 (DER) encoding. First byte is 2/3/4. Default = isCompressed. */
  def toBytes(): js.typedarray.Uint8Array = js.native
  def toBytes(isCompressed: Boolean): js.typedarray.Uint8Array = js.native
  
  def toHex(): String = js.native
  def toHex(isCompressed: Boolean): String = js.native
  
  /** @deprecated use `toBytes` */
  def toRawBytes(): js.typedarray.Uint8Array = js.native
  def toRawBytes(isCompressed: Boolean): js.typedarray.Uint8Array = js.native
  
  /** affine x coordinate */
  def x: T = js.native
  
  /** affine y coordinate */
  def y: T = js.native
}
