package fmgp.typings.nobleCurves

import fmgp.typings.nobleCurves.anon.A
import fmgp.typings.nobleCurves.anon.B
import fmgp.typings.nobleCurves.anon.D
import fmgp.typings.nobleCurves.anon.F
import fmgp.typings.nobleCurves.anon.NBitLength
import fmgp.typings.nobleCurves.anon.P1
import fmgp.typings.nobleCurves.nobleCurvesStrings.edwards
import fmgp.typings.nobleCurves.nobleCurvesStrings.ez
import fmgp.typings.nobleCurves.nobleCurvesStrings.pz
import fmgp.typings.nobleCurves.nobleCurvesStrings.weierstrass
import fmgp.typings.std.Partial
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

object curveMod {
  
  @JSImport("@noble/curves/abstract/curve", JSImport.Namespace)
  @js.native
  val ^ : js.Any = js.native
  
  inline def createCurveFields[T](`type`: weierstrass | edwards, CURVE: ValidCurveParams[T]): FpFn[T] = (^.asInstanceOf[js.Dynamic].applyDynamic("_createCurveFields")(`type`.asInstanceOf[js.Any], CURVE.asInstanceOf[js.Any])).asInstanceOf[FpFn[T]]
  inline def createCurveFields[T](`type`: weierstrass | edwards, CURVE: ValidCurveParams[T], curveOpts: Partial[FpFn[T]]): FpFn[T] = (^.asInstanceOf[js.Dynamic].applyDynamic("_createCurveFields")(`type`.asInstanceOf[js.Any], CURVE.asInstanceOf[js.Any], curveOpts.asInstanceOf[js.Any])).asInstanceOf[FpFn[T]]
  
  inline def mulEndoUnsafe[T /* <: Group[T] */](c: GroupConstructor[T], point: T, k1: js.BigInt, k2: js.BigInt): P1[T] = (^.asInstanceOf[js.Dynamic].applyDynamic("mulEndoUnsafe")(c.asInstanceOf[js.Any], point.asInstanceOf[js.Any], k1.asInstanceOf[js.Any], k2.asInstanceOf[js.Any])).asInstanceOf[P1[T]]
  
  inline def negateCt[T /* <: Group[T] */](condition: Boolean, item: T): T = (^.asInstanceOf[js.Dynamic].applyDynamic("negateCt")(condition.asInstanceOf[js.Any], item.asInstanceOf[js.Any])).asInstanceOf[T]
  
  inline def normalizeZ[T](c: ExtendedGroupConstructor[T], property: pz | ez, points: js.Array[T]): js.Array[T] = (^.asInstanceOf[js.Dynamic].applyDynamic("normalizeZ")(c.asInstanceOf[js.Any], property.asInstanceOf[js.Any], points.asInstanceOf[js.Any])).asInstanceOf[js.Array[T]]
  
  inline def pippenger[T /* <: Group[T] */](
    c: GroupConstructor[T],
    fieldN: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any,
    points: js.Array[T],
    scalars: js.Array[js.BigInt]
  ): T = (^.asInstanceOf[js.Dynamic].applyDynamic("pippenger")(c.asInstanceOf[js.Any], fieldN.asInstanceOf[js.Any], points.asInstanceOf[js.Any], scalars.asInstanceOf[js.Any])).asInstanceOf[T]
  
  inline def precomputeMSMUnsafe[T /* <: Group[T] */](
    c: GroupConstructor[T],
    fieldN: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any,
    points: js.Array[T],
    windowSize: Double
  ): js.Function1[/* scalars */ js.Array[js.BigInt], T] = (^.asInstanceOf[js.Dynamic].applyDynamic("precomputeMSMUnsafe")(c.asInstanceOf[js.Any], fieldN.asInstanceOf[js.Any], points.asInstanceOf[js.Any], windowSize.asInstanceOf[js.Any])).asInstanceOf[js.Function1[/* scalars */ js.Array[js.BigInt], T]]
  
  inline def validateBasic[FP, T](curve: BasicCurve[FP] & T): NBitLength & BasicCurve[FP] & T = ^.asInstanceOf[js.Dynamic].applyDynamic("validateBasic")(curve.asInstanceOf[js.Any]).asInstanceOf[NBitLength & BasicCurve[FP] & T]
  
  inline def wNAF[T /* <: Group[T] */](c: GroupConstructor[T], bits: Double): IWNAF[T] = (^.asInstanceOf[js.Dynamic].applyDynamic("wNAF")(c.asInstanceOf[js.Any], bits.asInstanceOf[js.Any])).asInstanceOf[IWNAF[T]]
  
  trait AffinePoint[T] extends StObject {
    
    var t: js.UndefOr[scala.Nothing] = js.undefined
    
    var x: T
    
    var y: T
    
    var z: js.UndefOr[scala.Nothing] = js.undefined
  }
  object AffinePoint {
    
    inline def apply[T](x: T, y: T): AffinePoint[T] = {
      val __obj = js.Dynamic.literal(x = x.asInstanceOf[js.Any], y = y.asInstanceOf[js.Any])
      __obj.asInstanceOf[AffinePoint[T]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: AffinePoint[?], T] (val x: Self & AffinePoint[T]) extends AnyVal {
      
      inline def setX(value: T): Self = StObject.set(x, "x", value.asInstanceOf[js.Any])
      
      inline def setY(value: T): Self = StObject.set(x, "y", value.asInstanceOf[js.Any])
    }
  }
  
  trait BasicCurve[T] extends StObject {
    
    var Fp: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any
    
    var Gx: T
    
    var Gy: T
    
    var allowInfinityPoint: js.UndefOr[Boolean] = js.undefined
    
    var h: js.BigInt
    
    var hEff: js.UndefOr[js.BigInt] = js.undefined
    
    var n: js.BigInt
    
    var nBitLength: js.UndefOr[Double] = js.undefined
    
    var nByteLength: js.UndefOr[Double] = js.undefined
  }
  object BasicCurve {
    
    inline def apply[T](
      Fp: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
      Gx: T,
      Gy: T,
      h: js.BigInt,
      n: js.BigInt
    ): BasicCurve[T] = {
      val __obj = js.Dynamic.literal(Fp = Fp.asInstanceOf[js.Any], Gx = Gx.asInstanceOf[js.Any], Gy = Gy.asInstanceOf[js.Any], h = h.asInstanceOf[js.Any], n = n.asInstanceOf[js.Any])
      __obj.asInstanceOf[BasicCurve[T]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: BasicCurve[?], T] (val x: Self & BasicCurve[T]) extends AnyVal {
      
      inline def setAllowInfinityPoint(value: Boolean): Self = StObject.set(x, "allowInfinityPoint", value.asInstanceOf[js.Any])
      
      inline def setAllowInfinityPointUndefined: Self = StObject.set(x, "allowInfinityPoint", js.undefined)
      
      inline def setFp(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any
      ): Self = StObject.set(x, "Fp", value.asInstanceOf[js.Any])
      
      inline def setGx(value: T): Self = StObject.set(x, "Gx", value.asInstanceOf[js.Any])
      
      inline def setGy(value: T): Self = StObject.set(x, "Gy", value.asInstanceOf[js.Any])
      
      inline def setH(value: js.BigInt): Self = StObject.set(x, "h", value.asInstanceOf[js.Any])
      
      inline def setHEff(value: js.BigInt): Self = StObject.set(x, "hEff", value.asInstanceOf[js.Any])
      
      inline def setHEffUndefined: Self = StObject.set(x, "hEff", js.undefined)
      
      inline def setN(value: js.BigInt): Self = StObject.set(x, "n", value.asInstanceOf[js.Any])
      
      inline def setNBitLength(value: Double): Self = StObject.set(x, "nBitLength", value.asInstanceOf[js.Any])
      
      inline def setNBitLengthUndefined: Self = StObject.set(x, "nBitLength", js.undefined)
      
      inline def setNByteLength(value: Double): Self = StObject.set(x, "nByteLength", value.asInstanceOf[js.Any])
      
      inline def setNByteLengthUndefined: Self = StObject.set(x, "nByteLength", js.undefined)
    }
  }
  
  trait ExtendedGroupConstructor[T]
    extends StObject
       with GroupConstructor[T] {
    
    var Fn: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
    
    var Fp: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<any> */ Any
    
    def fromAffine(ap: AffinePoint[Any]): T
  }
  object ExtendedGroupConstructor {
    
    inline def apply[T](
      BASE: T,
      Fn: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any,
      Fp: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<any> */ Any,
      ZERO: T,
      fromAffine: AffinePoint[Any] => T
    ): ExtendedGroupConstructor[T] = {
      val __obj = js.Dynamic.literal(BASE = BASE.asInstanceOf[js.Any], Fn = Fn.asInstanceOf[js.Any], Fp = Fp.asInstanceOf[js.Any], ZERO = ZERO.asInstanceOf[js.Any], fromAffine = js.Any.fromFunction1(fromAffine))
      __obj.asInstanceOf[ExtendedGroupConstructor[T]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: ExtendedGroupConstructor[?], T] (val x: Self & ExtendedGroupConstructor[T]) extends AnyVal {
      
      inline def setFn(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
      ): Self = StObject.set(x, "Fn", value.asInstanceOf[js.Any])
      
      inline def setFp(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<any> */ Any
      ): Self = StObject.set(x, "Fp", value.asInstanceOf[js.Any])
      
      inline def setFromAffine(value: AffinePoint[Any] => T): Self = StObject.set(x, "fromAffine", js.Any.fromFunction1(value))
    }
  }
  
  trait FpFn[T] extends StObject {
    
    var Fn: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
    
    var Fp: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any
  }
  object FpFn {
    
    inline def apply[T](
      Fn: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any,
      Fp: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any
    ): FpFn[T] = {
      val __obj = js.Dynamic.literal(Fn = Fn.asInstanceOf[js.Any], Fp = Fp.asInstanceOf[js.Any])
      __obj.asInstanceOf[FpFn[T]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: FpFn[?], T] (val x: Self & FpFn[T]) extends AnyVal {
      
      inline def setFn(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
      ): Self = StObject.set(x, "Fn", value.asInstanceOf[js.Any])
      
      inline def setFp(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any
      ): Self = StObject.set(x, "Fp", value.asInstanceOf[js.Any])
    }
  }
  
  trait Group[T /* <: Group[T] */] extends StObject {
    
    def add(other: T): T
    
    def double(): T
    
    def multiply(scalar: js.BigInt): T
    
    def negate(): T
    
    def subtract(other: T): T
    
    var toAffine: js.UndefOr[js.Function1[/* invertedZ */ js.UndefOr[Any], AffinePoint[Any]]] = js.undefined
  }
  object Group {
    
    inline def apply[T /* <: Group[T] */](add: T => T, double: () => T, multiply: js.BigInt => T, negate: () => T, subtract: T => T): Group[T] = {
      val __obj = js.Dynamic.literal(add = js.Any.fromFunction1(add), double = js.Any.fromFunction0(double), multiply = js.Any.fromFunction1(multiply), negate = js.Any.fromFunction0(negate), subtract = js.Any.fromFunction1(subtract))
      __obj.asInstanceOf[Group[T]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: Group[?], T /* <: Group[T] */] (val x: Self & Group[T]) extends AnyVal {
      
      inline def setAdd(value: T => T): Self = StObject.set(x, "add", js.Any.fromFunction1(value))
      
      inline def setDouble(value: () => T): Self = StObject.set(x, "double", js.Any.fromFunction0(value))
      
      inline def setMultiply(value: js.BigInt => T): Self = StObject.set(x, "multiply", js.Any.fromFunction1(value))
      
      inline def setNegate(value: () => T): Self = StObject.set(x, "negate", js.Any.fromFunction0(value))
      
      inline def setSubtract(value: T => T): Self = StObject.set(x, "subtract", js.Any.fromFunction1(value))
      
      inline def setToAffine(value: /* invertedZ */ js.UndefOr[Any] => AffinePoint[Any]): Self = StObject.set(x, "toAffine", js.Any.fromFunction1(value))
      
      inline def setToAffineUndefined: Self = StObject.set(x, "toAffine", js.undefined)
    }
  }
  
  trait GroupConstructor[T] extends StObject {
    
    var BASE: T
    
    var ZERO: T
  }
  object GroupConstructor {
    
    inline def apply[T](BASE: T, ZERO: T): GroupConstructor[T] = {
      val __obj = js.Dynamic.literal(BASE = BASE.asInstanceOf[js.Any], ZERO = ZERO.asInstanceOf[js.Any])
      __obj.asInstanceOf[GroupConstructor[T]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: GroupConstructor[?], T] (val x: Self & GroupConstructor[T]) extends AnyVal {
      
      inline def setBASE(value: T): Self = StObject.set(x, "BASE", value.asInstanceOf[js.Any])
      
      inline def setZERO(value: T): Self = StObject.set(x, "ZERO", value.asInstanceOf[js.Any])
    }
  }
  
  @js.native
  trait IWNAF[T /* <: Group[T] */] extends StObject {
    
    def constTimeNegate[T /* <: Group[T] */](condition: Boolean, item: T): T = js.native
    
    def getPrecomputes(W: Double, P: T): js.Array[T] = js.native
    def getPrecomputes(W: Double, P: T, transform: Mapper[T]): js.Array[T] = js.native
    
    def hasPrecomputes(elm: T): Boolean = js.native
    
    def precomputeWindow(elm: T, W: Double): js.Array[Group[T]] = js.native
    
    def setWindowSize(P: T, W: Double): Unit = js.native
    
    def unsafeLadder(elm: T, n: js.BigInt): T = js.native
    def unsafeLadder(elm: T, n: js.BigInt, p: T): T = js.native
    
    def wNAF(W: Double, precomputes: js.Array[T], n: js.BigInt): F[T] = js.native
    
    def wNAFCached(P: T, n: js.BigInt): F[T] = js.native
    def wNAFCached(P: T, n: js.BigInt, transform: Mapper[T]): F[T] = js.native
    
    def wNAFCachedUnsafe(P: T, n: js.BigInt): T = js.native
    def wNAFCachedUnsafe(P: T, n: js.BigInt, transform: Mapper[T]): T = js.native
    def wNAFCachedUnsafe(P: T, n: js.BigInt, transform: Mapper[T], prev: T): T = js.native
    def wNAFCachedUnsafe(P: T, n: js.BigInt, transform: Unit, prev: T): T = js.native
    
    def wNAFUnsafe(W: Double, precomputes: js.Array[T], n: js.BigInt): T = js.native
    def wNAFUnsafe(W: Double, precomputes: js.Array[T], n: js.BigInt, acc: T): T = js.native
  }
  
  type Mapper[T] = js.Function1[/* i */ js.Array[T], js.Array[T]]
  
  type ValidCurveParams[T] = (B[T] & A[T]) | (D[T] & A[T])
  
  trait WOpts extends StObject {
    
    var mask: js.BigInt
    
    var maxNumber: Double
    
    var shiftBy: js.BigInt
    
    var windowSize: Double
    
    var windows: Double
  }
  object WOpts {
    
    inline def apply(mask: js.BigInt, maxNumber: Double, shiftBy: js.BigInt, windowSize: Double, windows: Double): WOpts = {
      val __obj = js.Dynamic.literal(mask = mask.asInstanceOf[js.Any], maxNumber = maxNumber.asInstanceOf[js.Any], shiftBy = shiftBy.asInstanceOf[js.Any], windowSize = windowSize.asInstanceOf[js.Any], windows = windows.asInstanceOf[js.Any])
      __obj.asInstanceOf[WOpts]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: WOpts] (val x: Self) extends AnyVal {
      
      inline def setMask(value: js.BigInt): Self = StObject.set(x, "mask", value.asInstanceOf[js.Any])
      
      inline def setMaxNumber(value: Double): Self = StObject.set(x, "maxNumber", value.asInstanceOf[js.Any])
      
      inline def setShiftBy(value: js.BigInt): Self = StObject.set(x, "shiftBy", value.asInstanceOf[js.Any])
      
      inline def setWindowSize(value: Double): Self = StObject.set(x, "windowSize", value.asInstanceOf[js.Any])
      
      inline def setWindows(value: Double): Self = StObject.set(x, "windows", value.asInstanceOf[js.Any])
    }
  }
}
