package fmgp.typings.nobleCurves

import fmgp.typings.nobleCurves.anon.TypeofRistPointBASE
import org.scalablytyped.runtime.Instantiable1
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

object esmEd25519Mod {
  
  @JSImport("@noble/curves/esm/ed25519", JSImport.Namespace)
  @js.native
  val ^ : js.Any = js.native
  
  @JSImport("@noble/curves/esm/ed25519", "ED25519_TORSION_SUBGROUP")
  @js.native
  val ED25519_TORSION_SUBGROUP: js.Array[String] = js.native
  
  /* This class was inferred from a value with a constructor. In rare cases (like HTMLElement in the DOM) it might not work as you expect. */
  @JSImport("@noble/curves/esm/ed25519", "RistrettoPoint")
  @js.native
  open class RistrettoPoint protected ()
    extends StObject
       with RistPoint {
    def this(ep: ExtendedPoint) = this()
    
    /* CompleteClass */
    override def add(other: RistPoint): RistPoint = js.native
    
    /* CompleteClass */
    override def double(): RistPoint = js.native
    
    /* private */ /* CompleteClass */
    override val ep: Any = js.native
    
    /**
      * Compares two Ristretto points.
      * Described in [RFC9496](https://www.rfc-editor.org/rfc/rfc9496#name-equals).
      */
    /* CompleteClass */
    override def equals(other: RistPoint): Boolean = js.native
    
    /* CompleteClass */
    override def multiply(scalar: js.BigInt): RistPoint = js.native
    
    /* CompleteClass */
    override def multiplyUnsafe(scalar: js.BigInt): RistPoint = js.native
    
    /* CompleteClass */
    override def negate(): RistPoint = js.native
    
    /* CompleteClass */
    override def subtract(other: RistPoint): RistPoint = js.native
    
    /**
      * Encodes ristretto point to Uint8Array.
      * Described in [RFC9496](https://www.rfc-editor.org/rfc/rfc9496#name-encode).
      */
    /* CompleteClass */
    override def toBytes(): js.typedarray.Uint8Array = js.native
    
    /* CompleteClass */
    override def toHex(): String = js.native
    
    /** @deprecated use `toBytes` */
    /* CompleteClass */
    override def toRawBytes(): js.typedarray.Uint8Array = js.native
  }
  @JSImport("@noble/curves/esm/ed25519", "RistrettoPoint")
  @js.native
  val RistrettoPoint: TypeofRistPointBASE & (Instantiable1[/* ep */ ExtendedPoint, RistPoint]) = js.native
  
  @JSImport("@noble/curves/esm/ed25519", "ed25519")
  @js.native
  val ed25519: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurveFn */ Any = js.native
  
  @JSImport("@noble/curves/esm/ed25519", "ed25519_hasher")
  @js.native
  val ed25519Hasher: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2CHasher<bigint> */ Any = js.native
  
  @JSImport("@noble/curves/esm/ed25519", "ed25519ctx")
  @js.native
  val ed25519ctx: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurveFn */ Any = js.native
  
  @JSImport("@noble/curves/esm/ed25519", "ed25519ph")
  @js.native
  val ed25519ph: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurveFn */ Any = js.native
  
  @JSImport("@noble/curves/esm/ed25519", "edwardsToMontgomery")
  @js.native
  val edwardsToMontgomery: js.Function1[
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ /* edwardsPub */ Any, 
    js.typedarray.Uint8Array
  ] = js.native
  
  inline def edwardsToMontgomeryPriv(edwardsPriv: js.typedarray.Uint8Array): js.typedarray.Uint8Array = ^.asInstanceOf[js.Dynamic].applyDynamic("edwardsToMontgomeryPriv")(edwardsPriv.asInstanceOf[js.Any]).asInstanceOf[js.typedarray.Uint8Array]
  
  inline def edwardsToMontgomeryPub(
    edwardsPub: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
  ): js.typedarray.Uint8Array = ^.asInstanceOf[js.Dynamic].applyDynamic("edwardsToMontgomeryPub")(edwardsPub.asInstanceOf[js.Any]).asInstanceOf[js.typedarray.Uint8Array]
  
  @JSImport("@noble/curves/esm/ed25519", "encodeToCurve")
  @js.native
  val encodeToCurve: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2CMethod<bigint> */ Any = js.native
  
  @JSImport("@noble/curves/esm/ed25519", "hashToCurve")
  @js.native
  val hashToCurve: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2CMethod<bigint> */ Any = js.native
  
  inline def hashToRistretto255(
    msg: js.typedarray.Uint8Array,
    options: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
  ): RistPoint = (^.asInstanceOf[js.Dynamic].applyDynamic("hashToRistretto255")(msg.asInstanceOf[js.Any], options.asInstanceOf[js.Any])).asInstanceOf[RistPoint]
  
  inline def hash_ToRistretto255(
    msg: js.typedarray.Uint8Array,
    options: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
  ): RistPoint = (^.asInstanceOf[js.Dynamic].applyDynamic("hash_to_ristretto255")(msg.asInstanceOf[js.Any], options.asInstanceOf[js.Any])).asInstanceOf[RistPoint]
  
  @JSImport("@noble/curves/esm/ed25519", "x25519")
  @js.native
  val x25519: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify XCurveFn */ Any = js.native
  
  type ExtendedPoint = /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ExtPointType */ Any
  
  /**
    * Each ed25519/ExtendedPoint has 8 different equivalent points. This can be
    * a source of bugs for protocols like ring signatures. Ristretto was created to solve this.
    * Ristretto point operates in X:Y:Z:T extended coordinates like ExtendedPoint,
    * but it should work in its own namespace: do not combine those two.
    * See [RFC9496](https://www.rfc-editor.org/rfc/rfc9496).
    */
  /* import warning: RemoveDifficultInheritance.summarizeChanges 
  - Dropped / * import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Group<RistPoint> * / any */ trait RistPoint extends StObject {
    
    def add(other: RistPoint): RistPoint
    
    def double(): RistPoint
    
    /* private */ val ep: Any
    
    /**
      * Compares two Ristretto points.
      * Described in [RFC9496](https://www.rfc-editor.org/rfc/rfc9496#name-equals).
      */
    def equals(other: RistPoint): Boolean
    
    def multiply(scalar: js.BigInt): RistPoint
    
    def multiplyUnsafe(scalar: js.BigInt): RistPoint
    
    def negate(): RistPoint
    
    def subtract(other: RistPoint): RistPoint
    
    /**
      * Encodes ristretto point to Uint8Array.
      * Described in [RFC9496](https://www.rfc-editor.org/rfc/rfc9496#name-encode).
      */
    def toBytes(): js.typedarray.Uint8Array
    
    def toHex(): String
    
    /** @deprecated use `toBytes` */
    def toRawBytes(): js.typedarray.Uint8Array
  }
  object RistPoint {
    
    inline def apply(
      add: RistPoint => RistPoint,
      double: () => RistPoint,
      ep: Any,
      equals_ : RistPoint => Boolean,
      multiply: js.BigInt => RistPoint,
      multiplyUnsafe: js.BigInt => RistPoint,
      negate: () => RistPoint,
      subtract: RistPoint => RistPoint,
      toBytes: () => js.typedarray.Uint8Array,
      toHex: () => String,
      toRawBytes: () => js.typedarray.Uint8Array
    ): RistPoint = {
      val __obj = js.Dynamic.literal(add = js.Any.fromFunction1(add), double = js.Any.fromFunction0(double), ep = ep.asInstanceOf[js.Any], multiply = js.Any.fromFunction1(multiply), multiplyUnsafe = js.Any.fromFunction1(multiplyUnsafe), negate = js.Any.fromFunction0(negate), subtract = js.Any.fromFunction1(subtract), toBytes = js.Any.fromFunction0(toBytes), toHex = js.Any.fromFunction0(toHex), toRawBytes = js.Any.fromFunction0(toRawBytes))
      __obj.updateDynamic("equals")(js.Any.fromFunction1(equals_))
      __obj.asInstanceOf[RistPoint]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: RistPoint] (val x: Self) extends AnyVal {
      
      inline def setAdd(value: RistPoint => RistPoint): Self = StObject.set(x, "add", js.Any.fromFunction1(value))
      
      inline def setDouble(value: () => RistPoint): Self = StObject.set(x, "double", js.Any.fromFunction0(value))
      
      inline def setEp(value: Any): Self = StObject.set(x, "ep", value.asInstanceOf[js.Any])
      
      inline def setEquals_(value: RistPoint => Boolean): Self = StObject.set(x, "equals", js.Any.fromFunction1(value))
      
      inline def setMultiply(value: js.BigInt => RistPoint): Self = StObject.set(x, "multiply", js.Any.fromFunction1(value))
      
      inline def setMultiplyUnsafe(value: js.BigInt => RistPoint): Self = StObject.set(x, "multiplyUnsafe", js.Any.fromFunction1(value))
      
      inline def setNegate(value: () => RistPoint): Self = StObject.set(x, "negate", js.Any.fromFunction0(value))
      
      inline def setSubtract(value: RistPoint => RistPoint): Self = StObject.set(x, "subtract", js.Any.fromFunction1(value))
      
      inline def setToBytes(value: () => js.typedarray.Uint8Array): Self = StObject.set(x, "toBytes", js.Any.fromFunction0(value))
      
      inline def setToHex(value: () => String): Self = StObject.set(x, "toHex", js.Any.fromFunction0(value))
      
      inline def setToRawBytes(value: () => js.typedarray.Uint8Array): Self = StObject.set(x, "toRawBytes", js.Any.fromFunction0(value))
    }
  }
}
