package fmgp.typings.nobleCurves

import fmgp.typings.nobleCurves.anon.Context
import fmgp.typings.nobleCurves.anon.IsValid
import fmgp.typings.nobleCurves.anon.Precompute
import fmgp.typings.nobleCurves.anon.Zip215
import fmgp.typings.std.Partial
import org.scalablytyped.runtime.Instantiable4
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

object abstractEdwardsMod {
  
  @JSImport("@noble/curves/esm/abstract/edwards", JSImport.Namespace)
  @js.native
  val ^ : js.Any = js.native
  
  inline def eddsa(Point: ExtPointConstructor, eddsaOpts: EdDSAOpts): EdDSA_ = (^.asInstanceOf[js.Dynamic].applyDynamic("eddsa")(Point.asInstanceOf[js.Any], eddsaOpts.asInstanceOf[js.Any])).asInstanceOf[EdDSA_]
  
  inline def edwards(CURVE: EdwardsOpts): ExtPointConstructor = ^.asInstanceOf[js.Dynamic].applyDynamic("edwards")(CURVE.asInstanceOf[js.Any]).asInstanceOf[ExtPointConstructor]
  inline def edwards(CURVE: EdwardsOpts, curveOpts: EdwardsExtraOpts): ExtPointConstructor = (^.asInstanceOf[js.Dynamic].applyDynamic("edwards")(CURVE.asInstanceOf[js.Any], curveOpts.asInstanceOf[js.Any])).asInstanceOf[ExtPointConstructor]
  
  inline def twistedEdwards(c: CurveTypeWithLength): CurveFn = ^.asInstanceOf[js.Dynamic].applyDynamic("twistedEdwards")(c.asInstanceOf[js.Any]).asInstanceOf[CurveFn]
  
  @js.native
  trait CurveFn extends StObject {
    
    var CURVE: CurveType = js.native
    
    /** @deprecated use `Point` */
    var ExtendedPoint: ExtPointConstructor = js.native
    
    var Point: ExtPointConstructor = js.native
    
    def getPublicKey(
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): js.typedarray.Uint8Array = js.native
    
    def sign(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): js.typedarray.Uint8Array = js.native
    def sign(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      options: Context
    ): js.typedarray.Uint8Array = js.native
    
    var utils: Precompute = js.native
    
    def verify(
      sig: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): Boolean = js.native
    def verify(
      sig: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      options: Zip215
    ): Boolean = js.native
  }
  
  /* import warning: RemoveDifficultInheritance.summarizeChanges 
  - Dropped / * import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify BasicCurve<bigint> * / any */ trait CurveType extends StObject {
    
    var a: js.BigInt
    
    var adjustScalarBytes: js.UndefOr[js.Function1[/* bytes */ js.typedarray.Uint8Array, js.typedarray.Uint8Array]] = js.undefined
    
    var d: js.BigInt
    
    var domain: js.UndefOr[
        js.Function3[
          /* data */ js.typedarray.Uint8Array, 
          /* ctx */ js.typedarray.Uint8Array, 
          /* phflag */ Boolean, 
          js.typedarray.Uint8Array
        ]
      ] = js.undefined
    
    var hash: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
    
    var mapToCurve: js.UndefOr[
        js.Function1[
          /* scalar */ js.Array[js.BigInt], 
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any
        ]
      ] = js.undefined
    
    var prehash: js.UndefOr[
        /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
      ] = js.undefined
    
    var randomBytes: js.UndefOr[js.Function1[/* bytesLength */ js.UndefOr[Double], js.typedarray.Uint8Array]] = js.undefined
    
    var uvRatio: js.UndefOr[UVRatio] = js.undefined
  }
  object CurveType {
    
    inline def apply(
      a: js.BigInt,
      d: js.BigInt,
      hash: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
    ): CurveType = {
      val __obj = js.Dynamic.literal(a = a.asInstanceOf[js.Any], d = d.asInstanceOf[js.Any], hash = hash.asInstanceOf[js.Any])
      __obj.asInstanceOf[CurveType]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: CurveType] (val x: Self) extends AnyVal {
      
      inline def setA(value: js.BigInt): Self = StObject.set(x, "a", value.asInstanceOf[js.Any])
      
      inline def setAdjustScalarBytes(value: /* bytes */ js.typedarray.Uint8Array => js.typedarray.Uint8Array): Self = StObject.set(x, "adjustScalarBytes", js.Any.fromFunction1(value))
      
      inline def setAdjustScalarBytesUndefined: Self = StObject.set(x, "adjustScalarBytes", js.undefined)
      
      inline def setD(value: js.BigInt): Self = StObject.set(x, "d", value.asInstanceOf[js.Any])
      
      inline def setDomain(
        value: (/* data */ js.typedarray.Uint8Array, /* ctx */ js.typedarray.Uint8Array, /* phflag */ Boolean) => js.typedarray.Uint8Array
      ): Self = StObject.set(x, "domain", js.Any.fromFunction3(value))
      
      inline def setDomainUndefined: Self = StObject.set(x, "domain", js.undefined)
      
      inline def setHash(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
      ): Self = StObject.set(x, "hash", value.asInstanceOf[js.Any])
      
      inline def setMapToCurve(
        value: /* scalar */ js.Array[js.BigInt] => /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any
      ): Self = StObject.set(x, "mapToCurve", js.Any.fromFunction1(value))
      
      inline def setMapToCurveUndefined: Self = StObject.set(x, "mapToCurve", js.undefined)
      
      inline def setPrehash(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
      ): Self = StObject.set(x, "prehash", value.asInstanceOf[js.Any])
      
      inline def setPrehashUndefined: Self = StObject.set(x, "prehash", js.undefined)
      
      inline def setRandomBytes(value: /* bytesLength */ js.UndefOr[Double] => js.typedarray.Uint8Array): Self = StObject.set(x, "randomBytes", js.Any.fromFunction1(value))
      
      inline def setRandomBytesUndefined: Self = StObject.set(x, "randomBytes", js.undefined)
      
      inline def setUvRatio(value: (/* u */ js.BigInt, /* v */ js.BigInt) => IsValid): Self = StObject.set(x, "uvRatio", js.Any.fromFunction2(value))
      
      inline def setUvRatioUndefined: Self = StObject.set(x, "uvRatio", js.undefined)
    }
  }
  
  type CurveTypeWithLength = CurveType & (Partial[
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify NLength */ Any
  ])
  
  trait EdComposed extends StObject {
    
    var CURVE: EdwardsOpts
    
    var curveOpts: EdwardsExtraOpts
    
    var eddsaOpts: EdDSAOpts
  }
  object EdComposed {
    
    inline def apply(CURVE: EdwardsOpts, curveOpts: EdwardsExtraOpts, eddsaOpts: EdDSAOpts): EdComposed = {
      val __obj = js.Dynamic.literal(CURVE = CURVE.asInstanceOf[js.Any], curveOpts = curveOpts.asInstanceOf[js.Any], eddsaOpts = eddsaOpts.asInstanceOf[js.Any])
      __obj.asInstanceOf[EdComposed]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: EdComposed] (val x: Self) extends AnyVal {
      
      inline def setCURVE(value: EdwardsOpts): Self = StObject.set(x, "CURVE", value.asInstanceOf[js.Any])
      
      inline def setCurveOpts(value: EdwardsExtraOpts): Self = StObject.set(x, "curveOpts", value.asInstanceOf[js.Any])
      
      inline def setEddsaOpts(value: EdDSAOpts): Self = StObject.set(x, "eddsaOpts", value.asInstanceOf[js.Any])
    }
  }
  
  trait EdDSAOpts extends StObject {
    
    var adjustScalarBytes: js.UndefOr[js.Function1[/* bytes */ js.typedarray.Uint8Array, js.typedarray.Uint8Array]] = js.undefined
    
    var domain: js.UndefOr[
        js.Function3[
          /* data */ js.typedarray.Uint8Array, 
          /* ctx */ js.typedarray.Uint8Array, 
          /* phflag */ Boolean, 
          js.typedarray.Uint8Array
        ]
      ] = js.undefined
    
    var hash: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
    
    var mapToCurve: js.UndefOr[
        js.Function1[
          /* scalar */ js.Array[js.BigInt], 
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any
        ]
      ] = js.undefined
    
    var prehash: js.UndefOr[
        /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
      ] = js.undefined
    
    var randomBytes: js.UndefOr[js.Function1[/* bytesLength */ js.UndefOr[Double], js.typedarray.Uint8Array]] = js.undefined
  }
  object EdDSAOpts {
    
    inline def apply(
      hash: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
    ): EdDSAOpts = {
      val __obj = js.Dynamic.literal(hash = hash.asInstanceOf[js.Any])
      __obj.asInstanceOf[EdDSAOpts]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: EdDSAOpts] (val x: Self) extends AnyVal {
      
      inline def setAdjustScalarBytes(value: /* bytes */ js.typedarray.Uint8Array => js.typedarray.Uint8Array): Self = StObject.set(x, "adjustScalarBytes", js.Any.fromFunction1(value))
      
      inline def setAdjustScalarBytesUndefined: Self = StObject.set(x, "adjustScalarBytes", js.undefined)
      
      inline def setDomain(
        value: (/* data */ js.typedarray.Uint8Array, /* ctx */ js.typedarray.Uint8Array, /* phflag */ Boolean) => js.typedarray.Uint8Array
      ): Self = StObject.set(x, "domain", js.Any.fromFunction3(value))
      
      inline def setDomainUndefined: Self = StObject.set(x, "domain", js.undefined)
      
      inline def setHash(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
      ): Self = StObject.set(x, "hash", value.asInstanceOf[js.Any])
      
      inline def setMapToCurve(
        value: /* scalar */ js.Array[js.BigInt] => /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any
      ): Self = StObject.set(x, "mapToCurve", js.Any.fromFunction1(value))
      
      inline def setMapToCurveUndefined: Self = StObject.set(x, "mapToCurve", js.undefined)
      
      inline def setPrehash(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify FHash */ Any
      ): Self = StObject.set(x, "prehash", value.asInstanceOf[js.Any])
      
      inline def setPrehashUndefined: Self = StObject.set(x, "prehash", js.undefined)
      
      inline def setRandomBytes(value: /* bytesLength */ js.UndefOr[Double] => js.typedarray.Uint8Array): Self = StObject.set(x, "randomBytes", js.Any.fromFunction1(value))
      
      inline def setRandomBytesUndefined: Self = StObject.set(x, "randomBytes", js.undefined)
    }
  }
  
  @js.native
  trait EdDSA_ extends StObject {
    
    var Point: ExtPointConstructor = js.native
    
    def getPublicKey(
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): js.typedarray.Uint8Array = js.native
    
    def sign(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): js.typedarray.Uint8Array = js.native
    def sign(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      options: Context
    ): js.typedarray.Uint8Array = js.native
    
    var utils: Precompute = js.native
    
    def verify(
      sig: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): Boolean = js.native
    def verify(
      sig: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      options: Zip215
    ): Boolean = js.native
  }
  
  /* Inlined std.Partial<{  Fp :/ * import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> * / any,   Fn :/ * import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> * / any, uvRatio (u : bigint, v : bigint): {  isValid :boolean,   value :bigint}}> */
  trait EdwardsExtraOpts extends StObject {
    
    var Fn: js.UndefOr[
        /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
      ] = js.undefined
    
    var Fp: js.UndefOr[
        /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
      ] = js.undefined
    
    var uvRatio: js.UndefOr[js.Function2[/* u */ js.BigInt, /* v */ js.BigInt, IsValid]] = js.undefined
  }
  object EdwardsExtraOpts {
    
    inline def apply(): EdwardsExtraOpts = {
      val __obj = js.Dynamic.literal()
      __obj.asInstanceOf[EdwardsExtraOpts]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: EdwardsExtraOpts] (val x: Self) extends AnyVal {
      
      inline def setFn(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
      ): Self = StObject.set(x, "Fn", value.asInstanceOf[js.Any])
      
      inline def setFnUndefined: Self = StObject.set(x, "Fn", js.undefined)
      
      inline def setFp(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
      ): Self = StObject.set(x, "Fp", value.asInstanceOf[js.Any])
      
      inline def setFpUndefined: Self = StObject.set(x, "Fp", js.undefined)
      
      inline def setUvRatio(value: (/* u */ js.BigInt, /* v */ js.BigInt) => IsValid): Self = StObject.set(x, "uvRatio", js.Any.fromFunction2(value))
      
      inline def setUvRatioUndefined: Self = StObject.set(x, "uvRatio", js.undefined)
    }
  }
  
  /* Inlined std.Readonly<{  a :bigint,   d :bigint,   p :bigint,   n :bigint,   h :bigint,   Gx :bigint,   Gy :bigint}> */
  trait EdwardsOpts extends StObject {
    
    val Gx: js.BigInt
    
    val Gy: js.BigInt
    
    val a: js.BigInt
    
    val d: js.BigInt
    
    val h: js.BigInt
    
    val n: js.BigInt
    
    val p: js.BigInt
  }
  object EdwardsOpts {
    
    inline def apply(Gx: js.BigInt, Gy: js.BigInt, a: js.BigInt, d: js.BigInt, h: js.BigInt, n: js.BigInt, p: js.BigInt): EdwardsOpts = {
      val __obj = js.Dynamic.literal(Gx = Gx.asInstanceOf[js.Any], Gy = Gy.asInstanceOf[js.Any], a = a.asInstanceOf[js.Any], d = d.asInstanceOf[js.Any], h = h.asInstanceOf[js.Any], n = n.asInstanceOf[js.Any], p = p.asInstanceOf[js.Any])
      __obj.asInstanceOf[EdwardsOpts]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: EdwardsOpts] (val x: Self) extends AnyVal {
      
      inline def setA(value: js.BigInt): Self = StObject.set(x, "a", value.asInstanceOf[js.Any])
      
      inline def setD(value: js.BigInt): Self = StObject.set(x, "d", value.asInstanceOf[js.Any])
      
      inline def setGx(value: js.BigInt): Self = StObject.set(x, "Gx", value.asInstanceOf[js.Any])
      
      inline def setGy(value: js.BigInt): Self = StObject.set(x, "Gy", value.asInstanceOf[js.Any])
      
      inline def setH(value: js.BigInt): Self = StObject.set(x, "h", value.asInstanceOf[js.Any])
      
      inline def setN(value: js.BigInt): Self = StObject.set(x, "n", value.asInstanceOf[js.Any])
      
      inline def setP(value: js.BigInt): Self = StObject.set(x, "p", value.asInstanceOf[js.Any])
    }
  }
  
  /* import warning: RemoveDifficultInheritance.summarizeChanges 
  - Dropped / * import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify GroupConstructor<ExtPointType> * / any */ @js.native
  trait ExtPointConstructor
    extends StObject
       with Instantiable4[/* x */ js.BigInt, /* y */ js.BigInt, /* z */ js.BigInt, /* t */ js.BigInt, ExtPointType] {
    
    var Fn: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any = js.native
    
    var Fp: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any = js.native
    
    def fromAffine(
      p: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any
    ): ExtPointType = js.native
    
    def fromBytes(bytes: js.typedarray.Uint8Array): ExtPointType = js.native
    def fromBytes(bytes: js.typedarray.Uint8Array, zip215: Boolean): ExtPointType = js.native
    
    def fromHex(
      hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): ExtPointType = js.native
    def fromHex(
      hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      zip215: Boolean
    ): ExtPointType = js.native
    
    def msm(points: js.Array[ExtPointType], scalars: js.Array[js.BigInt]): ExtPointType = js.native
  }
  
  /* import warning: RemoveDifficultInheritance.summarizeChanges 
  - Dropped / * import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Group<ExtPointType> * / any */ @js.native
  trait ExtPointType extends StObject {
    
    /** @deprecated use `p.precompute(windowSize)` */
    def _setWindowSize(windowSize: Double): Unit = js.native
    
    def assertValidity(): Unit = js.native
    
    def clearCofactor(): ExtPointType = js.native
    
    val et: js.BigInt = js.native
    
    val ex: js.BigInt = js.native
    
    val ey: js.BigInt = js.native
    
    val ez: js.BigInt = js.native
    
    def is0(): Boolean = js.native
    
    def isSmallOrder(): Boolean = js.native
    
    def isTorsionFree(): Boolean = js.native
    
    def multiply(scalar: js.BigInt): ExtPointType = js.native
    
    def multiplyUnsafe(scalar: js.BigInt): ExtPointType = js.native
    
    def precompute(): ExtPointType = js.native
    def precompute(windowSize: Double): ExtPointType = js.native
    def precompute(windowSize: Double, isLazy: Boolean): ExtPointType = js.native
    def precompute(windowSize: Unit, isLazy: Boolean): ExtPointType = js.native
    
    def toAffine(): Any = js.native
    def toAffine(iz: js.BigInt): Any = js.native
    
    def toBytes(): js.typedarray.Uint8Array = js.native
    
    def toHex(): String = js.native
    
    /** @deprecated use `toBytes` */
    def toRawBytes(): js.typedarray.Uint8Array = js.native
    
    def x: js.BigInt = js.native
    
    def y: js.BigInt = js.native
  }
  
  type UVRatio = js.Function2[/* u */ js.BigInt, /* v */ js.BigInt, IsValid]
}
