package fmgp.typings.nobleCurves

import fmgp.typings.nobleCurves.anon.BasisEval
import fmgp.typings.nobleCurves.anon.`0`
import org.scalablytyped.runtime.NumberDictionary
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

object abstractFftMod {
  
  @JSImport("@noble/curves/esm/abstract/fft", JSImport.Namespace)
  @js.native
  val ^ : js.Any = js.native
  
  inline def FFT[T](roots: RootsOfUnity_, opts: FFTOpts[T, js.BigInt]): FFTMethods[T] = (^.asInstanceOf[js.Dynamic].applyDynamic("FFT")(roots.asInstanceOf[js.Any], opts.asInstanceOf[js.Any])).asInstanceOf[FFTMethods[T]]
  
  inline def FFTCore[T, R](F: FFTOpts[T, R], coreOpts: FFTCoreOpts[R]): FFTCoreLoop[T] = (^.asInstanceOf[js.Dynamic].applyDynamic("FFTCore")(F.asInstanceOf[js.Any], coreOpts.asInstanceOf[js.Any])).asInstanceOf[FFTCoreLoop[T]]
  
  inline def bitReversalInplace[T /* <: MutableArrayLike[Any] */](values: T): T = ^.asInstanceOf[js.Dynamic].applyDynamic("bitReversalInplace")(values.asInstanceOf[js.Any]).asInstanceOf[T]
  
  inline def bitReversalPermutation[T](values: js.Array[T]): js.Array[T] = ^.asInstanceOf[js.Dynamic].applyDynamic("bitReversalPermutation")(values.asInstanceOf[js.Any]).asInstanceOf[js.Array[T]]
  
  inline def isPowerOfTwo(x: Double): Boolean = ^.asInstanceOf[js.Dynamic].applyDynamic("isPowerOfTwo")(x.asInstanceOf[js.Any]).asInstanceOf[Boolean]
  
  inline def log2(n: Double): Double = ^.asInstanceOf[js.Dynamic].applyDynamic("log2")(n.asInstanceOf[js.Any]).asInstanceOf[Double]
  
  inline def nextPowerOfTwo(n: Double): Double = ^.asInstanceOf[js.Dynamic].applyDynamic("nextPowerOfTwo")(n.asInstanceOf[js.Any]).asInstanceOf[Double]
  
  inline def poly[T](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_
  ): PolyFn[js.Array[T], T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any])).asInstanceOf[PolyFn[js.Array[T], T]]
  inline def poly[T](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_,
    create: Unit,
    fft: FFTMethods[T]
  ): PolyFn[js.Array[T], T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any], create.asInstanceOf[js.Any], fft.asInstanceOf[js.Any])).asInstanceOf[PolyFn[js.Array[T], T]]
  inline def poly[T](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_,
    create: Unit,
    fft: FFTMethods[T],
    length: Double
  ): PolyFn[js.Array[T], T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any], create.asInstanceOf[js.Any], fft.asInstanceOf[js.Any], length.asInstanceOf[js.Any])).asInstanceOf[PolyFn[js.Array[T], T]]
  inline def poly[T](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_,
    create: Unit,
    fft: Unit,
    length: Double
  ): PolyFn[js.Array[T], T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any], create.asInstanceOf[js.Any], fft.asInstanceOf[js.Any], length.asInstanceOf[js.Any])).asInstanceOf[PolyFn[js.Array[T], T]]
  inline def poly[T, P /* <: Polynomial[T] */](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_,
    create: CreatePolyFn[P, T]
  ): PolyFn[P, T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any], create.asInstanceOf[js.Any])).asInstanceOf[PolyFn[P, T]]
  inline def poly[T, P /* <: Polynomial[T] */](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_,
    create: CreatePolyFn[P, T],
    fft: FFTMethods[T]
  ): PolyFn[P, T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any], create.asInstanceOf[js.Any], fft.asInstanceOf[js.Any])).asInstanceOf[PolyFn[P, T]]
  inline def poly[T, P /* <: Polynomial[T] */](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_,
    create: CreatePolyFn[P, T],
    fft: FFTMethods[T],
    length: Double
  ): PolyFn[P, T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any], create.asInstanceOf[js.Any], fft.asInstanceOf[js.Any], length.asInstanceOf[js.Any])).asInstanceOf[PolyFn[P, T]]
  inline def poly[T, P /* <: Polynomial[T] */](
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<T> */ Any,
    roots: RootsOfUnity_,
    create: CreatePolyFn[P, T],
    fft: Unit,
    length: Double
  ): PolyFn[P, T] = (^.asInstanceOf[js.Dynamic].applyDynamic("poly")(field.asInstanceOf[js.Any], roots.asInstanceOf[js.Any], create.asInstanceOf[js.Any], fft.asInstanceOf[js.Any], length.asInstanceOf[js.Any])).asInstanceOf[PolyFn[P, T]]
  
  inline def reverseBits(n: Double, bits: Double): Double = (^.asInstanceOf[js.Dynamic].applyDynamic("reverseBits")(n.asInstanceOf[js.Any], bits.asInstanceOf[js.Any])).asInstanceOf[Double]
  
  inline def rootsOfUnity(
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any
  ): RootsOfUnity_ = ^.asInstanceOf[js.Dynamic].applyDynamic("rootsOfUnity")(field.asInstanceOf[js.Any]).asInstanceOf[RootsOfUnity_]
  inline def rootsOfUnity(
    field: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify IField<bigint> */ Any,
    generator: js.BigInt
  ): RootsOfUnity_ = (^.asInstanceOf[js.Dynamic].applyDynamic("rootsOfUnity")(field.asInstanceOf[js.Any], generator.asInstanceOf[js.Any])).asInstanceOf[RootsOfUnity_]
  
  type CreatePolyFn[P /* <: Polynomial[T] */, T] = js.Function2[/* len */ Double, /* elm */ js.UndefOr[T], P]
  
  type FFTCoreLoop[T] = js.Function1[/* values */ Polynomial[T], Polynomial[T]]
  
  trait FFTCoreOpts[R] extends StObject {
    
    var N: Double
    
    var brp: js.UndefOr[Boolean] = js.undefined
    
    var dit: Boolean
    
    var invertButterflies: js.UndefOr[Boolean] = js.undefined
    
    var roots: Polynomial[R]
    
    var skipStages: js.UndefOr[Double] = js.undefined
  }
  object FFTCoreOpts {
    
    inline def apply[R](N: Double, dit: Boolean, roots: Polynomial[R]): FFTCoreOpts[R] = {
      val __obj = js.Dynamic.literal(N = N.asInstanceOf[js.Any], dit = dit.asInstanceOf[js.Any], roots = roots.asInstanceOf[js.Any])
      __obj.asInstanceOf[FFTCoreOpts[R]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: FFTCoreOpts[?], R] (val x: Self & FFTCoreOpts[R]) extends AnyVal {
      
      inline def setBrp(value: Boolean): Self = StObject.set(x, "brp", value.asInstanceOf[js.Any])
      
      inline def setBrpUndefined: Self = StObject.set(x, "brp", js.undefined)
      
      inline def setDit(value: Boolean): Self = StObject.set(x, "dit", value.asInstanceOf[js.Any])
      
      inline def setInvertButterflies(value: Boolean): Self = StObject.set(x, "invertButterflies", value.asInstanceOf[js.Any])
      
      inline def setInvertButterfliesUndefined: Self = StObject.set(x, "invertButterflies", js.undefined)
      
      inline def setN(value: Double): Self = StObject.set(x, "N", value.asInstanceOf[js.Any])
      
      inline def setRoots(value: Polynomial[R]): Self = StObject.set(x, "roots", value.asInstanceOf[js.Any])
      
      inline def setSkipStages(value: Double): Self = StObject.set(x, "skipStages", value.asInstanceOf[js.Any])
      
      inline def setSkipStagesUndefined: Self = StObject.set(x, "skipStages", js.undefined)
    }
  }
  
  @js.native
  trait FFTMethods[T] extends StObject {
    
    def direct[P /* <: Polynomial[T] */](values: P): P = js.native
    def direct[P /* <: Polynomial[T] */](values: P, brpInput: Boolean): P = js.native
    def direct[P /* <: Polynomial[T] */](values: P, brpInput: Boolean, brpOutput: Boolean): P = js.native
    def direct[P /* <: Polynomial[T] */](values: P, brpInput: Unit, brpOutput: Boolean): P = js.native
    
    def inverse[P /* <: Polynomial[T] */](values: P): P = js.native
    def inverse[P /* <: Polynomial[T] */](values: P, brpInput: Boolean): P = js.native
    def inverse[P /* <: Polynomial[T] */](values: P, brpInput: Boolean, brpOutput: Boolean): P = js.native
    def inverse[P /* <: Polynomial[T] */](values: P, brpInput: Unit, brpOutput: Boolean): P = js.native
  }
  
  trait FFTOpts[T, R] extends StObject {
    
    def add(a: T, b: T): T
    
    def inv(a: R): R
    
    def mul(a: T, scalar: R): T
    
    def sub(a: T, b: T): T
  }
  object FFTOpts {
    
    inline def apply[T, R](add: (T, T) => T, inv: R => R, mul: (T, R) => T, sub: (T, T) => T): FFTOpts[T, R] = {
      val __obj = js.Dynamic.literal(add = js.Any.fromFunction2(add), inv = js.Any.fromFunction1(inv), mul = js.Any.fromFunction2(mul), sub = js.Any.fromFunction2(sub))
      __obj.asInstanceOf[FFTOpts[T, R]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: FFTOpts[?, ?], T, R] (val x: Self & (FFTOpts[T, R])) extends AnyVal {
      
      inline def setAdd(value: (T, T) => T): Self = StObject.set(x, "add", js.Any.fromFunction2(value))
      
      inline def setInv(value: R => R): Self = StObject.set(x, "inv", js.Any.fromFunction1(value))
      
      inline def setMul(value: (T, R) => T): Self = StObject.set(x, "mul", js.Any.fromFunction2(value))
      
      inline def setSub(value: (T, T) => T): Self = StObject.set(x, "sub", js.Any.fromFunction2(value))
    }
  }
  
  @js.native
  trait MutableArrayLike[T]
    extends StObject
       with /* index */ NumberDictionary[T] {
    
    @JSName(js.Symbol.iterator)
    var iterator: js.Function0[js.Iterator[T]] = js.native
    
    var length: Double = js.native
    
    def slice(): this.type = js.native
    def slice(start: Double): this.type = js.native
    def slice(start: Double, end: Double): this.type = js.native
    def slice(start: Unit, end: Double): this.type = js.native
  }
  
  @js.native
  trait PolyFn[P /* <: Polynomial[T] */, T] extends StObject {
    
    def add(a: P, b: P): P = js.native
    
    def clone(a: P): P = js.native
    
    def convolve(a: P, b: P): P = js.native
    
    def create(len: Double): P = js.native
    def create(len: Double, elm: T): P = js.native
    @JSName("create")
    var create_Original: CreatePolyFn[P, T] = js.native
    
    def degree(a: P): Double = js.native
    
    def dot(a: P, b: P): P = js.native
    
    def eval(a: P, basis: P): T = js.native
    
    def extend(a: P, len: Double): P = js.native
    
    var lagrange: `0`[T, P] = js.native
    
    var length: js.UndefOr[Double] = js.native
    
    var monomial: BasisEval[T, P] = js.native
    
    def mul(a: P, b: P | T): P = js.native
    
    var roots: RootsOfUnity_ = js.native
    
    def shift(p: P, factor: js.BigInt): P = js.native
    
    def sub(a: P, b: P): P = js.native
    
    def vanishing(roots: P): P = js.native
  }
  
  type Polynomial[T] = MutableArrayLike[T]
  
  trait RootsOfUnity_ extends StObject {
    
    def brp(bits: Double): js.Array[js.BigInt]
    
    def clear(): Unit
    
    def inverse(bits: Double): js.Array[js.BigInt]
    
    def omega(bits: Double): js.BigInt
    
    def roots(bits: Double): js.Array[js.BigInt]
  }
  object RootsOfUnity_ {
    
    inline def apply(
      brp: Double => js.Array[js.BigInt],
      clear: () => Unit,
      inverse: Double => js.Array[js.BigInt],
      omega: Double => js.BigInt,
      roots: Double => js.Array[js.BigInt]
    ): RootsOfUnity_ = {
      val __obj = js.Dynamic.literal(brp = js.Any.fromFunction1(brp), clear = js.Any.fromFunction0(clear), inverse = js.Any.fromFunction1(inverse), omega = js.Any.fromFunction1(omega), roots = js.Any.fromFunction1(roots))
      __obj.asInstanceOf[RootsOfUnity_]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: RootsOfUnity_] (val x: Self) extends AnyVal {
      
      inline def setBrp(value: Double => js.Array[js.BigInt]): Self = StObject.set(x, "brp", js.Any.fromFunction1(value))
      
      inline def setClear(value: () => Unit): Self = StObject.set(x, "clear", js.Any.fromFunction0(value))
      
      inline def setInverse(value: Double => js.Array[js.BigInt]): Self = StObject.set(x, "inverse", js.Any.fromFunction1(value))
      
      inline def setOmega(value: Double => js.BigInt): Self = StObject.set(x, "omega", js.Any.fromFunction1(value))
      
      inline def setRoots(value: Double => js.Array[js.BigInt]): Self = StObject.set(x, "roots", js.Any.fromFunction1(value))
    }
  }
}
