package fmgp.typings.nobleCurves.anon

import fmgp.typings.nobleCurves.ed448Mod.DcfPoint
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

trait TypeofDcfPoint extends StObject {
  
  /* static member */
  var BASE: DcfPoint
  
  /* static member */
  var ZERO: DcfPoint
  
  /* static member */
  def fromAffine(
    ap: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any
  ): DcfPoint
  
  /* static member */
  def fromBytes(bytes: js.typedarray.Uint8Array): DcfPoint
  
  /**
    * Converts decaf-encoded string to decaf point.
    * Described in [RFC9496](https://www.rfc-editor.org/rfc/rfc9496#name-decode-2).
    * @param hex Decaf-encoded 56 bytes. Not every 56-byte string is valid decaf encoding
    */
  /* static member */
  def fromHex(
    hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
  ): DcfPoint
  
  /**
    * Takes uniform output of 112-byte hash function like shake256 and converts it to `DecafPoint`.
    * The hash-to-group operation applies Elligator twice and adds the results.
    * **Note:** this is one-way map, there is no conversion from point to hash.
    * Described in [RFC9380](https://www.rfc-editor.org/rfc/rfc9380#appendix-C)
    * and [RFC9496](https://www.rfc-editor.org/rfc/rfc9496#name-element-derivation-2).
    * @param hex 112-byte output of a hash function
    */
  /* static member */
  def hashToCurve(
    hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
  ): DcfPoint
  
  /* static member */
  def msm(points: js.Array[DcfPoint], scalars: js.Array[js.BigInt]): DcfPoint
}
object TypeofDcfPoint {
  
  inline def apply(
    BASE: DcfPoint,
    ZERO: DcfPoint,
    fromAffine: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any => DcfPoint,
    fromBytes: js.typedarray.Uint8Array => DcfPoint,
    fromHex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => DcfPoint,
    hashToCurve: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => DcfPoint,
    msm: (js.Array[DcfPoint], js.Array[js.BigInt]) => DcfPoint
  ): TypeofDcfPoint = {
    val __obj = js.Dynamic.literal(BASE = BASE.asInstanceOf[js.Any], ZERO = ZERO.asInstanceOf[js.Any], fromAffine = js.Any.fromFunction1(fromAffine), fromBytes = js.Any.fromFunction1(fromBytes), fromHex = js.Any.fromFunction1(fromHex), hashToCurve = js.Any.fromFunction1(hashToCurve), msm = js.Any.fromFunction2(msm))
    __obj.asInstanceOf[TypeofDcfPoint]
  }
  
  @scala.inline
  implicit open class MutableBuilder[Self <: TypeofDcfPoint] (val x: Self) extends AnyVal {
    
    inline def setBASE(value: DcfPoint): Self = StObject.set(x, "BASE", value.asInstanceOf[js.Any])
    
    inline def setFromAffine(
      value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any => DcfPoint
    ): Self = StObject.set(x, "fromAffine", js.Any.fromFunction1(value))
    
    inline def setFromBytes(value: js.typedarray.Uint8Array => DcfPoint): Self = StObject.set(x, "fromBytes", js.Any.fromFunction1(value))
    
    inline def setFromHex(
      value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => DcfPoint
    ): Self = StObject.set(x, "fromHex", js.Any.fromFunction1(value))
    
    inline def setHashToCurve(
      value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => DcfPoint
    ): Self = StObject.set(x, "hashToCurve", js.Any.fromFunction1(value))
    
    inline def setMsm(value: (js.Array[DcfPoint], js.Array[js.BigInt]) => DcfPoint): Self = StObject.set(x, "msm", js.Any.fromFunction2(value))
    
    inline def setZERO(value: DcfPoint): Self = StObject.set(x, "ZERO", value.asInstanceOf[js.Any])
  }
}
