package fmgp.typings.nobleCurves.anon

import fmgp.typings.nobleCurves.ed25519Mod.RistPoint
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

trait TypeofRistPoint extends StObject {
  
  /* static member */
  var BASE: RistPoint
  
  /* static member */
  var ZERO: RistPoint
  
  /* static member */
  def fromAffine(
    ap: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any
  ): RistPoint
  
  /* static member */
  def fromBytes(bytes: js.typedarray.Uint8Array): RistPoint
  
  /**
    * Converts ristretto-encoded string to ristretto point.
    * Described in [RFC9496](https://www.rfc-editor.org/rfc/rfc9496#name-decode).
    * @param hex Ristretto-encoded 32 bytes. Not every 32-byte string is valid ristretto encoding
    */
  /* static member */
  def fromHex(
    hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
  ): RistPoint
  
  /**
    * Takes uniform output of 64-byte hash function like sha512 and converts it to `RistrettoPoint`.
    * The hash-to-group operation applies Elligator twice and adds the results.
    * **Note:** this is one-way map, there is no conversion from point to hash.
    * Described in [RFC9380](https://www.rfc-editor.org/rfc/rfc9380#appendix-B) and on
    * the [website](https://ristretto.group/formulas/elligator.html).
    * @param hex 64-byte output of a hash function
    */
  /* static member */
  def hashToCurve(
    hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
  ): RistPoint
  
  /* static member */
  def msm(points: js.Array[RistPoint], scalars: js.Array[js.BigInt]): RistPoint
}
object TypeofRistPoint {
  
  inline def apply(
    BASE: RistPoint,
    ZERO: RistPoint,
    fromAffine: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any => RistPoint,
    fromBytes: js.typedarray.Uint8Array => RistPoint,
    fromHex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => RistPoint,
    hashToCurve: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => RistPoint,
    msm: (js.Array[RistPoint], js.Array[js.BigInt]) => RistPoint
  ): TypeofRistPoint = {
    val __obj = js.Dynamic.literal(BASE = BASE.asInstanceOf[js.Any], ZERO = ZERO.asInstanceOf[js.Any], fromAffine = js.Any.fromFunction1(fromAffine), fromBytes = js.Any.fromFunction1(fromBytes), fromHex = js.Any.fromFunction1(fromHex), hashToCurve = js.Any.fromFunction1(hashToCurve), msm = js.Any.fromFunction2(msm))
    __obj.asInstanceOf[TypeofRistPoint]
  }
  
  @scala.inline
  implicit open class MutableBuilder[Self <: TypeofRistPoint] (val x: Self) extends AnyVal {
    
    inline def setBASE(value: RistPoint): Self = StObject.set(x, "BASE", value.asInstanceOf[js.Any])
    
    inline def setFromAffine(
      value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify AffinePoint<bigint> */ Any => RistPoint
    ): Self = StObject.set(x, "fromAffine", js.Any.fromFunction1(value))
    
    inline def setFromBytes(value: js.typedarray.Uint8Array => RistPoint): Self = StObject.set(x, "fromBytes", js.Any.fromFunction1(value))
    
    inline def setFromHex(
      value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => RistPoint
    ): Self = StObject.set(x, "fromHex", js.Any.fromFunction1(value))
    
    inline def setHashToCurve(
      value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => RistPoint
    ): Self = StObject.set(x, "hashToCurve", js.Any.fromFunction1(value))
    
    inline def setMsm(value: (js.Array[RistPoint], js.Array[js.BigInt]) => RistPoint): Self = StObject.set(x, "msm", js.Any.fromFunction2(value))
    
    inline def setZERO(value: RistPoint): Self = StObject.set(x, "ZERO", value.asInstanceOf[js.Any])
  }
}
