package fmgp.typings.nobleCurves

import fmgp.typings.nobleCurves.anon.CalcPairingPrecomputesRandomPrivateKey
import fmgp.typings.nobleCurves.anon.Fp12
import fmgp.typings.nobleCurves.anon.G1
import fmgp.typings.nobleCurves.anon.G2
import fmgp.typings.nobleCurves.anon.G2b
import fmgp.typings.nobleCurves.anon.Rx
import fmgp.typings.nobleCurves.anon.ShortSignature
import fmgp.typings.nobleCurves.anon.Signature
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

object blsMod {
  
  @JSImport("@noble/curves/esm/abstract/bls", JSImport.Namespace)
  @js.native
  val ^ : js.Any = js.native
  
  inline def bls(CURVE: CurveType): CurveFn = ^.asInstanceOf[js.Dynamic].applyDynamic("bls")(CURVE.asInstanceOf[js.Any]).asInstanceOf[CurveFn]
  
  type BLSInput = (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any) | js.typedarray.Uint8Array
  
  @js.native
  trait BLSSigs[P, S] extends StObject {
    
    var Signature: SignatureCoder[S] = js.native
    
    def aggregatePublicKeys(
      publicKeys: js.Array[
          (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<P> */ Any) | BLSInput
        ]
    ): Any = js.native
    
    def aggregateSignatures(
      signatures: js.Array[
          (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<S> */ Any) | BLSInput
        ]
    ): Any = js.native
    
    def getPublicKey(
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): Any = js.native
    
    def hash(message: js.typedarray.Uint8Array): Any = js.native
    def hash(message: js.typedarray.Uint8Array, DST: String): Any = js.native
    def hash(
      message: js.typedarray.Uint8Array,
      DST: String,
      hashOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2CHashOpts */ Any
    ): Any = js.native
    def hash(message: js.typedarray.Uint8Array, DST: js.typedarray.Uint8Array): Any = js.native
    def hash(
      message: js.typedarray.Uint8Array,
      DST: js.typedarray.Uint8Array,
      hashOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2CHashOpts */ Any
    ): Any = js.native
    def hash(
      message: js.typedarray.Uint8Array,
      DST: Unit,
      hashOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2CHashOpts */ Any
    ): Any = js.native
    
    def sign(
      hashedMessage: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<S> */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): Any = js.native
    
    def verify(
      signature: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<S> */ Any) | BLSInput,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<S> */ Any,
      publicKey: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<P> */ Any) | BLSInput
    ): Boolean = js.native
  }
  
  @js.native
  trait CurveFn extends StObject {
    
    /** @deprecated use `curves.G1` and `curves.G2` */
    var G1: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsRes<Fp> */ Any = js.native
    
    var G2: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsRes<Fp2> */ Any = js.native
    
    /** @deprecated use `shortSignatures.Signature` */
    var ShortSignature: ShortSignatureCoder[Fp] = js.native
    
    /** @deprecated use `longSignatures.Signature` */
    var Signature: SignatureCoder[
        /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ Any
      ] = js.native
    
    /** @deprecated use `longSignatures.aggregatePublicKeys` */
    def aggregatePublicKeys(
      publicKeys: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
        ]
    ): js.typedarray.Uint8Array = js.native
    /** @deprecated use `longSignatures.aggregatePublicKeys` */
    @JSName("aggregatePublicKeys")
    def aggregatePublicKeys_Any(
      publicKeys: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
        ]
    ): Any = js.native
    
    /** @deprecated use `shortSignatures.aggregateSignatures` */
    def aggregateShortSignatures(
      signatures: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
        ]
    ): js.typedarray.Uint8Array = js.native
    /** @deprecated use `shortSignatures.aggregateSignatures` */
    @JSName("aggregateShortSignatures")
    def aggregateShortSignatures_Any(
      signatures: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
        ]
    ): Any = js.native
    
    /** @deprecated use `longSignatures.aggregateSignatures` */
    def aggregateSignatures(
      signatures: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
        ]
    ): js.typedarray.Uint8Array = js.native
    /** @deprecated use `longSignatures.aggregateSignatures` */
    @JSName("aggregateSignatures")
    def aggregateSignatures_Any(
      signatures: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp2> */ Any
        ]
    ): Any = js.native
    
    var curves: G2 = js.native
    
    var fields: Fp12 = js.native
    
    /** @deprecated use `longSignatures.getPublicKey` */
    def getPublicKey(
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): js.typedarray.Uint8Array = js.native
    
    /** @deprecated use `shortSignatures.getPublicKey` */
    def getPublicKeyForShortSignatures(
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): js.typedarray.Uint8Array = js.native
    
    var longSignatures: BLSSigs[
        js.BigInt, 
        /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ Any
      ] = js.native
    
    def millerLoopBatch(pairs: js.Array[js.Tuple3[Precompute, Fp, Fp]]): Any = js.native
    
    def pairing(
      P: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any,
      Q: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp2> */ Any
    ): Any = js.native
    def pairing(
      P: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any,
      Q: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp2> */ Any,
      withFinalExponent: Boolean
    ): Any = js.native
    
    def pairingBatch(pairs: js.Array[G1]): Any = js.native
    def pairingBatch(pairs: js.Array[G1], withFinalExponent: Boolean): Any = js.native
    
    var params: G2b = js.native
    
    var shortSignatures: BLSSigs[
        /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ Any, 
        js.BigInt
      ] = js.native
    
    /** @deprecated use `longSignatures.sign` */
    def sign(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): js.typedarray.Uint8Array = js.native
    def sign(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any,
      htfOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
    ): js.typedarray.Uint8Array = js.native
    
    /** @deprecated use `shortSignatures.sign` */
    def signShortSignature(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): js.typedarray.Uint8Array = js.native
    def signShortSignature(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any,
      htfOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
    ): js.typedarray.Uint8Array = js.native
    /** @deprecated use `shortSignatures.sign` */
    @JSName("signShortSignature")
    def signShortSignature_Any(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): Any = js.native
    @JSName("signShortSignature")
    def signShortSignature_Any(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any,
      htfOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
    ): Any = js.native
    
    /** @deprecated use `longSignatures.sign` */
    @JSName("sign")
    def sign_Any(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp2> */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any
    ): Any = js.native
    @JSName("sign")
    def sign_Any(
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp2> */ Any,
      privateKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify PrivKey */ Any,
      htfOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
    ): Any = js.native
    
    var utils: CalcPairingPrecomputesRandomPrivateKey = js.native
    
    /** @deprecated use `longSignatures.verify` */
    def verify(
      signature: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): Boolean = js.native
    def verify(
      signature: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      htfOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
    ): Boolean = js.native
    
    def verifyBatch(
      signature: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      messages: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
        ],
      publicKeys: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
        ]
    ): Boolean = js.native
    def verifyBatch(
      signature: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      messages: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
        ],
      publicKeys: js.Array[
          /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
        ],
      htfOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
    ): Boolean = js.native
    
    /** @deprecated use `shortSignatures.verify` */
    def verifyShortSignature(
      signature: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): Boolean = js.native
    def verifyShortSignature(
      signature: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      message: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      publicKey: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any,
      htfOpts: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify htfBasicOpts */ Any
    ): Boolean = js.native
  }
  
  trait CurveType extends StObject {
    
    var G1: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsType<Fp> */ Any) & ShortSignature
    
    var G2: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsType<Fp2> */ Any) & Signature
    
    var fields: fmgp.typings.nobleCurves.anon.Fp
    
    var hash: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CHash */ Any
    
    var htfDefaults: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2COpts */ Any
    
    var params: fmgp.typings.nobleCurves.anon.TwistType
    
    var postPrecompute: js.UndefOr[PostPrecomputeFn] = js.undefined
    
    var randomBytes: js.UndefOr[js.Function1[/* bytesLength */ js.UndefOr[Double], js.typedarray.Uint8Array]] = js.undefined
  }
  object CurveType {
    
    inline def apply(
      G1: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsType<Fp> */ Any) & ShortSignature,
      G2: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsType<Fp2> */ Any) & Signature,
      fields: fmgp.typings.nobleCurves.anon.Fp,
      hash: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CHash */ Any,
      htfDefaults: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2COpts */ Any,
      params: fmgp.typings.nobleCurves.anon.TwistType
    ): CurveType = {
      val __obj = js.Dynamic.literal(G1 = G1.asInstanceOf[js.Any], G2 = G2.asInstanceOf[js.Any], fields = fields.asInstanceOf[js.Any], hash = hash.asInstanceOf[js.Any], htfDefaults = htfDefaults.asInstanceOf[js.Any], params = params.asInstanceOf[js.Any])
      __obj.asInstanceOf[CurveType]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: CurveType] (val x: Self) extends AnyVal {
      
      inline def setFields(value: fmgp.typings.nobleCurves.anon.Fp): Self = StObject.set(x, "fields", value.asInstanceOf[js.Any])
      
      inline def setG1(
        value: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsType<Fp> */ Any) & ShortSignature
      ): Self = StObject.set(x, "G1", value.asInstanceOf[js.Any])
      
      inline def setG2(
        value: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CurvePointsType<Fp2> */ Any) & Signature
      ): Self = StObject.set(x, "G2", value.asInstanceOf[js.Any])
      
      inline def setHash(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify CHash */ Any
      ): Self = StObject.set(x, "hash", value.asInstanceOf[js.Any])
      
      inline def setHtfDefaults(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify H2COpts */ Any
      ): Self = StObject.set(x, "htfDefaults", value.asInstanceOf[js.Any])
      
      inline def setParams(value: fmgp.typings.nobleCurves.anon.TwistType): Self = StObject.set(x, "params", value.asInstanceOf[js.Any])
      
      inline def setPostPrecompute(
        value: (/* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Rx */ Any, /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Ry */ Any, /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Rz */ Any, /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Qx */ Any, /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Qy */ Any, /* pointAdd */ PostPrecomputePointAddFn) => Unit
      ): Self = StObject.set(x, "postPrecompute", js.Any.fromFunction6(value))
      
      inline def setPostPrecomputeUndefined: Self = StObject.set(x, "postPrecompute", js.undefined)
      
      inline def setRandomBytes(value: /* bytesLength */ js.UndefOr[Double] => js.typedarray.Uint8Array): Self = StObject.set(x, "randomBytes", js.Any.fromFunction1(value))
      
      inline def setRandomBytesUndefined: Self = StObject.set(x, "randomBytes", js.undefined)
    }
  }
  
  type Fp = js.BigInt
  
  type PostPrecomputeFn = js.Function6[
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Rx */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Ry */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Rz */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Qx */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Qy */ Any, 
    /* pointAdd */ PostPrecomputePointAddFn, 
    Unit
  ]
  
  type PostPrecomputePointAddFn = js.Function5[
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Rx */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Ry */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Rz */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Qx */ Any, 
    /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ /* Qy */ Any, 
    Rx
  ]
  
  type Precompute = js.Array[PrecomputeSingle]
  
  type PrecomputeSingle = js.Array[
    js.Tuple3[
      /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ Any, 
      /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ Any, 
      /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Fp2 */ Any
    ]
  ]
  
  trait ShortSignatureCoder[Fp] extends StObject {
    
    def fromBytes(bytes: js.typedarray.Uint8Array): Any
    
    def fromHex(
      hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): Any
    
    def toBytes(
      point: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
    ): js.typedarray.Uint8Array
    
    def toHex(
      point: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
    ): String
    
    /** @deprecated use `toBytes` */
    def toRawBytes(
      point: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
    ): js.typedarray.Uint8Array
  }
  object ShortSignatureCoder {
    
    inline def apply[Fp](
      fromBytes: js.typedarray.Uint8Array => Any,
      fromHex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => Any,
      toBytes: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array,
      toHex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => String,
      toRawBytes: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array
    ): ShortSignatureCoder[Fp] = {
      val __obj = js.Dynamic.literal(fromBytes = js.Any.fromFunction1(fromBytes), fromHex = js.Any.fromFunction1(fromHex), toBytes = js.Any.fromFunction1(toBytes), toHex = js.Any.fromFunction1(toHex), toRawBytes = js.Any.fromFunction1(toRawBytes))
      __obj.asInstanceOf[ShortSignatureCoder[Fp]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: ShortSignatureCoder[?], Fp] (val x: Self & ShortSignatureCoder[Fp]) extends AnyVal {
      
      inline def setFromBytes(value: js.typedarray.Uint8Array => Any): Self = StObject.set(x, "fromBytes", js.Any.fromFunction1(value))
      
      inline def setFromHex(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => Any
      ): Self = StObject.set(x, "fromHex", js.Any.fromFunction1(value))
      
      inline def setToBytes(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array
      ): Self = StObject.set(x, "toBytes", js.Any.fromFunction1(value))
      
      inline def setToHex(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => String
      ): Self = StObject.set(x, "toHex", js.Any.fromFunction1(value))
      
      inline def setToRawBytes(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array
      ): Self = StObject.set(x, "toRawBytes", js.Any.fromFunction1(value))
    }
  }
  
  trait SignatureCoder[Fp] extends StObject {
    
    def fromBytes(bytes: js.typedarray.Uint8Array): Any
    
    def fromHex(
      hex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any
    ): Any
    
    def toBytes(
      point: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
    ): js.typedarray.Uint8Array
    
    def toHex(
      point: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
    ): String
    
    /** @deprecated use `toBytes` */
    def toRawBytes(
      point: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any
    ): js.typedarray.Uint8Array
  }
  object SignatureCoder {
    
    inline def apply[Fp](
      fromBytes: js.typedarray.Uint8Array => Any,
      fromHex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => Any,
      toBytes: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array,
      toHex: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => String,
      toRawBytes: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array
    ): SignatureCoder[Fp] = {
      val __obj = js.Dynamic.literal(fromBytes = js.Any.fromFunction1(fromBytes), fromHex = js.Any.fromFunction1(fromHex), toBytes = js.Any.fromFunction1(toBytes), toHex = js.Any.fromFunction1(toHex), toRawBytes = js.Any.fromFunction1(toRawBytes))
      __obj.asInstanceOf[SignatureCoder[Fp]]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: SignatureCoder[?], Fp] (val x: Self & SignatureCoder[Fp]) extends AnyVal {
      
      inline def setFromBytes(value: js.typedarray.Uint8Array => Any): Self = StObject.set(x, "fromBytes", js.Any.fromFunction1(value))
      
      inline def setFromHex(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify Hex */ Any => Any
      ): Self = StObject.set(x, "fromHex", js.Any.fromFunction1(value))
      
      inline def setToBytes(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array
      ): Self = StObject.set(x, "toBytes", js.Any.fromFunction1(value))
      
      inline def setToHex(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => String
      ): Self = StObject.set(x, "toHex", js.Any.fromFunction1(value))
      
      inline def setToRawBytes(
        value: /* import warning: transforms.QualifyReferences#resolveTypeRef many Couldn't qualify ProjPointType<Fp> */ Any => js.typedarray.Uint8Array
      ): Self = StObject.set(x, "toRawBytes", js.Any.fromFunction1(value))
    }
  }
  
  /* Rewritten from type alias, can be one of: 
    - `fmgp.typings`.nobleCurves.nobleCurvesStrings.multiplicative
    - `fmgp.typings`.nobleCurves.nobleCurvesStrings.divisive
  */
  trait TwistType extends StObject
  object TwistType {
    
    inline def divisive: fmgp.typings.nobleCurves.nobleCurvesStrings.divisive = "divisive".asInstanceOf[fmgp.typings.nobleCurves.nobleCurvesStrings.divisive]
    
    inline def multiplicative: fmgp.typings.nobleCurves.nobleCurvesStrings.multiplicative = "multiplicative".asInstanceOf[fmgp.typings.nobleCurves.nobleCurvesStrings.multiplicative]
  }
}
