package fmgp.typings.nobleCurves

import fmgp.typings.nobleCurves.anon.RandomPrivateKey
import fmgp.typings.nobleCurves.nobleCurvesStrings.x25519
import fmgp.typings.nobleCurves.nobleCurvesStrings.x448
import org.scalablytyped.runtime.StObject
import scala.scalajs.js
import scala.scalajs.js.annotation.{JSGlobalScope, JSGlobal, JSImport, JSName, JSBracketAccess}

object montgomeryMod {
  
  @JSImport("@noble/curves/abstract/montgomery", JSImport.Namespace)
  @js.native
  val ^ : js.Any = js.native
  
  inline def montgomery(curveDef: CurveType): CurveFn = ^.asInstanceOf[js.Dynamic].applyDynamic("montgomery")(curveDef.asInstanceOf[js.Any]).asInstanceOf[CurveFn]
  
  trait CurveFn extends StObject {
    
    var GuBytes: js.typedarray.Uint8Array
    
    def getPublicKey(privateKey: Hex): js.typedarray.Uint8Array
    
    def getSharedSecret(privateKeyA: Hex, publicKeyB: Hex): js.typedarray.Uint8Array
    
    def scalarMult(scalar: Hex, u: Hex): js.typedarray.Uint8Array
    
    def scalarMultBase(scalar: Hex): js.typedarray.Uint8Array
    
    var utils: RandomPrivateKey
  }
  object CurveFn {
    
    inline def apply(
      GuBytes: js.typedarray.Uint8Array,
      getPublicKey: Hex => js.typedarray.Uint8Array,
      getSharedSecret: (Hex, Hex) => js.typedarray.Uint8Array,
      scalarMult: (Hex, Hex) => js.typedarray.Uint8Array,
      scalarMultBase: Hex => js.typedarray.Uint8Array,
      utils: RandomPrivateKey
    ): CurveFn = {
      val __obj = js.Dynamic.literal(GuBytes = GuBytes.asInstanceOf[js.Any], getPublicKey = js.Any.fromFunction1(getPublicKey), getSharedSecret = js.Any.fromFunction2(getSharedSecret), scalarMult = js.Any.fromFunction2(scalarMult), scalarMultBase = js.Any.fromFunction1(scalarMultBase), utils = utils.asInstanceOf[js.Any])
      __obj.asInstanceOf[CurveFn]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: CurveFn] (val x: Self) extends AnyVal {
      
      inline def setGetPublicKey(value: Hex => js.typedarray.Uint8Array): Self = StObject.set(x, "getPublicKey", js.Any.fromFunction1(value))
      
      inline def setGetSharedSecret(value: (Hex, Hex) => js.typedarray.Uint8Array): Self = StObject.set(x, "getSharedSecret", js.Any.fromFunction2(value))
      
      inline def setGuBytes(value: js.typedarray.Uint8Array): Self = StObject.set(x, "GuBytes", value.asInstanceOf[js.Any])
      
      inline def setScalarMult(value: (Hex, Hex) => js.typedarray.Uint8Array): Self = StObject.set(x, "scalarMult", js.Any.fromFunction2(value))
      
      inline def setScalarMultBase(value: Hex => js.typedarray.Uint8Array): Self = StObject.set(x, "scalarMultBase", js.Any.fromFunction1(value))
      
      inline def setUtils(value: RandomPrivateKey): Self = StObject.set(x, "utils", value.asInstanceOf[js.Any])
    }
  }
  
  trait CurveType extends StObject {
    
    var P: js.BigInt
    
    def adjustScalarBytes(bytes: js.typedarray.Uint8Array): js.typedarray.Uint8Array
    
    def powPminus2(x: js.BigInt): js.BigInt
    
    var randomBytes: js.UndefOr[js.Function1[/* bytesLength */ js.UndefOr[Double], js.typedarray.Uint8Array]] = js.undefined
    
    var `type`: x25519 | x448
  }
  object CurveType {
    
    inline def apply(
      P: js.BigInt,
      adjustScalarBytes: js.typedarray.Uint8Array => js.typedarray.Uint8Array,
      powPminus2: js.BigInt => js.BigInt,
      `type`: x25519 | x448
    ): CurveType = {
      val __obj = js.Dynamic.literal(P = P.asInstanceOf[js.Any], adjustScalarBytes = js.Any.fromFunction1(adjustScalarBytes), powPminus2 = js.Any.fromFunction1(powPminus2))
      __obj.updateDynamic("type")(`type`.asInstanceOf[js.Any])
      __obj.asInstanceOf[CurveType]
    }
    
    @scala.inline
    implicit open class MutableBuilder[Self <: CurveType] (val x: Self) extends AnyVal {
      
      inline def setAdjustScalarBytes(value: js.typedarray.Uint8Array => js.typedarray.Uint8Array): Self = StObject.set(x, "adjustScalarBytes", js.Any.fromFunction1(value))
      
      inline def setP(value: js.BigInt): Self = StObject.set(x, "P", value.asInstanceOf[js.Any])
      
      inline def setPowPminus2(value: js.BigInt => js.BigInt): Self = StObject.set(x, "powPminus2", js.Any.fromFunction1(value))
      
      inline def setRandomBytes(value: /* bytesLength */ js.UndefOr[Double] => js.typedarray.Uint8Array): Self = StObject.set(x, "randomBytes", js.Any.fromFunction1(value))
      
      inline def setRandomBytesUndefined: Self = StObject.set(x, "randomBytes", js.undefined)
      
      inline def setType(value: x25519 | x448): Self = StObject.set(x, "type", value.asInstanceOf[js.Any])
    }
  }
  
  type Hex = String | js.typedarray.Uint8Array
}
