/*
 * Decompiled with CFR 0.152.
 */
package fmgp.crypto;

import fmgp.crypto.PrivateKey;
import fmgp.crypto.PublicKey;
import fmgp.crypto.error.CryptoFailed;
import fmgp.crypto.error.DidFail;
import fmgp.crypto.error.FailToParse$;
import fmgp.did.VerificationMethodReferenced;
import fmgp.did.comm.EncryptedMessage;
import fmgp.did.comm.Message;
import fmgp.did.comm.Message$;
import fmgp.did.comm.PlaintextMessage;
import fmgp.did.comm.SignedMessage;
import java.io.Serializable;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.util.Either;
import zio.ZIO;
import zio.ZIO$;
import zio.json.package;
import zio.json.package$;

public interface CryptoOperations {
    public ZIO<Object, CryptoFailed, SignedMessage> sign(PrivateKey var1, PlaintextMessage var2);

    public ZIO<Object, CryptoFailed, Object> verify(PublicKey var1, SignedMessage var2);

    public static ZIO encrypt$(CryptoOperations $this, Seq recipientKidsKeys, byte[] data) {
        return $this.encrypt((Seq<Tuple2<VerificationMethodReferenced, PublicKey>>)recipientKidsKeys, data);
    }

    default public ZIO<Object, CryptoFailed, EncryptedMessage> encrypt(Seq<Tuple2<VerificationMethodReferenced, PublicKey>> recipientKidsKeys, byte[] data) {
        return this.anonEncrypt(recipientKidsKeys, data);
    }

    public static ZIO encrypt$(CryptoOperations $this, Tuple2 senderKidKey, Seq recipientKidsKeys, byte[] data) {
        return $this.encrypt((Tuple2<VerificationMethodReferenced, PrivateKey>)senderKidKey, (Seq<Tuple2<VerificationMethodReferenced, PublicKey>>)recipientKidsKeys, data);
    }

    default public ZIO<Object, CryptoFailed, EncryptedMessage> encrypt(Tuple2<VerificationMethodReferenced, PrivateKey> senderKidKey, Seq<Tuple2<VerificationMethodReferenced, PublicKey>> recipientKidsKeys, byte[] data) {
        return this.authEncrypt(senderKidKey, recipientKidsKeys, data);
    }

    public ZIO<Object, CryptoFailed, EncryptedMessage> anonEncrypt(Seq<Tuple2<VerificationMethodReferenced, PublicKey>> var1, byte[] var2);

    public ZIO<Object, CryptoFailed, EncryptedMessage> authEncrypt(Tuple2<VerificationMethodReferenced, PrivateKey> var1, Seq<Tuple2<VerificationMethodReferenced, PublicKey>> var2, byte[] var3);

    public static ZIO decrypt$(CryptoOperations $this, Seq recipientKidsKeys, EncryptedMessage msg) {
        return $this.decrypt((Seq<Tuple2<VerificationMethodReferenced, PrivateKey>>)recipientKidsKeys, msg);
    }

    default public ZIO<Object, DidFail, byte[]> decrypt(Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> recipientKidsKeys, EncryptedMessage msg) {
        return this.anonDecrypt(recipientKidsKeys, msg);
    }

    public static ZIO decrypt$(CryptoOperations $this, PublicKey senderKey, Seq recipientKidsKeys, EncryptedMessage msg) {
        return $this.decrypt(senderKey, (Seq<Tuple2<VerificationMethodReferenced, PrivateKey>>)recipientKidsKeys, msg);
    }

    default public ZIO<Object, DidFail, byte[]> decrypt(PublicKey senderKey, Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> recipientKidsKeys, EncryptedMessage msg) {
        return this.authDecrypt(senderKey, recipientKidsKeys, msg);
    }

    public static ZIO anonDecryptMessage$(CryptoOperations $this, Seq recipientKidsKeys, EncryptedMessage msg) {
        return $this.anonDecryptMessage((Seq<Tuple2<VerificationMethodReferenced, PrivateKey>>)recipientKidsKeys, msg);
    }

    default public ZIO<Object, DidFail, Message> anonDecryptMessage(Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> recipientKidsKeys, EncryptedMessage msg) {
        return this.anonDecrypt(recipientKidsKeys, msg).flatMap((Function1 & Serializable)data -> ZIO$.MODULE$.fromEither(() -> CryptoOperations.anonDecryptMessage$$anonfun$1$$anonfun$1(data), (Object)"fmgp.crypto.CryptoOperations.anonDecryptMessage(CryptoOperations.scala:85)"), (Object)"fmgp.crypto.CryptoOperations.anonDecryptMessage(CryptoOperations.scala:86)");
    }

    public static ZIO authDecryptMessage$(CryptoOperations $this, PublicKey senderKey, Seq recipientKidsKeys, EncryptedMessage msg) {
        return $this.authDecryptMessage(senderKey, (Seq<Tuple2<VerificationMethodReferenced, PrivateKey>>)recipientKidsKeys, msg);
    }

    default public ZIO<Object, DidFail, Message> authDecryptMessage(PublicKey senderKey, Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> recipientKidsKeys, EncryptedMessage msg) {
        return this.authDecrypt(senderKey, recipientKidsKeys, msg).flatMap((Function1 & Serializable)data -> ZIO$.MODULE$.fromEither(() -> CryptoOperations.authDecryptMessage$$anonfun$1$$anonfun$1(data), (Object)"fmgp.crypto.CryptoOperations.authDecryptMessage(CryptoOperations.scala:100)"), (Object)"fmgp.crypto.CryptoOperations.authDecryptMessage(CryptoOperations.scala:101)");
    }

    public ZIO<Object, DidFail, byte[]> anonDecrypt(Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> var1, EncryptedMessage var2);

    public ZIO<Object, DidFail, byte[]> authDecrypt(PublicKey var1, Seq<Tuple2<VerificationMethodReferenced, PrivateKey>> var2, EncryptedMessage var3);

    private static Either anonDecryptMessage$$anonfun$1$$anonfun$1(byte[] data$1) {
        return package.DecoderOps$.MODULE$.fromJson$extension(package$.MODULE$.DecoderOps((CharSequence)new String(data$1)), Message$.MODULE$.decoder()).left().map((Function1 & Serializable)info -> FailToParse$.MODULE$.apply(new StringBuilder(25).append("Decoding into a Message: ").append((String)info).toString()));
    }

    private static Either authDecryptMessage$$anonfun$1$$anonfun$1(byte[] data$2) {
        return package.DecoderOps$.MODULE$.fromJson$extension(package$.MODULE$.DecoderOps((CharSequence)new String(data$2)), Message$.MODULE$.decoder()).left().map((Function1 & Serializable)info -> FailToParse$.MODULE$.apply(new StringBuilder(25).append("Decoding into a Message: ").append((String)info).toString()));
    }
}

