/*
 * Decompiled with CFR 0.152.
 */
package fmgp.multibase;

import fmgp.multibase.Base32RFC4648;
import fmgp.multibase.package$;
import java.io.Serializable;
import scala.Byte$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Base32Impl$
implements Serializable {
    private static final int NumGroupsBeforeEncodeInLeastCommonLength;
    private static final int NumGroupsAfterEncodeInLeastCommonLength;
    public static final Base32Impl$ MODULE$;

    private Base32Impl$() {
    }

    static {
        MODULE$ = new Base32Impl$();
        NumGroupsBeforeEncodeInLeastCommonLength = 5;
        NumGroupsAfterEncodeInLeastCommonLength = 8;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Base32Impl$.class);
    }

    public String encode(byte[] data, Base32RFC4648 base32) {
        Object object = Predef$.MODULE$.byteArrayOps(data);
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            return "";
        }
        Object object2 = Predef$.MODULE$.byteArrayOps(data);
        return ArrayOps$.MODULE$.grouped$extension(object2, NumGroupsBeforeEncodeInLeastCommonLength).map((Function1 & Serializable)g -> this.encodeBytes((byte[])g, base32.alphabet().toCharArray(), base32.pad())).mkString();
    }

    private String encodeBytes(byte[] group, char[] alphabet, Option<Object> pad) {
        int n = group.length;
        switch (n) {
            case 1: {
                return this.encode1Bytes(group, alphabet, pad);
            }
            case 2: {
                return this.encode2Bytes(group, alphabet, pad);
            }
            case 3: {
                return this.encode3Bytes(group, alphabet, pad);
            }
            case 4: {
                return this.encode4Bytes(group, alphabet, pad);
            }
            case 5: {
                return this.encode5Bytes(group, alphabet);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private String encode1Bytes(byte[] group, char[] alphabet, Option<Object> pad) {
        return new StringBuilder(0).append(scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[0] >>> 3))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[0])))) << 2]})).mkString()).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString((String)pad.map((Function1 & Serializable)_$1 -> this.encode1Bytes$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1))).getOrElse(this::encode1Bytes$$anonfun$2)), 6)).toString();
    }

    private String encode2Bytes(byte[] group, char[] alphabet, Option<Object> pad) {
        return new StringBuilder(0).append(scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[0] >>> 3))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[0])))) << 2 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 6))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 1))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[1])))) << 4]})).mkString()).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString((String)pad.map((Function1 & Serializable)_$2 -> this.encode2Bytes$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2))).getOrElse(this::encode2Bytes$$anonfun$2)), 4)).toString();
    }

    private String encode3Bytes(byte[] group, char[] alphabet, Option<Object> pad) {
        return new StringBuilder(0).append(scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[0] >>> 3))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[0])))) << 2 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 6))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 1))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[1])))) << 4 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[2] >>> 4))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[2])))) << 1]})).mkString()).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString((String)pad.map((Function1 & Serializable)_$3 -> this.encode3Bytes$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$3))).getOrElse(this::encode3Bytes$$anonfun$2)), 3)).toString();
    }

    private String encode4Bytes(byte[] group, char[] alphabet, Option<Object> pad) {
        return new StringBuilder(0).append(scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[0] >>> 3))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[0])))) << 2 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 6))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 1))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[1])))) << 4 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[2] >>> 4))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[2])))) << 1 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[3] >>> 7))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[3] >>> 2))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[3])))) << 3]})).mkString()).append(pad.map((Function1 & Serializable)_$4 -> this.encode4Bytes$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$4))).getOrElse(this::encode4Bytes$$anonfun$2)).toString();
    }

    private String encode5Bytes(byte[] group, char[] alphabet) {
        return scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[0] >>> 3))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[0])))) << 2 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 6))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[1] >>> 1))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[1])))) << 4 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[2] >>> 4))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[2])))) << 1 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[3] >>> 7))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[3] >>> 2))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[3])))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(group[4] >>> 5))))], alphabet[BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_5BITS().apply((Object)BoxesRunTime.boxToInteger((int)Byte$.MODULE$.byte2int(group[4]))))]})).mkString();
    }

    public byte[] decode(String data, Base32RFC4648 base32) {
        char[] chars = data.toCharArray();
        int length = chars.length;
        int pads = base32.pad().isEmpty() ? 0 : this.numPads(chars, 0, length - 1, BoxesRunTime.unboxToChar((Object)base32.pad().get()));
        Map<Object, Object> pos = base32.alphabetPos();
        Object object = Predef$.MODULE$.charArrayOps(chars);
        Object object2 = Predef$.MODULE$.charArrayOps((char[])ArrayOps$.MODULE$.slice$extension(object, 0, length - pads));
        return (byte[])ArrayOps$.MODULE$.grouped$extension(object2, NumGroupsAfterEncodeInLeastCommonLength).map((Function1 & Serializable)g -> this.decodeBytes((char[])g, pos)).foldLeft((Object)new byte[0], (Function2 & Serializable)(_$5, _$6) -> {
            Object object = Predef$.MODULE$.byteArrayOps(_$5);
            return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, _$6, ClassTag$.MODULE$.apply(Byte.TYPE));
        });
    }

    private int numPads(char[] chars, int pads, int last, char pad) {
        while (last >= 0 && pads < NumGroupsBeforeEncodeInLeastCommonLength && chars[last] == pad) {
            int n = pads + 1;
            int n2 = last - 1;
            pads = n;
            last = n2;
        }
        return pads;
    }

    private byte[] decodeBytes(char[] group, Map<Object, Object> pos) {
        int n = group.length;
        switch (n) {
            case 1: {
                return this.decode1Byte(group, pos);
            }
            case 2: {
                return this.decode2Bytes(group, pos);
            }
            case 3: {
                return this.decode3Bytes(group, pos);
            }
            case 4: {
                return this.decode4Bytes(group, pos);
            }
            case 5: {
                return this.decode5Bytes(group, pos);
            }
            case 6: {
                return this.decode6Bytes(group, pos);
            }
            case 7: {
                return this.decode7Bytes(group, pos);
            }
            case 8: {
                return this.decode8Bytes(group, pos);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private byte[] decode8Bytes(char[] group, Map<Object, Object> pos) {
        return new byte[]{(byte)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[0]))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1]))) >>> 2))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1])))) << 6 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[2]))) << 1 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3]))) >>> 4))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3])))) << 4 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[4]))) >>> 1))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[4])))) << 7 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[5]))) << 2 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[6]))) >>> 3))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[6])))) << 5 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[7]))))};
    }

    private byte[] decode7Bytes(char[] group, Map<Object, Object> pos) {
        return new byte[]{(byte)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[0]))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1]))) >>> 2))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1])))) << 6 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[2]))) << 1 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3]))) >>> 4))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3])))) << 4 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[4]))) >>> 1))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[4])))) << 7 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[5]))) << 2 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[6]))) >>> 3)))))};
    }

    private byte[] decode6Bytes(char[] group, Map<Object, Object> pos) {
        return new byte[]{(byte)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[0]))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1]))) >>> 2))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1])))) << 6 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[2]))) << 1 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3]))) >>> 4))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3])))) << 4 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[4]))) >>> 1)))))};
    }

    private byte[] decode5Bytes(char[] group, Map<Object, Object> pos) {
        return new byte[]{(byte)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[0]))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1]))) >>> 2))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1])))) << 6 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[2]))) << 1 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3]))) >>> 4))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3])))) << 4 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_4BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[4]))) >>> 1)))))};
    }

    private byte[] decode4Bytes(char[] group, Map<Object, Object> pos) {
        return new byte[]{(byte)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[0]))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1]))) >>> 2))))), (byte)(BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_2BITS().apply(pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1])))) << 6 | BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[2]))) << 1 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_1BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[3]))) >>> 4)))))};
    }

    private byte[] decode3Bytes(char[] group, Map<Object, Object> pos) {
        return new byte[]{(byte)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[0]))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1]))) >>> 2)))))};
    }

    private byte[] decode2Bytes(char[] group, Map<Object, Object> pos) {
        return new byte[]{(byte)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[0]))) << 3 | BoxesRunTime.unboxToInt((Object)package$.MODULE$.MASK_3BITS().apply((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)pos.apply((Object)BoxesRunTime.boxToCharacter((char)group[1]))) >>> 2)))))};
    }

    private byte[] decode1Byte(char[] group, Map<Object, Object> pos) {
        return new byte[0];
    }

    private final /* synthetic */ String encode1Bytes$$anonfun$1(char _$1) {
        return BoxesRunTime.boxToCharacter((char)_$1).toString();
    }

    private final String encode1Bytes$$anonfun$2() {
        return "";
    }

    private final /* synthetic */ String encode2Bytes$$anonfun$1(char _$2) {
        return BoxesRunTime.boxToCharacter((char)_$2).toString();
    }

    private final String encode2Bytes$$anonfun$2() {
        return "";
    }

    private final /* synthetic */ String encode3Bytes$$anonfun$1(char _$3) {
        return BoxesRunTime.boxToCharacter((char)_$3).toString();
    }

    private final String encode3Bytes$$anonfun$2() {
        return "";
    }

    private final /* synthetic */ String encode4Bytes$$anonfun$1(char _$4) {
        return BoxesRunTime.boxToCharacter((char)_$4).toString();
    }

    private final String encode4Bytes$$anonfun$2() {
        return "";
    }
}

