package app.futured.arkitekt.core.activity

import android.os.Bundle
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.fragment.app.FragmentActivity
import app.futured.arkitekt.core.BaseViewModel
import app.futured.arkitekt.core.ViewState

/**
 * Base Activity class with built-in ViewModel and DataBinding support.
 */
abstract class BindingViewModelActivity<VM : BaseViewModel<VS>, VS : ViewState, B : ViewDataBinding> :
    ViewModelActivity<VM, VS>() {

    /**
     * Field which holds BR.view identifier generated by Data Binding framework. This field should
     * be specified only once in your project's BaseActivity.
     */
    abstract val brViewVariableId: Int

    /**
     * Field which holds BR.viewModel identifier generated by Data Binding framework. This field should
     * be specified only once in your project's BaseActivity.
     */
    abstract val brViewModelVariableId: Int

    /**
     * Field which holds BR.viewState identifier generated by Data Binding framework. This field should
     * be specified only once in your project's BaseActivity.
     */
    abstract val brViewStateVariableId: Int

    val binding: B
        get() = _binding
            ?: throw IllegalStateException("ViewDataBinding cannot be accessed before onCreate() method call.")

    private var _binding: B? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        _binding = setupBindingView(this, layoutResId) {
            it.setVariable(brViewVariableId, this)
            it.setVariable(brViewModelVariableId, viewModel)
            it.setVariable(brViewStateVariableId, viewModel.viewState)
            it.lifecycleOwner = this
        }
    }

    private fun setupBindingView(fragmentActivity: FragmentActivity, layoutResId: Int, set: (B) -> Unit): B {
        return DataBindingUtil.setContentView<B>(fragmentActivity, layoutResId).also {
            set(it)
        }
    }
}
