package app.futured.arkitekt.core.fragment.bottomsheet

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import app.futured.arkitekt.core.BaseViewModel
import app.futured.arkitekt.core.ViewState

/**
 * Base BottomSheetDialogFragment class with built-in ViewModel and DataBinding support
 */
abstract class BindingViewModelBottomSheetDialogFragment<VM : BaseViewModel<VS>, VS : ViewState, B : ViewDataBinding> :
    ViewModelBottomSheetDialogFragment<VM, VS>() {

    /**
     * Field which holds BR.view identifier generated by Data Binding framework. This field should
     * be specified only once in your project's BaseFragment.
     */
    abstract val brViewVariableId: Int

    /**
     * Field which holds BR.viewModel identifier generated by Data Binding framework. This field should
     * be specified only once in your project's BaseFragment.
     */
    abstract val brViewModelVariableId: Int

    /**
     * Field which holds BR.viewState identifier generated by Data Binding framework. This field should
     * be specified only once in your project's BaseFragment.
     */
    abstract val brViewStateVariableId: Int

    val binding: B
        get() = _binding
            ?: throw IllegalStateException("ViewDataBinding cannot be accessed before onCreateView() method call.")

    private var _binding: B? = null

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        lifecycle.addObserver(viewModel)
        return setupBindingView(inflater, container, layoutResId) {
            it.setVariable(brViewVariableId, this)
            it.setVariable(brViewModelVariableId, viewModel)
            it.setVariable(brViewStateVariableId, viewModel.viewState)
            it.lifecycleOwner = this.viewLifecycleOwner
            _binding = it
        }
    }

    private fun setupBindingView(
        layoutInflater: LayoutInflater,
        container: ViewGroup?,
        layoutResId: Int,
        set: (B) -> Unit
    ): View {
        val binding = DataBindingUtil.inflate<B>(layoutInflater, layoutResId, container, false).also {
            set(it)
        }
        return binding.root
    }
}
