/*
 * Decompiled with CFR 0.152.
 */
package app.hypi.mekadb;

import app.hypi.mekadb.client.AuthCtx;
import app.hypi.mekadb.client.AuthReq;
import app.hypi.mekadb.client.MekaDBClientGrpc;
import app.hypi.mekadb.client.NamedQueryPlaceHolder;
import app.hypi.mekadb.client.PlaceholderPair;
import app.hypi.mekadb.client.PlaceholderValue;
import app.hypi.mekadb.client.SqlRequest;
import app.hypi.mekadb.client.SqlResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.sql.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public class MekaDBClient {
    private final String host;
    private final int port;
    private final boolean withTls;
    private MekaDBClientGrpc.MekaDBClientStub asyncStub;
    private final AtomicLong requestIdCounter = new AtomicLong(0L);
    private final Map<Long, CompletableFuture<List<Map<String, Object>>>> pendingRequests = new ConcurrentHashMap<Long, CompletableFuture<List<Map<String, Object>>>>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private StreamObserver<SqlRequest> requestObserver;
    private int connectAttempts = 0;
    private DateTime lastRes;
    private DateTime lastReq;
    private final ReentrantLock lock = new ReentrantLock();
    private ManagedChannel channel;
    private MekaDBClientGrpc.MekaDBClientBlockingStub blockingStub;

    public MekaDBClient() {
        this("mekadb.hypi.app", 443, true);
    }

    public MekaDBClient(String host, int port, boolean withTls) {
        this.host = host;
        this.port = port;
        this.withTls = withTls;
        this.connect();
        this.initStream();
    }

    private void connect() {
        this.channel = this.withTls ? ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).useTransportSecurity().build() : ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().build();
        this.blockingStub = MekaDBClientGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = MekaDBClientGrpc.newStub((Channel)this.channel);
    }

    private void initStream() {
        this.requestObserver = this.asyncStub.sqlWithJsonResponse(new StreamObserver<SqlResponse>(){

            public void onNext(SqlResponse sqlResponse) {
                MekaDBClient.this.lastRes = DateTime.now();
                MekaDBClient.this.handleResponse(sqlResponse);
            }

            public void onError(Throwable t) {
                MekaDBClient.this.reconnect(t);
            }

            public void onCompleted() {
                MekaDBClient.this.reconnect(new ConnectionFailed());
            }
        });
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public AuthCtx login(String username, String password, String database) {
        return this.login(username, password, database, null);
    }

    public AuthCtx login(String username, String password, String database, String schema) {
        AuthReq.Builder authReqBuilder = AuthReq.newBuilder().setUsername(username).setPassword(password).setDatabase(database);
        if (schema != null && !schema.isEmpty()) {
            authReqBuilder.setSchema(schema);
        }
        AuthReq authReq = authReqBuilder.build();
        return this.blockingStub.authenticate(authReq);
    }

    public CompletableFuture<List<Map<String, Object>>> query(AuthCtx creds, String sql) {
        return this.query(creds, sql, null);
    }

    public CompletableFuture<List<Map<String, Object>>> query(AuthCtx creds, String sql, Map<String, Object> params) {
        if (!this.pendingRequests.isEmpty() && this.lastReq != null && this.lastRes != null && new Duration((ReadableInstant)this.lastReq, (ReadableInstant)DateTime.now()).getStandardSeconds() <= 30L && new Duration((ReadableInstant)this.lastRes, (ReadableInstant)DateTime.now()).getStandardSeconds() > 40L) {
            this.reconnect(new ConnectionFailed());
        }
        CompletableFuture<List<Map<String, Object>>> future = new CompletableFuture<List<Map<String, Object>>>();
        long requestId = this.requestIdCounter.incrementAndGet();
        this.pendingRequests.put(requestId, future);
        SqlRequest.Builder requestBuilder = SqlRequest.newBuilder().setRequestId(requestId).setAuth(creds).setQuery(sql);
        NamedQueryPlaceHolder.Builder paramsBuilder = NamedQueryPlaceHolder.newBuilder();
        if (params != null) {
            params.forEach((key, value) -> {
                PlaceholderValue.Builder valueBuilder = PlaceholderValue.newBuilder();
                if (value instanceof Integer) {
                    valueBuilder.setI32T((Integer)value);
                } else if (value instanceof Long) {
                    valueBuilder.setI64T((Long)value);
                } else if (value instanceof Boolean) {
                    valueBuilder.setBoolT((Boolean)value);
                } else if (value instanceof Double) {
                    valueBuilder.setDoubleT((Double)value);
                } else if (value instanceof Float) {
                    valueBuilder.setFloatT(((Float)value).floatValue());
                } else if (value instanceof Date) {
                    valueBuilder.setTimestampMillis(((Date)value).getTime());
                } else if (value instanceof java.util.Date) {
                    valueBuilder.setTimestampMillis(((java.util.Date)value).getTime());
                } else if (value instanceof String) {
                    valueBuilder.setStrT((String)value);
                }
                paramsBuilder.addValues(PlaceholderPair.newBuilder().setName((String)key).setValue(valueBuilder));
            });
        }
        requestBuilder.setNamed(paramsBuilder);
        this.requestObserver.onNext((Object)requestBuilder.build());
        return future;
    }

    private void reconnect(Throwable e) {
        try {
            this.lock.lock();
            Thread.sleep(1000L);
            if (this.connectAttempts++ > 3 && this.channel != null) {
                this.channel.shutdownNow().awaitTermination(10L, TimeUnit.SECONDS);
            }
            this.failPendingRequests(e);
            this.connect();
            this.initStream();
        }
        catch (InterruptedException ex) {
            this.failPendingRequests(ex);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    private void failPendingRequests(Throwable e) {
        for (CompletableFuture<List<Map<String, Object>>> value : this.pendingRequests.values()) {
            value.completeExceptionally(e);
        }
        this.pendingRequests.clear();
    }

    private void handleResponse(SqlResponse sqlResponse) {
        CompletableFuture<List<Map<String, Object>>> future = this.pendingRequests.remove(sqlResponse.getRequestId());
        if (future == null) {
            return;
        }
        if (sqlResponse.getPayloadCase() == SqlResponse.PayloadCase.RESPONSE) {
            try {
                List result = (List)this.objectMapper.readValue(sqlResponse.getResponse(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        } else if (sqlResponse.getPayloadCase() == SqlResponse.PayloadCase.ERROR) {
            future.completeExceptionally(new Exception(sqlResponse.getError().getMessage()));
        }
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        MekaDBClient client = new MekaDBClient();
        AuthCtx auth = client.login("<username>", "<password>", "<database>");
        List<Map<String, Object>> createTableRes = client.query(auth, "CREATE TABLE IF NOT EXISTS user(username VARCHAR, pass VARCHAR, PRIMARY KEY (username))").get();
        System.out.println(createTableRes);
        List<Map<String, Object>> insertRes = client.query(auth, "INSERT INTO user(username,pass) VALUES('courtney','pass1'),('damion','pass2')").get();
        System.out.println(insertRes);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("pass", "pass1");
        List<Map<String, Object>> rows = client.query(auth, "SELECT * FROM user where pass = :pass", params).get();
        System.out.println(rows);
    }

    public static class ConnectionFailed
    extends RuntimeException {
    }
}

