package app.iapush.client

import app.iapush.models.application.IAPushEnvironment
import app.iapush.repositories.apps.AppsRemoteRepository
import app.iapush.repositories.auth.AuthAPIRemoteRepository
import app.iapush.repositories.leaderboard.LeaderboardRemoteRepository
import app.iapush.repositories.notifications.NotificationTokensRemoteRepository
import app.iapush.repositories.redirections.RedirectionRemoteRepository
import app.iapush.repositories.users.UsersRemoteRepository
import dev.kaccelero.client.AbstractAPIClient
import dev.kaccelero.commons.auth.IGetTokenUseCase
import dev.kaccelero.commons.auth.ILogoutUseCase
import dev.kaccelero.commons.auth.IRenewTokenUseCase
import io.ktor.http.*

class IAPushClient(
    getTokenUseCase: IGetTokenUseCase,
    renewTokenUseCase: IRenewTokenUseCase,
    logoutUseCase: ILogoutUseCase,
    environment: IAPushEnvironment = IAPushEnvironment.PRODUCTION,
) : AbstractAPIClient(
    environment.baseUrl,
    getTokenUseCase,
    renewTokenUseCase,
    logoutUseCase
), IIAPushClient {

    override val auth = AuthAPIRemoteRepository(this)
    override val users = UsersRemoteRepository(this)
    override val apps = AppsRemoteRepository(this, users)
    override val redirections = RedirectionRemoteRepository(this, apps)
    override val leaderboard = LeaderboardRemoteRepository(this)
    override val notificationTokens = NotificationTokensRemoteRepository(this, users)

    override fun shouldIncludeToken(method: HttpMethod, path: String): Boolean {
        // Don't include token for refresh token endpoint (to avoid infinite loop)
        return path != "/api/v1/auth/refresh"
    }

}
