package app.iapush.models.leaderboard

import app.iapush.models.users.User
import dev.kaccelero.annotations.Schema
import dev.kaccelero.models.IModel
import dev.kaccelero.models.UUID
import kotlinx.serialization.Serializable

@Serializable
data class LeaderboardMembership(
    @Schema("Id of the user", "abc123")
    val userId: UUID,
    @Schema("Name shown in the leaderboard", "John Doe")
    val name: String,
    val user: User? = null,
    val metadata: LeaderboardMetadata? = null,
) : IModel<UUID, CreateLeaderboardMembershipPayload, Unit> {

    override val id: UUID
        get() = userId

}
