package app.iapush.repositories.apps

import app.iapush.models.apps.App
import app.iapush.models.apps.CreateAppPayload
import app.iapush.models.apps.UpdateAppPayload
import dev.kaccelero.models.UUID

interface IAppsRemoteRepository {

    suspend fun list(userId: UUID): List<App>
    suspend fun get(id: UUID, userId: UUID): App?
    suspend fun create(payload: CreateAppPayload, userId: UUID): App?
    suspend fun update(id: UUID, payload: UpdateAppPayload, userId: UUID): App?
    suspend fun delete(id: UUID, userId: UUID): Boolean

}
