/*
 * Decompiled with CFR 0.152.
 */
package app.iapush.client;

import app.iapush.client.IIAPushClient;
import app.iapush.models.application.IAPushEnvironment;
import app.iapush.repositories.apps.AppsRemoteRepository;
import app.iapush.repositories.auth.AuthAPIRemoteRepository;
import app.iapush.repositories.leaderboard.LeaderboardRemoteRepository;
import app.iapush.repositories.notifications.NotificationTokensRemoteRepository;
import app.iapush.repositories.redirections.RedirectionRemoteRepository;
import app.iapush.repositories.users.UsersRemoteRepository;
import dev.kaccelero.client.AbstractAPIClient;
import dev.kaccelero.commons.auth.IGetTokenUseCase;
import dev.kaccelero.commons.auth.ILogoutUseCase;
import dev.kaccelero.commons.auth.IRenewTokenUseCase;
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository;
import io.ktor.http.HttpMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006+"}, d2={"Lapp/iapush/client/IAPushClient;", "Ldev/kaccelero/client/AbstractAPIClient;", "Lapp/iapush/client/IIAPushClient;", "getTokenUseCase", "Ldev/kaccelero/commons/auth/IGetTokenUseCase;", "renewTokenUseCase", "Ldev/kaccelero/commons/auth/IRenewTokenUseCase;", "logoutUseCase", "Ldev/kaccelero/commons/auth/ILogoutUseCase;", "environment", "Lapp/iapush/models/application/IAPushEnvironment;", "<init>", "(Ldev/kaccelero/commons/auth/IGetTokenUseCase;Ldev/kaccelero/commons/auth/IRenewTokenUseCase;Ldev/kaccelero/commons/auth/ILogoutUseCase;Lapp/iapush/models/application/IAPushEnvironment;)V", "auth", "Lapp/iapush/repositories/auth/AuthAPIRemoteRepository;", "getAuth", "()Lapp/iapush/repositories/auth/AuthAPIRemoteRepository;", "users", "Lapp/iapush/repositories/users/UsersRemoteRepository;", "getUsers", "()Lapp/iapush/repositories/users/UsersRemoteRepository;", "apps", "Lapp/iapush/repositories/apps/AppsRemoteRepository;", "getApps", "()Lapp/iapush/repositories/apps/AppsRemoteRepository;", "redirections", "Lapp/iapush/repositories/redirections/RedirectionRemoteRepository;", "getRedirections", "()Lapp/iapush/repositories/redirections/RedirectionRemoteRepository;", "leaderboard", "Lapp/iapush/repositories/leaderboard/LeaderboardRemoteRepository;", "getLeaderboard", "()Lapp/iapush/repositories/leaderboard/LeaderboardRemoteRepository;", "notificationTokens", "Lapp/iapush/repositories/notifications/NotificationTokensRemoteRepository;", "getNotificationTokens", "()Lapp/iapush/repositories/notifications/NotificationTokensRemoteRepository;", "shouldIncludeToken", "", "method", "Lio/ktor/http/HttpMethod;", "path", "", "commons"})
public final class IAPushClient
extends AbstractAPIClient
implements IIAPushClient {
    @NotNull
    private final AuthAPIRemoteRepository auth;
    @NotNull
    private final UsersRemoteRepository users;
    @NotNull
    private final AppsRemoteRepository apps;
    @NotNull
    private final RedirectionRemoteRepository redirections;
    @NotNull
    private final LeaderboardRemoteRepository leaderboard;
    @NotNull
    private final NotificationTokensRemoteRepository notificationTokens;

    public IAPushClient(@NotNull IGetTokenUseCase getTokenUseCase, @NotNull IRenewTokenUseCase renewTokenUseCase, @NotNull ILogoutUseCase logoutUseCase, @NotNull IAPushEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)getTokenUseCase, (String)"getTokenUseCase");
        Intrinsics.checkNotNullParameter((Object)renewTokenUseCase, (String)"renewTokenUseCase");
        Intrinsics.checkNotNullParameter((Object)logoutUseCase, (String)"logoutUseCase");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        super(environment.getBaseUrl(), getTokenUseCase, renewTokenUseCase, logoutUseCase, null, null, 48, null);
        this.auth = new AuthAPIRemoteRepository(this);
        this.users = new UsersRemoteRepository(this);
        this.apps = new AppsRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getUsers());
        this.redirections = new RedirectionRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getApps());
        this.leaderboard = new LeaderboardRemoteRepository(this);
        this.notificationTokens = new NotificationTokensRemoteRepository(this, (IAPIChildModelRemoteRepository)this.getUsers());
    }

    public /* synthetic */ IAPushClient(IGetTokenUseCase iGetTokenUseCase, IRenewTokenUseCase iRenewTokenUseCase, ILogoutUseCase iLogoutUseCase, IAPushEnvironment iAPushEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            iAPushEnvironment = IAPushEnvironment.PRODUCTION;
        }
        this(iGetTokenUseCase, iRenewTokenUseCase, iLogoutUseCase, iAPushEnvironment);
    }

    @Override
    @NotNull
    public AuthAPIRemoteRepository getAuth() {
        return this.auth;
    }

    @Override
    @NotNull
    public UsersRemoteRepository getUsers() {
        return this.users;
    }

    @Override
    @NotNull
    public AppsRemoteRepository getApps() {
        return this.apps;
    }

    @Override
    @NotNull
    public RedirectionRemoteRepository getRedirections() {
        return this.redirections;
    }

    @Override
    @NotNull
    public LeaderboardRemoteRepository getLeaderboard() {
        return this.leaderboard;
    }

    @Override
    @NotNull
    public NotificationTokensRemoteRepository getNotificationTokens() {
        return this.notificationTokens;
    }

    public boolean shouldIncludeToken(@NotNull HttpMethod method, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !Intrinsics.areEqual((Object)path, (Object)"/api/v1/auth/refresh");
    }
}

