package app.iapush.repositories.apps

import app.iapush.client.IIAPushClient
import app.iapush.models.apps.App
import app.iapush.models.apps.CreateAppPayload
import app.iapush.models.apps.UpdateAppPayload
import app.iapush.models.users.User
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.util.reflect.*

class AppsRemoteRepository(
    client: IIAPushClient,
    parentRepository: IAPIChildModelRemoteRepository<User, UUID, *, *, *>,
) : APIChildModelRemoteRepository<App, String, CreateAppPayload, UpdateAppPayload, UUID>(
    typeInfo<App>(),
    typeInfo<CreateAppPayload>(),
    typeInfo<UpdateAppPayload>(),
    typeInfo<List<App>>(),
    client,
    parentRepository,
    prefix = "/api/v1"
), IAppsRemoteRepository {

    override suspend fun list(userId: UUID): List<App> =
        list(RecursiveId<User, UUID, Unit>(userId), null)

    override suspend fun get(id: String, userId: UUID): App? =
        get(id, RecursiveId<User, UUID, Unit>(userId), null)

    override suspend fun create(payload: CreateAppPayload, userId: UUID): App? =
        create(payload, RecursiveId<User, UUID, Unit>(userId), null)

    override suspend fun update(id: String, payload: UpdateAppPayload, userId: UUID): App? =
        update(id, payload, RecursiveId<User, UUID, Unit>(userId), null)

    override suspend fun delete(id: String, userId: UUID): Boolean =
        delete(id, RecursiveId<User, UUID, Unit>(userId), null)

}
