package app.iapush.repositories.notifications

import app.iapush.client.IIAPushClient
import app.iapush.models.notifications.CreateNotificationTokenPayload
import app.iapush.models.notifications.NotificationToken
import app.iapush.models.users.User
import dev.kaccelero.models.RecursiveId
import dev.kaccelero.models.UUID
import dev.kaccelero.repositories.APIChildModelRemoteRepository
import dev.kaccelero.repositories.IAPIChildModelRemoteRepository
import io.ktor.util.reflect.*

class NotificationTokensRemoteRepository(
    client: IIAPushClient,
    parentRepository: IAPIChildModelRemoteRepository<User, UUID, *, *, *>,
) : APIChildModelRemoteRepository<NotificationToken, String, CreateNotificationTokenPayload, Unit, UUID>(
    typeInfo<NotificationToken>(),
    typeInfo<CreateNotificationTokenPayload>(),
    typeInfo<Unit>(),
    typeInfo<List<NotificationToken>>(),
    client,
    parentRepository,
    prefix = "/api/v1"
), INotificationTokensRemoteRepository {

    override suspend fun create(payload: CreateNotificationTokenPayload, userId: UUID): NotificationToken? =
        create(payload, RecursiveId<User, UUID, Unit>(userId), null)

}
