package app.iapush.repositories.apps

import app.iapush.models.apps.App
import app.iapush.models.apps.CreateAppPayload
import app.iapush.models.apps.UpdateAppPayload
import dev.kaccelero.models.UUID

interface IAppsRemoteRepository {

    suspend fun list(userId: UUID): List<App>
    suspend fun get(id: String, userId: UUID): App?
    suspend fun create(payload: CreateAppPayload, userId: UUID): App?
    suspend fun update(id: String, payload: UpdateAppPayload, userId: UUID): App?
    suspend fun delete(id: String, userId: UUID): Boolean

}
