package app.iapush.repositories.currency

import app.iapush.models.currency.CurrencyResponse
import dev.kaccelero.serializers.Serialization
import io.ktor.client.*
import io.ktor.client.call.*
import io.ktor.client.plugins.contentnegotiation.*
import io.ktor.client.request.*
import io.ktor.serialization.kotlinx.json.*
import kotlinx.datetime.Clock
import kotlinx.datetime.TimeZone
import kotlinx.datetime.toLocalDateTime

class CurrencyRemoteRepository : ICurrencyRemoteRepository {

    private val ratesUrl = "https://cdn.jsdelivr.net/npm/@fawazahmed0/currency-api@latest/v1/currencies/usd.json"

    private var cachedRates: CurrencyResponse? = null

    private val client = HttpClient {
        install(ContentNegotiation) {
            json(Serialization.json)
        }
    }

    override suspend fun list(): CurrencyResponse =
        cachedRates?.takeIf { it.date == Clock.System.now().toLocalDateTime(TimeZone.currentSystemDefault()).date }
            ?: client.get(ratesUrl).body<CurrencyResponse>().also { cachedRates = it }

}
