/*
 * Decompiled with CFR 0.152.
 */
package app.jackychu.api.simplegoogletranslate;

import app.jackychu.api.simplegoogletranslate.Language;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;

public class SimpleGoogleTranslate {
    private String googleTranslateApiUrl;

    public SimpleGoogleTranslate() {
        this("https://translate.googleapis.com/translate_a/single");
    }

    public SimpleGoogleTranslate(String googleTranslateApiUrl) {
        this.googleTranslateApiUrl = googleTranslateApiUrl;
    }

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);
        System.out.print("Please type the text which you want to translate: ");
        String text = in.nextLine();
        int index = 1;
        StringBuilder sb = new StringBuilder();
        for (Language lang : Language.values()) {
            if (lang.equals((Object)Language.auto)) continue;
            sb.append(index).append(": ").append(lang.name).append(" (").append((Object)lang).append(")").append(System.lineSeparator());
            ++index;
        }
        System.out.println(sb);
        System.out.print("Please select the language which you want translate to: ");
        int lang = in.nextInt();
        Language target = Language.values()[lang];
        SimpleGoogleTranslate translate = new SimpleGoogleTranslate();
        try {
            System.out.println("Translating to " + target.name);
            System.out.println("Result: ");
            System.out.println(translate.doTranslate(Language.auto, target, text));
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String doTranslate(Language source, Language target, String text) throws IOException, InterruptedException {
        String newUrl = this.googleTranslateApiUrl + "?client=gtx&dt=t&sl=" + source + "&tl=" + target + "&text=" + URLEncoder.encode(text, StandardCharsets.UTF_8);
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create(newUrl)).header("Accept", "application/json").build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        JSONArray arr1 = (JSONArray)JSONValue.parse((String)response.body());
        JSONArray arr2 = (JSONArray)JSONValue.parse((String)arr1.get(0).toString());
        JSONArray arr3 = (JSONArray)JSONValue.parse((String)arr2.get(0).toString());
        return arr3.get(0).toString();
    }

    public String getGoogleTranslateApiUrl() {
        return this.googleTranslateApiUrl;
    }

    public void setGoogleTranslateApiUrl(String googleTranslateApiUrl) {
        this.googleTranslateApiUrl = googleTranslateApiUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleGoogleTranslate)) {
            return false;
        }
        SimpleGoogleTranslate other = (SimpleGoogleTranslate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$googleTranslateApiUrl = this.getGoogleTranslateApiUrl();
        String other$googleTranslateApiUrl = other.getGoogleTranslateApiUrl();
        return !(this$googleTranslateApiUrl == null ? other$googleTranslateApiUrl != null : !this$googleTranslateApiUrl.equals(other$googleTranslateApiUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleGoogleTranslate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $googleTranslateApiUrl = this.getGoogleTranslateApiUrl();
        result = result * 59 + ($googleTranslateApiUrl == null ? 43 : $googleTranslateApiUrl.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleGoogleTranslate(googleTranslateApiUrl=" + this.getGoogleTranslateApiUrl() + ")";
    }
}

