/*
 * Decompiled with CFR 0.152.
 */
package app.keve.ktlsh.benchmarks;

import app.keve.ktlsh.TLSHUtil;
import app.keve.ktlsh.testutil.Util;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=1)
@Warmup(time=2)
@Measurement(iterations=2)
public class HashBenchmark {
    private static final String TLSH_ALGNAME = "TLSH";
    private static final int KIB = 1024;

    private void test(MessageDigest md, byte[] buf) {
        byte[] hash = md.digest(buf);
        TLSHUtil.encoded((byte[])hash);
    }

    @Benchmark
    @OperationsPerInvocation(value=32)
    public void testTMSmall32KiB(MyState state) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance(TLSH_ALGNAME, Util.providerNameTM());
        this.test(md, state.getSmallBuf32KiB());
    }

    @Benchmark
    @OperationsPerInvocation(value=32)
    public void testKSmall32KiB(MyState state) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance(TLSH_ALGNAME, TLSHUtil.providerNameK());
        this.test(md, state.getSmallBuf32KiB());
    }

    @Benchmark
    @OperationsPerInvocation(value=32)
    public void testMD5Small32KiB(MyState state) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        this.test(md, state.getSmallBuf32KiB());
    }

    @Benchmark
    @OperationsPerInvocation(value=16384)
    public void testTMLarge16MiB(MyState state) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance(TLSH_ALGNAME, Util.providerNameTM());
        this.test(md, state.getLargeBuf16MiB());
    }

    @Benchmark
    @OperationsPerInvocation(value=16384)
    public void testKLarge16MiB(MyState state) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance(TLSH_ALGNAME, TLSHUtil.providerNameK());
        this.test(md, state.getLargeBuf16MiB());
    }

    @Benchmark
    @OperationsPerInvocation(value=16384)
    public void testMD5Large16MiB(MyState state) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        this.test(md, state.getLargeBuf16MiB());
    }

    static {
        Util.registerProvider();
    }

    @State(value=Scope.Benchmark)
    public static class MyState {
        private byte[] smallBuf32KiB;
        private byte[] largeBuf16MiB;
        private byte[] hugeBuf1GiB;

        @Setup
        public void init() throws NoSuchAlgorithmException {
            SecureRandom rnd = Util.rnd();
            this.smallBuf32KiB = new byte[32768];
            this.largeBuf16MiB = new byte[0x1000000];
            this.hugeBuf1GiB = new byte[0x40000000];
            rnd.nextBytes(this.getSmallBuf32KiB());
            rnd.nextBytes(this.getLargeBuf16MiB());
            rnd.nextBytes(this.getHugeBuf1GiB());
        }

        public byte[] getSmallBuf32KiB() {
            return this.smallBuf32KiB;
        }

        public byte[] getLargeBuf16MiB() {
            return this.largeBuf16MiB;
        }

        public byte[] getHugeBuf1GiB() {
            return this.hugeBuf1GiB;
        }
    }
}

