/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.chainbase.indexers;

import app.keyconnect.chainbase.listeners.StatsListener;
import app.keyconnect.chainbase.persistence.models.EthTransaction;
import app.keyconnect.chainbase.persistence.repositories.EthTransactionRepository;
import java.util.Optional;
import java.util.function.Consumer;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Transaction;

public class EthBlockProcessor
implements Consumer<EthBlock.Block> {
    private final EthTransactionRepository ethTransactionRepository;
    private final StatsListener statsListener;

    public EthBlockProcessor(EthTransactionRepository ethTransactionRepository, StatsListener statsListener) {
        this.ethTransactionRepository = ethTransactionRepository;
        this.statsListener = statsListener;
    }

    @Override
    public void accept(EthBlock.Block block) {
        block.getTransactions().forEach(tR -> {
            EthBlock.TransactionObject tx = (EthBlock.TransactionObject)tR.get();
            Transaction transaction = tx.get();
            EthTransaction ethTransaction = EthTransaction.builder().hash(transaction.getHash()).blockNumber(transaction.getBlockNumber().longValue()).from(transaction.getFrom()).to(transaction.getTo()).timestamp(block.getTimestamp().toString()).gasLimit(block.getGasLimit().toString()).gasPrice(transaction.getGasPrice().toString()).value(transaction.getValue().toString()).nonce(transaction.getNonce().toString()).input(transaction.getInput()).build();
            Optional maybeSaved = this.ethTransactionRepository.findTopByHash(transaction.getHash());
            if (maybeSaved.isEmpty()) {
                this.statsListener.newTransactionSaved();
                this.ethTransactionRepository.save((Object)ethTransaction);
            }
        });
        this.statsListener.transactionsProcessed(block.getTransactions().size());
        this.statsListener.newBlockProcessed(block);
    }
}

