/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.chainbase.indexers.listeners;

import io.reactivex.disposables.Disposable;
import java.math.BigInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.http.HttpService;

public class EthBlockListener
implements Runnable {
    private final Web3j client;
    private final Consumer<EthBlock.Block> blockConsumer;
    private BigInteger lastBlock;
    private boolean stop = false;
    private Disposable subscription;

    public EthBlockListener(String httpAddress, Consumer<EthBlock.Block> blockConsumer, BigInteger lastBlock) {
        this.client = Web3j.build((Web3jService)new HttpService(httpAddress));
        this.blockConsumer = blockConsumer;
        this.lastBlock = lastBlock;
    }

    @Override
    public void run() {
        this.subscription = this.subscribe();
        while (!this.subscription.isDisposed() && !this.stop) {
            Thread.sleep(10000L);
            if (!this.subscription.isDisposed()) continue;
            this.subscription = this.subscribe();
        }
        this.subscription.dispose();
    }

    public void stop() {
        this.stop = true;
    }

    @NotNull
    private Disposable subscribe() {
        return this.client.replayPastAndFutureBlocksFlowable((DefaultBlockParameter)(this.lastBlock == null ? DefaultBlockParameterName.EARLIEST : DefaultBlockParameter.valueOf((BigInteger)this.lastBlock)), true).forEach(ethBlock -> {
            EthBlock.Block block = ethBlock.getBlock();
            this.blockConsumer.accept(block);
            this.lastBlock = block.getNumber();
        });
    }
}

