/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.chainbase.listeners;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.core.methods.response.EthBlock;

public class StatsListener {
    private static final Logger logger = LoggerFactory.getLogger(StatsListener.class);
    private final ScheduledExecutorService loggingThread = Executors.newScheduledThreadPool(1);
    private final AtomicInteger totalBlocksProcessed = new AtomicInteger(0);
    private final AtomicInteger totalTransactionsProcessed = new AtomicInteger(0);
    private final AtomicInteger totalTransactionsSaved = new AtomicInteger(0);
    private final AtomicReference<EthBlock.Block> lastBlockProcessed = new AtomicReference();

    public StatsListener() {
        this.initLoggingThread();
    }

    private void initLoggingThread() {
        this.loggingThread.scheduleAtFixedRate(() -> logger.info("Processed: lastBlockNumber={} totalBlocks={} totalTransactions={} savedTransactions={}", new Object[]{((EthBlock.Block)this.lastBlockProcessed.get()).getNumber().toString(), this.totalBlocksProcessed.get(), this.totalTransactionsProcessed.get(), this.totalTransactionsSaved.get()}), 5L, 5L, TimeUnit.SECONDS);
    }

    public void newBlockProcessed(EthBlock.Block block) {
        this.lastBlockProcessed.set(block);
        this.totalBlocksProcessed.incrementAndGet();
    }

    public void newTransactionSaved() {
        this.totalTransactionsSaved.incrementAndGet();
    }

    public void transactionsProcessed(int count) {
        this.totalTransactionsProcessed.addAndGet(count);
    }

    public void stop() {
        this.loggingThread.shutdown();
    }
}

