/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.chainbase.persistence.models;

import app.keyconnect.chainbase.persistence.models.EthTransaction;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity(name="eth_transactions")
@Table(indexes={@Index(columnList="hash"), @Index(columnList="from_account"), @Index(columnList="to_account"), @Index(columnList="from_account,to_account"), @Index(columnList="timestamp")})
public class EthTransaction {
    @Id
    @Column(name="hash")
    private String hash;
    @Column(name="block_number")
    private long blockNumber;
    @Column(name="from_account")
    private String from;
    @Column(name="to_account")
    private String to;
    @Column(name="tx_value")
    private String value;
    @Column(name="gas_limit")
    private String gasLimit;
    @Column(name="gas_price")
    private String gasPrice;
    @Column(name="nonce")
    private String nonce;
    @Column(name="input", columnDefinition="TEXT")
    private String input;
    @Column(name="timestamp")
    private String timestamp;

    public static EthTransactionBuilder builder() {
        return new EthTransactionBuilder();
    }

    public EthTransactionBuilder toBuilder() {
        return new EthTransactionBuilder().hash(this.hash).blockNumber(this.blockNumber).from(this.from).to(this.to).value(this.value).gasLimit(this.gasLimit).gasPrice(this.gasPrice).nonce(this.nonce).input(this.input).timestamp(this.timestamp);
    }

    public String getHash() {
        return this.hash;
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getValue() {
        return this.value;
    }

    public String getGasLimit() {
        return this.gasLimit;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getInput() {
        return this.input;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setBlockNumber(long blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setGasLimit(String gasLimit) {
        this.gasLimit = gasLimit;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EthTransaction)) {
            return false;
        }
        EthTransaction other = (EthTransaction)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        if (this.getBlockNumber() != other.getBlockNumber()) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$gasLimit = this.getGasLimit();
        String other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !this$gasLimit.equals(other$gasLimit)) {
            return false;
        }
        String this$gasPrice = this.getGasPrice();
        String other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !this$gasPrice.equals(other$gasPrice)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EthTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        long $blockNumber = this.getBlockNumber();
        result = result * 59 + (int)($blockNumber >>> 32 ^ $blockNumber);
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : $gasLimit.hashCode());
        String $gasPrice = this.getGasPrice();
        result = result * 59 + ($gasPrice == null ? 43 : $gasPrice.hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    public String toString() {
        return "EthTransaction(hash=" + this.getHash() + ", blockNumber=" + this.getBlockNumber() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", value=" + this.getValue() + ", gasLimit=" + this.getGasLimit() + ", gasPrice=" + this.getGasPrice() + ", nonce=" + this.getNonce() + ", input=" + this.getInput() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public EthTransaction() {
    }

    public EthTransaction(String hash, long blockNumber, String from, String to, String value, String gasLimit, String gasPrice, String nonce, String input, String timestamp) {
        this.hash = hash;
        this.blockNumber = blockNumber;
        this.from = from;
        this.to = to;
        this.value = value;
        this.gasLimit = gasLimit;
        this.gasPrice = gasPrice;
        this.nonce = nonce;
        this.input = input;
        this.timestamp = timestamp;
    }
}

