/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.controllers;

import app.keyconnect.api.client.model.CurrencyValue;
import app.keyconnect.rippled.api.client.model.AccountTransaction;
import app.keyconnect.server.factories.BlockchainGatewayFactory;
import app.keyconnect.server.gateways.BlockchainGateway;
import app.keyconnect.server.gateways.XrpGateway;
import app.keyconnect.server.gateways.exceptions.UnknownNetworkException;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BlockchainGeneratorController {
    private final BlockchainGatewayFactory blockchainGatewayFactory;

    @Autowired
    public BlockchainGeneratorController(BlockchainGatewayFactory blockchainGatewayFactory) {
        this.blockchainGatewayFactory = blockchainGatewayFactory;
    }

    @GetMapping(path={"/v1/blockchains/xrp/generator/payment"}, produces={"application/json"})
    public ResponseEntity<AccountTransaction> generatePayment(@RequestParam(value="sourceAccount") String sourceAccount, @RequestParam(value="destinationAccount") String destinationAccount, @RequestParam(value="destinationTag", required=false) int destinationTag, @RequestParam(value="amount") String amountInDrops, @RequestParam(value="fee", required=false) String feeInDrops, @RequestParam(value="network", required=false) String network) throws UnknownNetworkException {
        BlockchainGateway xrpGateway = this.blockchainGatewayFactory.getGateway("xrp");
        if (StringUtils.isBlank((CharSequence)feeInDrops)) {
            CurrencyValue fee = xrpGateway.getFee(network).getFee();
            if (fee.getCurrency() == CurrencyValue.CurrencyEnum.DROPS) {
                feeInDrops = fee.getAmount();
            } else if (fee.getCurrency() == CurrencyValue.CurrencyEnum.XRP) {
                feeInDrops = new BigDecimal(fee.getAmount()).multiply(XrpGateway.DROPS_PER_XRP).toString();
            } else {
                throw new IllegalArgumentException("Fee is in unsupported currency for XRP payment, fee=" + fee);
            }
        }
        return ResponseEntity.ok((Object)new AccountTransaction().transactionType("payment").account(sourceAccount).destination(destinationAccount).destinationTag(BigDecimal.valueOf(destinationTag)).amount(amountInDrops).fee(feeInDrops));
    }
}

