/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.controllers;

import app.keyconnect.api.client.model.AvailableBlockchains;
import app.keyconnect.api.client.model.BlockchainFee;
import app.keyconnect.api.client.model.BlockchainNetwork;
import app.keyconnect.api.client.model.BlockchainStatus;
import app.keyconnect.server.controllers.exceptions.BadRequestException;
import app.keyconnect.server.factories.BlockchainGatewayFactory;
import app.keyconnect.server.gateways.BlockchainGateway;
import app.keyconnect.server.gateways.exceptions.UnknownNetworkException;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BlockchainStatusController {
    private final BlockchainGatewayFactory gatewayFactory;

    @Autowired
    public BlockchainStatusController(BlockchainGatewayFactory gatewayFactory) {
        this.gatewayFactory = gatewayFactory;
    }

    @GetMapping(path={"/v1/blockchains/status"}, produces={"application/json"})
    public ResponseEntity<AvailableBlockchains> getBlockchainsStatus() {
        return ResponseEntity.ok((Object)new AvailableBlockchains().blockchains(Arrays.stream(this.gatewayFactory.getBlockchains()).map(arg_0 -> ((BlockchainGatewayFactory)this.gatewayFactory).getGateway(arg_0)).map(g -> new BlockchainStatus().chainId(g.getChainId()).networks(Arrays.stream(g.getNetworks()).map(n -> {
            try {
                return new BlockchainNetwork().group(n).servers(Arrays.asList(g.getNetworkServerStatus(n)));
            }
            catch (UnknownNetworkException e) {
                throw new BadRequestException((Throwable)e);
            }
        }).collect(Collectors.toList()))).collect(Collectors.toList())));
    }

    @GetMapping(path={"/v1/blockchains/{chainId}/status"}, produces={"application/json"})
    public ResponseEntity<BlockchainStatus> getBlockchainStatus(@PathVariable(value="chainId") String chainId, @RequestParam(value="network", required=false) String network) {
        BlockchainGateway g = this.gatewayFactory.getGateway(chainId);
        if (network != null) {
            return ResponseEntity.ok((Object)new BlockchainStatus().chainId(chainId).networks(Stream.of(network).map(n -> {
                try {
                    return new BlockchainNetwork().group(n).servers(Arrays.asList(g.getNetworkServerStatus(n)));
                }
                catch (UnknownNetworkException e) {
                    throw new BadRequestException((Throwable)e);
                }
            }).collect(Collectors.toList())));
        }
        return ResponseEntity.ok((Object)new BlockchainStatus().chainId(chainId).networks(Stream.of(g.getNetworks()).map(n -> {
            try {
                return new BlockchainNetwork().group(n).servers(Arrays.asList(g.getNetworkServerStatus(n)));
            }
            catch (UnknownNetworkException e) {
                throw new BadRequestException((Throwable)e);
            }
        }).collect(Collectors.toList())));
    }

    @GetMapping(path={"/v1/blockchains/{chainId}/fee"}, produces={"application/json"})
    public ResponseEntity<BlockchainFee> getBlockchainFee(@PathVariable(value="chainId") String chainId, @RequestParam(value="network", required=false) String network) throws UnknownNetworkException {
        BlockchainGateway gateway = this.gatewayFactory.getGateway(chainId);
        BlockchainFee fee = gateway.getFee(network);
        return ResponseEntity.ok((Object)fee);
    }
}

