/*
 * Decompiled with CFR 0.152.
 */
package app.keyconnect.server.factories;

import app.keyconnect.server.factories.BlockchainGatewayFactory;
import app.keyconnect.server.factories.configuration.YamlConfiguration;
import app.keyconnect.server.gateways.BlockchainGateway;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.PropertySource;

@PropertySource(value={"classpath:application.yml"})
public class AutoBlockchainGatewayFactory
implements BlockchainGatewayFactory {
    private final Map<String, BlockchainGateway> gateways;

    public AutoBlockchainGatewayFactory(YamlConfiguration configuration, ApplicationContext applicationContext) {
        this.gateways = new HashMap(configuration.getBlockchains().size());
        configuration.getBlockchains().forEach(b -> {
            String gatewayName = b.getGateway();
            BlockchainGateway gateway = (BlockchainGateway)applicationContext.getBean(gatewayName, BlockchainGateway.class);
            this.gateways.put(gateway.getChainId(), gateway);
        });
    }

    public BlockchainGateway getGateway(String blockchain) {
        return (BlockchainGateway)this.gateways.get(blockchain);
    }

    public String[] getBlockchains() {
        return this.gateways.keySet().toArray(new String[0]);
    }
}

