/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=WorkflowTriggerRequestBuilder.class)
public final class WorkflowTriggerRequest {
    @JsonProperty(value="__typename")
    private final String typeName;
    private final String key;
    private final Object actor;
    private final List<Object> recipients;
    private final String cancellationKey;
    @JsonAnySetter
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    WorkflowTriggerRequest(String typeName, String key, Object actor, List<Object> recipients, String cancellationKey, Map<String, Object> data) {
        this.typeName = typeName;
        this.key = key;
        this.actor = actor;
        this.recipients = recipients;
        this.cancellationKey = cancellationKey;
        this.data = data;
    }

    public static WorkflowTriggerRequestBuilder builder() {
        return new WorkflowTriggerRequestBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getKey() {
        return this.key;
    }

    public Object getActor() {
        return this.actor;
    }

    public List<Object> getRecipients() {
        return this.recipients;
    }

    public String getCancellationKey() {
        return this.cancellationKey;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowTriggerRequest)) {
            return false;
        }
        WorkflowTriggerRequest other = (WorkflowTriggerRequest)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Object this$actor = this.getActor();
        Object other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) {
            return false;
        }
        List<Object> this$recipients = this.getRecipients();
        List<Object> other$recipients = other.getRecipients();
        if (this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients)) {
            return false;
        }
        String this$cancellationKey = this.getCancellationKey();
        String other$cancellationKey = other.getCancellationKey();
        if (this$cancellationKey == null ? other$cancellationKey != null : !this$cancellationKey.equals(other$cancellationKey)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Object $actor = this.getActor();
        result = result * 59 + ($actor == null ? 43 : $actor.hashCode());
        List<Object> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        String $cancellationKey = this.getCancellationKey();
        result = result * 59 + ($cancellationKey == null ? 43 : $cancellationKey.hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowTriggerRequest(typeName=" + this.getTypeName() + ", key=" + this.getKey() + ", actor=" + this.getActor() + ", recipients=" + this.getRecipients() + ", cancellationKey=" + this.getCancellationKey() + ", data=" + this.getData() + ")";
    }

    public static class ObjectRecipientIdentifier {
        String id;
        String collection;

        ObjectRecipientIdentifier(String id, String collection) {
            this.id = id;
            this.collection = collection;
        }

        public static ObjectRecipientIdentifierBuilder builder() {
            return new ObjectRecipientIdentifierBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getCollection() {
            return this.collection;
        }

        public static class ObjectRecipientIdentifierBuilder {
            private String id;
            private String collection;

            ObjectRecipientIdentifierBuilder() {
            }

            public ObjectRecipientIdentifierBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ObjectRecipientIdentifierBuilder collection(String collection) {
                this.collection = collection;
                return this;
            }

            public ObjectRecipientIdentifier build() {
                return new ObjectRecipientIdentifier(this.id, this.collection);
            }

            public String toString() {
                return "WorkflowTriggerRequest.ObjectRecipientIdentifier.ObjectRecipientIdentifierBuilder(id=" + this.id + ", collection=" + this.collection + ")";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class WorkflowTriggerRequestBuilder {
        private String typeName;
        private String key;
        private Object actor;
        private String cancellationKey;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;
        List<Object> recipients;

        public WorkflowTriggerRequestBuilder addActor(ObjectRecipientIdentifier identifier) {
            this.actor = identifier;
            return this;
        }

        public WorkflowTriggerRequestBuilder addActor(String actor) {
            this.actor = actor;
            return this;
        }

        public WorkflowTriggerRequestBuilder addRecipient(String ... userIds) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, userIds);
            return this;
        }

        public WorkflowTriggerRequestBuilder addRecipient(Map<String, Object> recipient) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, recipient);
            return this;
        }

        public WorkflowTriggerRequestBuilder addRecipient(ObjectRecipientIdentifier identifier) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<Object>();
            }
            Collections.addAll(this.recipients, identifier);
            return this;
        }

        WorkflowTriggerRequestBuilder() {
        }

        @JsonProperty(value="__typename")
        public WorkflowTriggerRequestBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public WorkflowTriggerRequestBuilder key(String key) {
            this.key = key;
            return this;
        }

        public WorkflowTriggerRequestBuilder actor(Object actor) {
            this.actor = actor;
            return this;
        }

        public WorkflowTriggerRequestBuilder recipients(List<Object> recipients) {
            this.recipients = recipients;
            return this;
        }

        public WorkflowTriggerRequestBuilder cancellationKey(String cancellationKey) {
            this.cancellationKey = cancellationKey;
            return this;
        }

        @JsonAnySetter
        public WorkflowTriggerRequestBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        public WorkflowTriggerRequestBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public WorkflowTriggerRequestBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public WorkflowTriggerRequest build() {
            Map<String, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new WorkflowTriggerRequest(this.typeName, this.key, this.actor, this.recipients, this.cancellationKey, data);
        }

        public String toString() {
            return "WorkflowTriggerRequest.WorkflowTriggerRequestBuilder(typeName=" + this.typeName + ", key=" + this.key + ", actor=" + this.actor + ", recipients=" + this.recipients + ", cancellationKey=" + this.cancellationKey + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

