/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KnockMessageEventBuilder.class)
public final class KnockMessageEvent {
    @JsonProperty(value="__typename")
    private final String typeName;
    @JsonProperty(value="__cursor")
    private final String cursor;
    private final String id;
    private final String environment_id;
    private final Object recipient;
    private final String type;
    private final ZonedDateTime insertedAt;
    @JsonAnySetter
    private final Map<String, Object> data;

    public <T> T data(String key, Class<T> clazz) {
        if (this.data != null && this.data.containsKey(key)) {
            Object o = this.data.get(key);
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        return null;
    }

    KnockMessageEvent(String typeName, String cursor, String id, String environment_id, Object recipient, String type, ZonedDateTime insertedAt, Map<String, Object> data) {
        this.typeName = typeName;
        this.cursor = cursor;
        this.id = id;
        this.environment_id = environment_id;
        this.recipient = recipient;
        this.type = type;
        this.insertedAt = insertedAt;
        this.data = data;
    }

    public static KnockMessageEventBuilder builder() {
        return new KnockMessageEventBuilder();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getId() {
        return this.id;
    }

    public String getEnvironment_id() {
        return this.environment_id;
    }

    public Object getRecipient() {
        return this.recipient;
    }

    public String getType() {
        return this.type;
    }

    public ZonedDateTime getInsertedAt() {
        return this.insertedAt;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnockMessageEvent)) {
            return false;
        }
        KnockMessageEvent other = (KnockMessageEvent)o;
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$environment_id = this.getEnvironment_id();
        String other$environment_id = other.getEnvironment_id();
        if (this$environment_id == null ? other$environment_id != null : !this$environment_id.equals(other$environment_id)) {
            return false;
        }
        Object this$recipient = this.getRecipient();
        Object other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ZonedDateTime this$insertedAt = this.getInsertedAt();
        ZonedDateTime other$insertedAt = other.getInsertedAt();
        if (this$insertedAt == null ? other$insertedAt != null : !((Object)this$insertedAt).equals(other$insertedAt)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $environment_id = this.getEnvironment_id();
        result = result * 59 + ($environment_id == null ? 43 : $environment_id.hashCode());
        Object $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ZonedDateTime $insertedAt = this.getInsertedAt();
        result = result * 59 + ($insertedAt == null ? 43 : ((Object)$insertedAt).hashCode());
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "KnockMessageEvent(typeName=" + this.getTypeName() + ", cursor=" + this.getCursor() + ", id=" + this.getId() + ", environment_id=" + this.getEnvironment_id() + ", recipient=" + this.getRecipient() + ", type=" + this.getType() + ", insertedAt=" + this.getInsertedAt() + ", data=" + this.getData() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class KnockMessageEventBuilder {
        private String typeName;
        private String cursor;
        private String id;
        private String environment_id;
        private Object recipient;
        private String type;
        private ZonedDateTime insertedAt;
        private ArrayList<String> data$key;
        private ArrayList<Object> data$value;

        KnockMessageEventBuilder() {
        }

        @JsonProperty(value="__typename")
        public KnockMessageEventBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @JsonProperty(value="__cursor")
        public KnockMessageEventBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public KnockMessageEventBuilder id(String id) {
            this.id = id;
            return this;
        }

        public KnockMessageEventBuilder environment_id(String environment_id) {
            this.environment_id = environment_id;
            return this;
        }

        public KnockMessageEventBuilder recipient(Object recipient) {
            this.recipient = recipient;
            return this;
        }

        public KnockMessageEventBuilder type(String type) {
            this.type = type;
            return this;
        }

        public KnockMessageEventBuilder insertedAt(ZonedDateTime insertedAt) {
            this.insertedAt = insertedAt;
            return this;
        }

        @JsonAnySetter
        public KnockMessageEventBuilder data(String dataKey, Object dataValue) {
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            this.data$key.add(dataKey);
            this.data$value.add(dataValue);
            return this;
        }

        public KnockMessageEventBuilder data(Map<? extends String, ? extends Object> data) {
            if (data == null) {
                throw new NullPointerException("data cannot be null");
            }
            if (this.data$key == null) {
                this.data$key = new ArrayList();
                this.data$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : data.entrySet()) {
                this.data$key.add($lombokEntry.getKey());
                this.data$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public KnockMessageEventBuilder clearData() {
            if (this.data$key != null) {
                this.data$key.clear();
                this.data$value.clear();
            }
            return this;
        }

        public KnockMessageEvent build() {
            Map<String, Object> data;
            switch (this.data$key == null ? 0 : this.data$key.size()) {
                case 0: {
                    data = Collections.emptyMap();
                    break;
                }
                case 1: {
                    data = Collections.singletonMap(this.data$key.get(0), this.data$value.get(0));
                    break;
                }
                default: {
                    data = new LinkedHashMap(this.data$key.size() < 0x40000000 ? 1 + this.data$key.size() + (this.data$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.data$key.size(); ++$i) {
                        data.put(this.data$key.get($i), this.data$value.get($i));
                    }
                    data = Collections.unmodifiableMap(data);
                }
            }
            return new KnockMessageEvent(this.typeName, this.cursor, this.id, this.environment_id, this.recipient, this.type, this.insertedAt, data);
        }

        public String toString() {
            return "KnockMessageEvent.KnockMessageEventBuilder(typeName=" + this.typeName + ", cursor=" + this.cursor + ", id=" + this.id + ", environment_id=" + this.environment_id + ", recipient=" + this.recipient + ", type=" + this.type + ", insertedAt=" + this.insertedAt + ", data$key=" + this.data$key + ", data$value=" + this.data$value + ")";
        }
    }
}

