/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UserPreferenceBuilder {
    private Map<String, Object> channelTypes = new HashMap<String, Object>();
    private List<Map<String, String>> conditions = new LinkedList<Map<String, String>>();

    public UserPreferenceBuilder email(boolean enabled) {
        return this.custom("email", enabled);
    }

    public UserPreferenceBuilder sms(boolean enabled) {
        return this.custom("sms", enabled);
    }

    public UserPreferenceBuilder inAppFeed(boolean enabled) {
        return this.custom("in_app_feed", enabled);
    }

    public UserPreferenceBuilder chat(boolean enabled) {
        return this.custom("chat", enabled);
    }

    public UserPreferenceBuilder push(boolean enabled) {
        return this.custom("push", enabled);
    }

    public UserPreferenceBuilder custom(String key, boolean enabled) {
        this.channelTypes.put(key, enabled);
        return this;
    }

    public UserPreferenceBuilder condition(String variable, String operator, String argument) {
        this.conditions.add(Map.of("variable", variable, "operator", operator, "argument", argument));
        return this;
    }

    public Map<String, Object> build() {
        HashMap<String, Object> built = new HashMap<String, Object>();
        if (this.conditions.size() > 0) {
            built.put("conditions", List.copyOf(this.conditions));
        }
        if (this.channelTypes.size() > 0) {
            built.put("channel_types", Map.copyOf(this.channelTypes));
        }
        return built;
    }

    public Map<String, Object> buildChannelTypes() {
        return Map.copyOf(this.channelTypes);
    }

    public List<Map<String, String>> buildConditions() {
        return List.copyOf(this.conditions);
    }
}

