/*
 * Decompiled with CFR 0.152.
 */
package app.knock.api.resources;

import app.knock.api.exception.KnockClientResourceException;
import app.knock.api.http.KnockHttp;
import app.knock.api.model.BatchSetMessageStatusRequest;
import app.knock.api.model.BulkChannelMessageStatusRequest;
import app.knock.api.model.BulkOperation;
import app.knock.api.model.CursorResult;
import app.knock.api.model.KnockMessage;
import app.knock.api.model.KnockMessageActivity;
import app.knock.api.model.KnockMessageContent;
import app.knock.api.model.KnockMessageEvent;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class MessagesResource {
    private static final String BASE_RESOURCE_PATH = "v1/messages";
    private static final String BASE_CHANNELS_RESOURCE_PATH = "v1/channels";
    private final KnockHttp knockHttp;

    HttpUrl buildListResource(QueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, new String[0]);
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl buildChildResource(String id, String resource, QueryParams queryParams) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, id, resource);
        queryParams.addQueryParams(urlBuilder);
        return urlBuilder.build();
    }

    HttpUrl buildBatchResource(String status) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_RESOURCE_PATH, "batch", status);
        return urlBuilder.build();
    }

    HttpUrl buildChannelBatchResource(String channelId, String status) {
        HttpUrl.Builder urlBuilder = this.knockHttp.baseUrlBuilder(BASE_CHANNELS_RESOURCE_PATH, channelId, "messages", "bulk", status);
        return urlBuilder.build();
    }

    public CursorResult<KnockMessage> list(QueryParams queryParams) {
        HttpUrl url = this.buildListResource(queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<KnockMessage>>(){});
    }

    public KnockMessage get(String messageId) {
        HttpUrl url = this.buildChildResource(messageId, "", new QueryParams());
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<KnockMessage>(){});
    }

    public Optional<KnockMessage> oGet(String messageId) {
        try {
            return Optional.of(this.get(messageId));
        }
        catch (KnockClientResourceException e) {
            return Optional.empty();
        }
    }

    public CursorResult<KnockMessageEvent> events(String messageId, QueryParams queryParams) {
        HttpUrl url = this.buildChildResource(messageId, "events", queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<KnockMessageEvent>>(){});
    }

    public CursorResult<KnockMessageActivity> activities(String messageId, QueryParams queryParams) {
        HttpUrl url = this.buildChildResource(messageId, "activities", queryParams);
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<CursorResult<KnockMessageActivity>>(){});
    }

    public KnockMessageContent content(String messageId) {
        HttpUrl url = this.buildChildResource(messageId, "content", new QueryParams());
        Request request = this.knockHttp.baseJsonRequest(url).get().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<KnockMessageContent>(){});
    }

    public KnockMessage setStatus(String messageId, String status) {
        HttpUrl url = this.buildChildResource(messageId, status, new QueryParams());
        RequestBody body = this.knockHttp.objectToJsonRequestBody(true);
        Request request = this.knockHttp.baseJsonRequest(url).get().put(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<KnockMessage>(){});
    }

    public KnockMessage deleteStatus(String messageId, String status) {
        HttpUrl url = this.buildChildResource(messageId, status, new QueryParams());
        Request request = this.knockHttp.baseJsonRequest(url).delete().build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<KnockMessage>(){});
    }

    public List<KnockMessage> batchSetStatus(String status, BatchSetMessageStatusRequest bulkSetMessageStatusRequest) {
        HttpUrl url = this.buildBatchResource(status);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(bulkSetMessageStatusRequest);
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<List<KnockMessage>>(){});
    }

    public BulkOperation bulkSetStatusInChannel(String channelId, String status, BulkChannelMessageStatusRequest bulkChannelMessageStatusRequest) {
        HttpUrl url = this.buildChannelBatchResource(channelId, status);
        RequestBody body = this.knockHttp.objectToJsonRequestBody(bulkChannelMessageStatusRequest);
        Request request = this.knockHttp.baseJsonRequest(url).post(body).build();
        return this.knockHttp.executeWithResponseType(request, new TypeReference<BulkOperation>(){});
    }

    public MessagesResource(KnockHttp knockHttp) {
        this.knockHttp = knockHttp;
    }

    public KnockHttp getKnockHttp() {
        return this.knockHttp;
    }

    public String toString() {
        return "MessagesResource(knockHttp=" + this.getKnockHttp() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessagesResource)) {
            return false;
        }
        MessagesResource other = (MessagesResource)o;
        KnockHttp this$knockHttp = this.getKnockHttp();
        KnockHttp other$knockHttp = other.getKnockHttp();
        return !(this$knockHttp == null ? other$knockHttp != null : !this$knockHttp.equals(other$knockHttp));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KnockHttp $knockHttp = this.getKnockHttp();
        result = result * 59 + ($knockHttp == null ? 43 : $knockHttp.hashCode());
        return result;
    }

    public static final class QueryParams {
        private final Map<String, Object> params = new HashMap<String, Object>();

        public void pageSize(Integer pageSize) {
            this.params.put("page_size", pageSize);
        }

        public void after(String after) {
            this.params.put("after", after);
        }

        public void before(String before) {
            this.params.put("before", before);
        }

        public void tenant(String tenant) {
            this.params.put("tenant", tenant);
        }

        public void source(String source) {
            this.params.put("source", source);
        }

        public void status(String ... status) {
            this.params.put("status[]", Arrays.toString(status));
        }

        public void channel_id(String channel_id) {
            this.params.put("channel_id", channel_id);
        }

        public void addQueryParams(HttpUrl.Builder uriBuilder) {
            this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> uriBuilder.addQueryParameter((String)entry.getKey(), entry.getValue().toString()));
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public String toString() {
            return "MessagesResource.QueryParams(params=" + this.getParams() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryParams)) {
                return false;
            }
            QueryParams other = (QueryParams)o;
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }
    }
}

